/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.visualisation.notes;

import fr.inra.adonis.icons.IconsRegistry;
import fr.inra.adonis.modeleMetier.conceptsDeBase.Note;
import fr.inra.adonis.modeleMetier.plateforme.PuSurfacique;
import fr.inra.adonis.modeleMetier.saisieTerrain.MesureVariable;
import fr.inra.adonis.modeleMetier.saisieTerrain.MesureVariableAlphanumerique;
import fr.inra.adonis.modeleMetier.saisieTerrain.MesureVariableBooleen;
import fr.inra.adonis.modeleMetier.saisieTerrain.MesureVariableDate;
import fr.inra.adonis.modeleMetier.saisieTerrain.MesureVariableEntiere;
import fr.inra.adonis.modeleMetier.saisieTerrain.MesureVariableHeure;
import fr.inra.adonis.modeleMetier.saisieTerrain.MesureVariableReel;
import fr.inra.adonis.visualisation.notes.VisualisationNotesComponent;
import fr.inra.adonis.visualisation.notes.WrapperColonne;
import fr.inra.adonis.visualisation.notes.WrapperNotes;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class WrapperNotesLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private final VisualisationNotesComponent tabulaireComponent;

    public WrapperNotesLabelProvider(VisualisationNotesComponent tab) {
        this.tabulaireComponent = tab;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        WrapperNotes wrapobject = (WrapperNotes)element;
        WrapperColonne colonne = this.tabulaireComponent.getMapIdxColonne().get(columnIndex);
        if (colonne.isNotes() && !wrapobject.getNotes().isEmpty()) {
            for (Note note : wrapobject.getNotes()) {
                if (note.isSupprime()) continue;
                return IconsRegistry.IMG_NOTE;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        WrapperNotes wrapobject = (WrapperNotes)element;
        WrapperColonne colonne = this.tabulaireComponent.getMapIdxColonne().get(columnIndex);
        if (colonne.getStaticColonne() != null) {
            return WrapperNotesLabelProvider.getLabelForStatiqueColonne(wrapobject, colonne);
        }
        return "";
    }

    private static String getLabelForStatiqueColonne(WrapperNotes wrapobject, WrapperColonne colonne) {
        String label = "";
        if (colonne.getStaticColonne() == WrapperColonne.StaticColonne.X) {
            if (wrapobject.getIndividu() != null) {
                label = Integer.toString(wrapobject.getIndividu().getX());
            } else if (wrapobject.getParcelleUnitaire() != null && wrapobject.getParcelleUnitaire() instanceof PuSurfacique) {
                label = Integer.toString(wrapobject.getParcelleUnitaire().getX());
            }
        } else if (colonne.getStaticColonne() == WrapperColonne.StaticColonne.Y) {
            if (wrapobject.getIndividu() != null) {
                label = Integer.toString(wrapobject.getIndividu().getY());
            } else if (wrapobject.getParcelleUnitaire() != null && wrapobject.getParcelleUnitaire() instanceof PuSurfacique) {
                label = Integer.toString(wrapobject.getParcelleUnitaire().getY());
            }
        } else if (colonne.getStaticColonne() == WrapperColonne.StaticColonne.ID) {
            if (wrapobject.getIndividu() != null) {
                label = wrapobject.getIndividu().getIdRfidCodeBarre();
            } else if (wrapobject.getParcelleUnitaire() != null && wrapobject.getParcelleUnitaire() instanceof PuSurfacique) {
                label = ((PuSurfacique)wrapobject.getParcelleUnitaire()).getIdRfidCodeBarre();
            }
        } else if (colonne.getStaticColonne() == WrapperColonne.StaticColonne.NUMERO && wrapobject.getIndividu() != null) {
            label = String.valueOf(wrapobject.getIndividu().getNumero());
        } else if (colonne.getStaticColonne() == WrapperColonne.StaticColonne.PU) {
            label = wrapobject.getParcelleUnitaire() != null ? String.valueOf(wrapobject.getParcelleUnitaire().getNumero()) : "";
        } else if (colonne.getStaticColonne() == WrapperColonne.StaticColonne.SB) {
            label = wrapobject.getSousBloc() != null ? String.valueOf(wrapobject.getSousBloc().getNumero()) : "";
        } else if (colonne.getStaticColonne() == WrapperColonne.StaticColonne.B) {
            label = wrapobject.getBloc() != null ? String.valueOf(wrapobject.getBloc().getNumero()) : "";
        } else if (colonne.getStaticColonne() == WrapperColonne.StaticColonne.D) {
            label = wrapobject.getDispositif() != null ? wrapobject.getDispositif().getNom() : "";
        } else if (colonne.getStaticColonne() == WrapperColonne.StaticColonne.PF) {
            label = wrapobject.getPlateforme() != null ? wrapobject.getPlateforme().getNom() : "";
        } else if (colonne.getStaticColonne() == WrapperColonne.StaticColonne.T) {
            if (wrapobject.getIndividu() != null) {
                label = "Individu";
            } else if (wrapobject.getParcelleUnitaire() != null) {
                label = "Parcelle Unitaire";
            } else if (wrapobject.getSousBloc() != null) {
                label = "Sous Bloc";
            } else if (wrapobject.getBloc() != null) {
                label = "Bloc";
            } else if (wrapobject.getDispositif() != null) {
                label = "Dispositif";
            }
        }
        if (label == null) {
            label = "";
        }
        return label;
    }

    public static String getMesureVariableValeur(MesureVariable mesureVar) {
        if (mesureVar.getCodeEtat() != null) {
            return String.valueOf(mesureVar.getCodeEtat().getCode());
        }
        if (mesureVar instanceof MesureVariableAlphanumerique) {
            MesureVariableAlphanumerique mesure = (MesureVariableAlphanumerique)mesureVar;
            return mesure.getValeur();
        }
        if (mesureVar instanceof MesureVariableReel) {
            String val;
            MesureVariableReel mesure = (MesureVariableReel)mesureVar;
            int format = mesure.getVariable().getFormat() != "" ? Integer.valueOf(mesure.getVariable().getFormat()) : 3;
            String form = "0.";
            if (format > 0) {
                int i = 0;
                while (i < format) {
                    form = String.valueOf(form) + "0";
                    ++i;
                }
            }
            DecimalFormat df = new DecimalFormat(form);
            df.setRoundingMode(RoundingMode.DOWN);
            String string = val = mesure.getValeur() == Double.NaN ? "" : String.valueOf(df.format(mesure.getValeur()));
            if ("NaN".equals(val)) {
                val = "";
            }
            return val;
        }
        if (mesureVar instanceof MesureVariableEntiere) {
            MesureVariableEntiere mesure = (MesureVariableEntiere)mesureVar;
            String val = mesure.getValeur() == Integer.MIN_VALUE ? "" : String.valueOf(mesure.getValeur());
            return val;
        }
        if (mesureVar instanceof MesureVariableDate) {
            MesureVariableDate mesure = (MesureVariableDate)mesureVar;
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
            SimpleDateFormat dateFormatQ = new SimpleDateFormat("D");
            Calendar cal = Calendar.getInstance();
            String val = "";
            if (mesure.getValeur() != null) {
                cal.setTime(mesure.getValeur());
                if (mesure.getVariable().getFormat() != null && !mesure.getVariable().getFormat().isEmpty()) {
                    if (mesure.getVariable().getFormat().equals("quantieme")) {
                        val = cal.get(1) == 1 ? "" : dateFormatQ.format(mesure.getValeur());
                    }
                } else {
                    val = cal.get(1) == 1 ? "" : dateFormat.format(mesure.getValeur());
                }
            }
            return val;
        }
        if (mesureVar instanceof MesureVariableHeure) {
            MesureVariableHeure mesure = (MesureVariableHeure)mesureVar;
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm");
            String val = "";
            if (mesure.getValeur() != null) {
                val = dateFormat.format(mesure.getValeur());
            }
            return val;
        }
        if (mesureVar instanceof MesureVariableBooleen) {
            MesureVariableBooleen mesure = (MesureVariableBooleen)mesureVar;
            String val = mesure.isValeur() ? "Oui" : "Non";
            return val;
        }
        return "";
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        return Display.getCurrent().getSystemColor(2);
    }
}

