/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.visualisation.notes.filters;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class LineSelectorDialog
extends Dialog {
    private final TableColumn[] colonnes;
    private final String[] operateurs = new String[]{"<", "<=", "CONTIENT", "!=", "=", ">=", ">"};
    private Composite container;
    private ComboViewer comboColonne;
    private ComboViewer comboComparateur;
    private Text text;
    private Map<Integer, String> filtres;
    private Map<Integer, String> comparateurs;
    private Button btnAnnulerLeFiltre;

    protected LineSelectorDialog(Shell parentShell, TableColumn[] colonnes) {
        super(parentShell);
        this.setShellStyle(112);
        this.colonnes = colonnes;
        this.filtres = new HashMap<Integer, String>();
        this.comparateurs = new HashMap<Integer, String>();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Filtre sur les lignes");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.container = new Composite(composite, 0);
        this.container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.container.setLayout((Layout)new GridLayout(3, false));
        this.comboColonne = new ComboViewer(this.container, 0);
        this.comboColonne.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboColonne.setInput((Object)this.colonnes);
        this.comboColonne.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((TableColumn)element).getText();
            }
        });
        this.comboComparateur = new ComboViewer(this.container, 0);
        this.comboComparateur.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboComparateur.setInput((Object)this.operateurs);
        this.text = new Text(this.container, 2048);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(this.container, 0);
        new Label(this.container, 0);
        this.btnAnnulerLeFiltre = new Button(this.container, 0);
        this.btnAnnulerLeFiltre.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LineSelectorDialog.this.comboColonne.setSelection(null);
                LineSelectorDialog.this.comboComparateur.setSelection(null);
                LineSelectorDialog.this.okPressed();
            }
        });
        this.btnAnnulerLeFiltre.setText("Annuler le filtre");
        if (!this.filtres.isEmpty()) {
            for (Integer key : this.filtres.keySet()) {
                TableColumn selectedFiltre = this.colonnes[key];
                this.comboColonne.setSelection((ISelection)new StructuredSelection((Object)selectedFiltre));
                this.comboComparateur.setSelection((ISelection)new StructuredSelection((Object)this.comparateurs.get(key)));
                this.text.setText(this.filtres.get(key));
            }
        }
        return this.container;
    }

    protected Point getInitialSize() {
        return new Point(500, 250);
    }

    protected void okPressed() {
        this.filtres.clear();
        this.comparateurs.clear();
        if (!((StructuredSelection)this.comboColonne.getSelection()).isEmpty() && !((StructuredSelection)this.comboComparateur.getSelection()).isEmpty() && this.text.getText() != "") {
            TableColumn selectedCol = (TableColumn)((StructuredSelection)this.comboColonne.getSelection()).getFirstElement();
            String selectedComparateur = (String)((StructuredSelection)this.comboComparateur.getSelection()).getFirstElement();
            int i = 0;
            while (i < this.colonnes.length) {
                if (this.colonnes[i].equals(selectedCol)) {
                    this.filtres.put(i, this.text.getText());
                    this.comparateurs.put(i, selectedComparateur);
                    break;
                }
                ++i;
            }
        }
        super.okPressed();
    }

    public Map<Integer, String> getFiltres() {
        return this.filtres;
    }

    public void setFiltres(Map<Integer, String> filtres) {
        this.filtres = filtres;
    }

    public Map<Integer, String> getComparateurs() {
        return this.comparateurs;
    }

    public void setComparateurs(Map<Integer, String> comparateurs) {
        this.comparateurs = comparateurs;
    }
}

