/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique;

import fr.inra.adonis.core.util.DispositifUtil;
import fr.inra.adonis.core.util.EditorUtils;
import fr.inra.adonis.editeurgraphique.EditorModeEnum;
import fr.inra.adonis.editeurgraphique.part.AdonisRootEditPart;
import fr.inra.adonis.editeurgraphique.part.AppEditPartFactory;
import fr.inra.adonis.editeurgraphique.part.ObjetMetierPart;
import fr.inra.adonis.editeurgraphique.tools.GraphicalProperties;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.graphique.ConfigurationGraphique;
import fr.inra.adonis.modeleMetier.graphique.GraphiqueFactory;
import fr.inra.adonis.modeleMetier.graphique.Labels;
import fr.inra.adonis.modeleMetier.graphique.Origine;
import fr.inra.adonis.modeleMetier.graphique.StructureGraphique;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.Plateforme;
import fr.inra.adonis.persistance.AbstractDAOFactory;
import fr.inra.adonis.persistance.SiteDAO;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.swt.widgets.Shell;

public final class GraphicalConfigurator {
    public static final String GRAPHICAL_EDITOR = "graphicalEditor";
    public static final String EDITOR_MODE = "editorMode";
    public static final String GRAPHICAL_PROPERTIES = "graphicalProperties";
    public static final String ROOT_OBJETGRAPHIQUE = "uniteDeParcours";
    public static final String HAVE_TO_CREATE_SOUS_BLOC = "wantToCreateSousBloc";
    public static final String HAVE_TO_CREATE_PU_SURFACIQUE = "wantPuSufacique";
    public static final String TYPE_OBJET_TO_CREATE = "typeObjetToCreate";
    public static final String NATURE_ZHE = "natureZhe";
    public static final String SHIFT_PRESSED = "shiftPressed";
    public static final String LAYERS_TO_DISPLAY = "layersToDisplay";
    public static final String INDS_TO_DISPLAY = "indsToDisplay";
    public static final String PUS_TO_DISPLAY = "pusToDisplay";
    public static final String SSBLOCS_TO_DISPLAY = "ssblocsToDisplay";
    public static final String BLOCS_TO_DISPLAY = "blocsToDisplay";
    public static final String DISPOS_TO_DISPLAY = "disposToDisplay";
    public static final String SAISIE = "saisie";

    public static void configureGraphicalViewer(GraphicalViewer viewer, EditorModeEnum mode, ObjetMetier obj) {
        ObjetMetier root = obj;
        Plateforme pf = (Plateforme)DispositifUtil.getParent((ObjetMetier)obj, Plateforme.class);
        if (pf != null) {
            root = pf;
        } else {
            root = DispositifUtil.getParent((ObjetMetier)obj, Dispositif.class);
            if (root.eContainer() instanceof Dispositif) {
                root = (ObjetMetier)root.eContainer();
            }
            if (root.eContainer() != null && root.eContainer() instanceof Plateforme) {
                root = (ObjetMetier)root.eContainer();
            }
        }
        ConfigurationGraphique configuration = null;
        StructureGraphique structure = root.getStructureGraphique();
        if (structure == null) {
            structure = GraphicalConfigurator.createStructureGraphique(viewer.getControl().getShell(), root);
        }
        if (mode == EditorModeEnum.VISUALISATION_TERRAIN) {
            configuration = GraphicalConfigurator.createConfigurationGraphique();
        } else {
            SiteDAO site = AbstractDAOFactory.getInstance().getSiteDAO();
            configuration = site.getParametreSiteDAO().getConfigurationGraphique();
            boolean res = site.validateObject((EObject)root);
            if (res) {
                res = site.validateObject((EObject)structure);
            }
        }
        GraphicalProperties props = new GraphicalProperties(mode, structure, configuration);
        viewer.setProperty(GRAPHICAL_PROPERTIES, (Object)props);
        viewer.getControl().setBackground(ColorConstants.listBackground);
        viewer.setProperty(ROOT_OBJETGRAPHIQUE, (Object)obj);
        viewer.setEditPartFactory((EditPartFactory)new AppEditPartFactory());
        viewer.setRootEditPart((RootEditPart)new AdonisRootEditPart());
        viewer.setProperty("SnapToGrid.isEnabled", (Object)false);
        viewer.setProperty("SnapToGrid.isVisible", (Object)true);
        viewer.setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(props.getLargeurMaille(), props.getHauteurMaille()));
        viewer.setProperty("horizontal ruler", (Object)props.getHorizontalRulerProvider());
        viewer.setProperty("vertical ruler", (Object)props.getVerticalRulerProvider());
        viewer.setProperty("ruler$visibility", (Object)true);
        viewer.setProperty(EDITOR_MODE, (Object)mode);
        ObjetMetierPart.setWaitForRefresh(false);
    }

    private static StructureGraphique createStructureGraphique(Shell shell, final ObjetMetier root) {
        final StructureGraphique structure = GraphiqueFactory.eINSTANCE.createStructureGraphique();
        structure.setOrigine(Origine.HAUT_GAUCHE);
        structure.setHauteurMaille(50);
        structure.setLargeurMaille(50);
        if (AbstractDAOFactory.getInstance() != null && AbstractDAOFactory.getInstance().getSiteDAO() != null && AbstractDAOFactory.getInstance().getSiteDAO().getVerrouManager() != null && AbstractDAOFactory.getInstance().getSiteDAO().getVerrouManager().verrouilleObjetMetier(shell, root, false)) {
            TransactionalEditingDomain editDomain = EditorUtils.getTransactionalEditingDomain();
            editDomain.getCommandStack().execute((Command)new RecordingCommand(editDomain){

                protected void doExecute() {
                    structure.setObjetMetier(root);
                }
            });
        }
        return structure;
    }

    private static ConfigurationGraphique createConfigurationGraphique() {
        ConfigurationGraphique conf = GraphiqueFactory.eINSTANCE.createConfigurationGraphique();
        conf.setCouleurPlateforme("RGB{255,255,255}");
        conf.setTexturePlateforme(null);
        conf.setCouleurDispositif("RGB{153,255,153}");
        conf.setTextureDispositif(null);
        conf.setCouleurBloc("RGB{51,153,204}");
        conf.setTextureBloc(null);
        conf.setCouleurSousBloc("RGB{51,204,255}");
        conf.setTextureSousBloc(null);
        conf.setCouleurPuIndividuel("RGB{51,204,0}");
        conf.setTexturePuIndividuel(null);
        conf.setCouleurPuSurfacique("RGB{51,204,0}");
        conf.setTexturePuSurfacique(null);
        conf.setCouleurPuAnomalie("RGB{51,204,0}");
        conf.setTexturePuAnomalie(null);
        conf.setCouleurIndividu("RGB{255,255,0}");
        conf.setTextureIndividu(null);
        conf.setCouleurIndAnomalie("RGB{255,255,0}");
        conf.setTextureIndAnomalie(null);
        conf.setCouleurMailleVide("RGB{255,255,153}");
        conf.setTextureMailleVide(null);
        conf.getLabelsDispo().add((Object)Labels.DISPO_NOM);
        conf.getLabelsBloc().add((Object)Labels.BLOC_NUM);
        conf.getLabelsSousBloc().add((Object)Labels.SOUSBLOC_NUM);
        conf.getLabelsPuIndividuel().add((Object)Labels.PU_TRAITEMENT);
        conf.getLabelsPuSurfacique().add((Object)Labels.PU_TRAITEMENT);
        conf.getLabelsIndividu().add((Object)Labels.IND_NUM);
        return conf;
    }

    private GraphicalConfigurator() {
    }
}

