/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.actions;

import fr.inra.adonis.core.util.EditorUtils;
import fr.inra.adonis.editeurgraphique.AdonisGraphicalEditor;
import fr.inra.adonis.editeurgraphique.part.ObjetMetierPart;
import fr.inra.adonis.icons.IconsRegistry;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.AbstractBloc;
import fr.inra.adonis.modeleMetier.plateforme.Bloc;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.Individu;
import fr.inra.adonis.modeleMetier.plateforme.ParcelleUnitaire;
import fr.inra.adonis.modeleMetier.plateforme.Plateforme;
import fr.inra.adonis.modeleMetier.plateforme.PuIndividuel;
import fr.inra.adonis.modeleMetier.plateforme.SousBloc;
import fr.inra.adonis.persistance.AbstractDAOFactory;
import fr.inra.adonis.persistance.SiteDAO;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class ArrierePlanAction
extends DirectEditAction {
    public static final String ID = "fr.inra.adonis.editeurgraphique.actions.ArrierePlanAction";
    private final SiteDAO siteDao;
    private final ObjetMetier rootObjectMetier;
    private final List<ObjetMetierPart> selection = new ArrayList<ObjetMetierPart>();

    public ArrierePlanAction(IWorkbenchPart part, ObjetMetier rootObjectMetier) {
        super(part);
        this.rootObjectMetier = rootObjectMetier;
        this.siteDao = AbstractDAOFactory.getInstance().getSiteDAO();
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)IconsRegistry.IMG_ARRIEREPLAN));
        this.setText("Mettre \u00e0 l'arri\u00e8re plan");
    }

    protected boolean calculateEnabled() {
        this.selection.clear();
        AdonisGraphicalEditor editor = (AdonisGraphicalEditor)this.getWorkbenchPart();
        List list = editor.getGraphicalViewer().getSelectedEditParts();
        if (list == null) {
            return false;
        }
        for (Object o : list) {
            if (!(o instanceof ObjetMetierPart) || ((ObjetMetierPart)((Object)o)).getParent() == null) continue;
            this.selection.add((ObjetMetierPart)((Object)o));
        }
        if (this.selection.isEmpty()) {
            return false;
        }
        Shell shell = Display.getCurrent().getActiveShell();
        return this.siteDao.getVerrouManager().verrouilleRessourceAssociee(shell, (EObject)this.rootObjectMetier, false);
    }

    public void run() {
        TransactionalEditingDomain editDomain = EditorUtils.getTransactionalEditingDomain();
        EditorUtils.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(editDomain){

            protected void doExecute() {
                for (ObjetMetierPart select : ArrierePlanAction.this.selection) {
                    ObjetMetier selectObjetMetier = (ObjetMetier)select.getModel();
                    ObjetMetier parentObjetMetier = (ObjetMetier)selectObjetMetier.eContainer();
                    if (parentObjetMetier instanceof PuIndividuel) {
                        ECollections.move((List)((PuIndividuel)parentObjetMetier).getIndividus(), (int)0, (Object)((Individu)selectObjetMetier));
                        continue;
                    }
                    if (parentObjetMetier instanceof AbstractBloc) {
                        if (selectObjetMetier instanceof ParcelleUnitaire) {
                            ECollections.move((List)((AbstractBloc)parentObjetMetier).getParcellesUnitaire(), (int)0, (Object)((ParcelleUnitaire)selectObjetMetier));
                            continue;
                        }
                        if (!(selectObjetMetier instanceof SousBloc)) continue;
                        ECollections.move((List)((Bloc)parentObjetMetier).getSousBlocs(), (int)0, (Object)((SousBloc)selectObjetMetier));
                        continue;
                    }
                    if (parentObjetMetier instanceof Dispositif) {
                        ECollections.move((List)((Dispositif)parentObjetMetier).getBlocs(), (int)0, (Object)((Bloc)selectObjetMetier));
                        continue;
                    }
                    if (!(parentObjetMetier instanceof Plateforme)) continue;
                    ECollections.move((List)((Plateforme)parentObjetMetier).getDispositifs(), (int)0, (Object)((Dispositif)selectObjetMetier));
                }
            }
        });
        for (ObjetMetierPart select : this.selection) {
            select.refresh();
            if (select.getParent() == null) continue;
            select.getParent().refresh();
            for (Object child : select.getParent().getChildren()) {
                if (!(child instanceof EditPart)) continue;
                ((EditPart)child).refresh();
            }
        }
        AdonisGraphicalEditor editor = (AdonisGraphicalEditor)this.getWorkbenchPart();
        editor.getGraphicalViewer().getRootEditPart().getContents().refresh();
    }

    public String getId() {
        return ID;
    }
}

