/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.actions;

import fr.inra.adonis.editeurgraphique.AbstractGraphicalEditor;
import fr.inra.adonis.editeurgraphique.commands.PasteCommand;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.persistance.AbstractDAOFactory;
import fr.inra.adonis.persistance.SiteDAO;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class PasteAction
extends SelectionAction {
    private final SiteDAO siteDao;
    private final ObjetMetier rootObjectMetier;

    public PasteAction(IWorkbenchPart part, ObjetMetier rootObjectMetier) {
        super(part);
        this.rootObjectMetier = rootObjectMetier;
        this.siteDao = AbstractDAOFactory.getInstance().getSiteDAO();
        this.setLazyEnablementCalculation(true);
    }

    protected void init() {
        super.init();
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setText("Coller");
        this.setId(ActionFactory.PASTE.getId());
        this.setHoverImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.setEnabled(false);
    }

    private Command createPasteCommand() {
        Shell shell = Display.getCurrent().getActiveShell();
        if (!this.siteDao.getVerrouManager().verrouilleRessourceAssociee(shell, (EObject)this.rootObjectMetier, false)) {
            return null;
        }
        GraphicalViewer gv = ((AbstractGraphicalEditor)this.getWorkbenchPart()).getGraphicalViewer();
        return new PasteCommand(gv);
    }

    protected boolean calculateEnabled() {
        Command command = this.createPasteCommand();
        return command != null && command.canExecute();
    }

    public void run() {
        Command command = this.createPasteCommand();
        if (command != null && command.canExecute()) {
            this.execute(command);
        }
    }
}

