/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.cheminement.editpolicy;

import fr.inra.adonis.editeurgraphique.EditorModeEnum;
import fr.inra.adonis.editeurgraphique.cheminement.editpolicy.commands.ConnectionCreateCommand;
import fr.inra.adonis.editeurgraphique.cheminement.editpolicy.commands.ConnectionReconnectCommand;
import fr.inra.adonis.editeurgraphique.cheminement.factory.CheminementGraphFactory;
import fr.inra.adonis.editeurgraphique.model.Connection;
import fr.inra.adonis.editeurgraphique.part.ObjetMetierPart;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.Bloc;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.Individu;
import fr.inra.adonis.modeleMetier.plateforme.ParcelleUnitaire;
import fr.inra.adonis.modeleMetier.plateforme.SousBloc;
import fr.inra.adonis.modeleMetier.plateforme.TypeUniteParcours;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public class AppConnectionPolicy
extends GraphicalNodeEditPolicy {
    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        ObjetMetierPart targetNode = (ObjetMetierPart)this.getHost();
        GraphicalViewer gv = (GraphicalViewer)this.getHost().getViewer();
        if (gv.getProperty("editorMode") == EditorModeEnum.CREATION_CHEMINEMENT && this.isObjetAvailableWithNiveau((ObjetMetier)targetNode.getModel()) && CheminementGraphFactory.getInstance().isConnectionComplete((ObjetMetier)targetNode.getModel())) {
            ConnectionCreateCommand cmd = (ConnectionCreateCommand)request.getStartCommand();
            cmd.setTarget(targetNode);
            return cmd;
        }
        return null;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        ObjetMetierPart sourceNode = (ObjetMetierPart)this.getHost();
        GraphicalViewer gv = (GraphicalViewer)this.getHost().getViewer();
        if (gv.getProperty("editorMode") == EditorModeEnum.CREATION_CHEMINEMENT && this.isObjetAvailableWithNiveau((ObjetMetier)sourceNode.getModel()) && CheminementGraphFactory.getInstance().isConnectionCreate((ObjetMetier)sourceNode.getModel())) {
            ConnectionCreateCommand cmd = new ConnectionCreateCommand();
            cmd.setConnectionType(2);
            cmd.setSource(sourceNode);
            request.setStartCommand((Command)cmd);
            return cmd;
        }
        return null;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        Connection conn = (Connection)request.getConnectionEditPart().getModel();
        ObjetMetierPart sourceNode = (ObjetMetierPart)this.getHost();
        ConnectionReconnectCommand cmd = new ConnectionReconnectCommand(conn);
        cmd.setNewSource(sourceNode);
        return cmd;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        Connection conn = (Connection)request.getConnectionEditPart().getModel();
        ObjetMetierPart targetNode = (ObjetMetierPart)this.getHost();
        ConnectionReconnectCommand cmd = new ConnectionReconnectCommand(conn);
        cmd.setNewTarget(targetNode);
        return cmd;
    }

    private boolean isObjetAvailableWithNiveau(ObjetMetier objetMetier) {
        TypeUniteParcours niveau = CheminementGraphFactory.getInstance().getNiveau();
        if (objetMetier instanceof Individu && niveau == TypeUniteParcours.INDIVIDU) {
            return true;
        }
        if (objetMetier instanceof ParcelleUnitaire && niveau == TypeUniteParcours.PARCELLE) {
            return true;
        }
        if (objetMetier instanceof SousBloc && niveau == TypeUniteParcours.SOUS_BLOC) {
            return true;
        }
        if (objetMetier instanceof Bloc && niveau == TypeUniteParcours.BLOC) {
            return true;
        }
        return objetMetier instanceof Dispositif && niveau == TypeUniteParcours.DISPOSITIF;
    }
}

