/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.cheminement.editpolicy.commands;

import fr.inra.adonis.editeurgraphique.model.Connection;
import fr.inra.adonis.editeurgraphique.part.ObjetMetierPart;
import org.eclipse.gef.commands.Command;

public class ConnectionReconnectCommand
extends Command {
    private Connection conn;
    private ObjetMetierPart oldSource;
    private ObjetMetierPart oldTarget;
    private ObjetMetierPart newSource;
    private ObjetMetierPart newTarget;

    public ConnectionReconnectCommand(Connection conn) {
        if (conn == null) {
            throw new IllegalArgumentException();
        }
        this.conn = conn;
        this.oldSource = conn.getSource();
        this.oldTarget = conn.getTarget();
    }

    public boolean canExecute() {
        if (this.newSource != null) {
            return this.checkSourceReconnection();
        }
        if (this.newTarget != null) {
            return this.checkTargetReconnection();
        }
        return false;
    }

    private boolean checkSourceReconnection() {
        if (this.newSource == null) {
            return false;
        }
        if (((Object)((Object)this.newSource)).equals((Object)this.oldTarget)) {
            return false;
        }
        return ((Object)((Object)this.newSource)).getClass().equals(((Object)((Object)this.oldTarget)).getClass());
    }

    private boolean checkTargetReconnection() {
        if (this.newTarget == null) {
            return false;
        }
        if (((Object)((Object)this.oldSource)).equals((Object)this.newTarget)) {
            return false;
        }
        return ((Object)((Object)this.oldSource)).getClass().equals(((Object)((Object)this.newTarget)).getClass());
    }

    public void setNewSource(ObjetMetierPart source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.newSource = source;
        this.newTarget = null;
    }

    public void setNewTarget(ObjetMetierPart target) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        this.newSource = null;
        this.newTarget = target;
    }

    public void execute() {
        if (this.newSource != null) {
            this.conn.reconnect(this.newSource, this.oldTarget);
        } else if (this.newTarget != null) {
            this.conn.reconnect(this.oldSource, this.newTarget);
        } else {
            throw new IllegalStateException("Should not happen");
        }
    }

    public void undo() {
        this.conn.reconnect(this.oldSource, this.oldTarget);
    }
}

