/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.cheminement.factory;

import fr.inra.adonis.editeurgraphique.model.Connection;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.AbstractBloc;
import fr.inra.adonis.modeleMetier.plateforme.Bloc;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.Individu;
import fr.inra.adonis.modeleMetier.plateforme.PuSurfacique;
import fr.inra.adonis.modeleMetier.plateforme.SousBloc;
import fr.inra.adonis.modeleMetier.plateforme.TypeUniteParcours;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class CheminementGraphFactory {
    private TypeUniteParcours niveau;
    private List<ObjetMetier> individusFiltres;
    private List<Connection> connections;
    private static CheminementGraphFactory instance = CheminementGraphFactory.init();
    private boolean closeEditor = false;
    private boolean cancel = false;
    private List<ObjetMetier> listObjetsMetierOrdonnes = null;
    private final Set<ICheminementChange> listListenerCheminementChange = new HashSet<ICheminementChange>();

    public void addListenerCheminementChange(ICheminementChange listener) {
        this.listListenerCheminementChange.add(listener);
    }

    public void removeListenerCheminementChange(ICheminementChange listener) {
        this.listListenerCheminementChange.remove(listener);
    }

    public List<ObjetMetier> getListObjetsMetierOrdonnes() {
        return this.listObjetsMetierOrdonnes;
    }

    public void setListObjetsMetierOrdonnes(List<ObjetMetier> listObjetsMetierOrdonnes) {
        this.listObjetsMetierOrdonnes = listObjetsMetierOrdonnes;
    }

    private CheminementGraphFactory() {
    }

    private static CheminementGraphFactory init() {
        return new CheminementGraphFactory();
    }

    public static CheminementGraphFactory getInstance() {
        return instance;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }

    public void set(TypeUniteParcours niveauToDisplay, List<ObjetMetier> individus) {
        this.niveau = niveauToDisplay;
        this.individusFiltres = individus;
        this.connections = new ArrayList<Connection>();
    }

    public boolean isConnectionComplete(ObjetMetier objMetier) {
        return !this.isTypeConnectionExist(objMetier, TypeConnection.TARGET);
    }

    public boolean isConnectionCreate(ObjetMetier objMetier) {
        return !this.isTypeConnectionExist(objMetier, TypeConnection.SOURCE);
    }

    public boolean addConnection(Connection conn) {
        boolean valide = this.getConnections().add(conn);
        if (valide) {
            for (ICheminementChange listener : this.listListenerCheminementChange) {
                listener.cheminementChange(this);
            }
        }
        return valide;
    }

    public boolean deleteConnection(Connection conn) {
        boolean valide = this.getConnections().remove(conn);
        if (valide) {
            for (ICheminementChange listener : this.listListenerCheminementChange) {
                listener.cheminementChange(this);
            }
        }
        return valide;
    }

    public int getNbObjetsAParcourir() {
        return this.getNbObjetsByNiveau(this.niveau, this.getIndividusFiltres());
    }

    public int getNbObjetsParcourus() {
        return this.getConnections().size() + 1;
    }

    public List<ObjetMetier> getObjetsOrdonnes() {
        List<ObjetMetier> objetsMetierOrdonnes = null;
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        if (this.isCheminementCorrect()) {
            int nbIndividuAParcourir;
            int nbIndividusParcourus = this.getNbObjetsParcourus();
            if (nbIndividusParcourus < (nbIndividuAParcourir = this.getNbObjetsAParcourir())) {
                if (MessageDialog.openConfirm((Shell)shell, (String)"Cr\u00e9ation cheminement", (String)("Vous n'avez parcouru que " + nbIndividusParcourus + " " + this.niveau.getLiteral() + "s sur " + nbIndividuAParcourir + ". Confirmez ce choix."))) {
                    this.closeEditor = true;
                    objetsMetierOrdonnes = this.getObjetsConnectes();
                    this.setListObjetsMetierOrdonnes(objetsMetierOrdonnes);
                } else {
                    this.closeEditor = false;
                }
            } else {
                this.closeEditor = true;
                objetsMetierOrdonnes = this.getObjetsConnectes();
                this.setListObjetsMetierOrdonnes(objetsMetierOrdonnes);
                MessageDialog.openInformation((Shell)shell, (String)"Cr\u00e9ation cheminement", (String)"Le cheminement est correct.");
            }
        } else {
            this.closeEditor = false;
            MessageDialog.openError((Shell)shell, (String)"Erreur cr\u00e9ation cheminement", (String)"Le cheminement est incorrect et n'a pas \u00e9t\u00e9 enregistr\u00e9! Un cheminement doit poss\u00e8der au moins une connection et \u00eatre contigu.");
        }
        return objetsMetierOrdonnes;
    }

    private int getNbObjetsByNiveau(TypeUniteParcours niveau2, List<ObjetMetier> individusFiltres2) {
        if (niveau2.equals((Object)TypeUniteParcours.INDIVIDU)) {
            return individusFiltres2.size();
        }
        if (niveau2.equals((Object)TypeUniteParcours.PARCELLE)) {
            HashSet<Object> setParcelles = new HashSet<Object>();
            for (ObjetMetier obj : individusFiltres2) {
                if (obj instanceof Individu) {
                    setParcelles.add(((Individu)obj).getParcelleUnitaire());
                    continue;
                }
                if (!(obj instanceof PuSurfacique)) continue;
                setParcelles.add((PuSurfacique)obj);
            }
            return setParcelles.size();
        }
        if (niveau2.equals((Object)TypeUniteParcours.SOUS_BLOC)) {
            HashSet<SousBloc> setSousBlocs = new HashSet<SousBloc>();
            for (ObjetMetier obj : individusFiltres2) {
                AbstractBloc abstractBloc = null;
                if (obj instanceof Individu) {
                    abstractBloc = ((Individu)obj).getParcelleUnitaire().getAbstractBloc();
                } else if (obj instanceof PuSurfacique) {
                    abstractBloc = ((PuSurfacique)obj).getAbstractBloc();
                }
                if (abstractBloc == null || !(abstractBloc instanceof SousBloc)) continue;
                setSousBlocs.add((SousBloc)abstractBloc);
            }
            return setSousBlocs.size();
        }
        if (niveau2.equals((Object)TypeUniteParcours.BLOC)) {
            HashSet<Bloc> setBlocs = new HashSet<Bloc>();
            for (ObjetMetier obj : individusFiltres2) {
                AbstractBloc abstractBloc = null;
                if (obj instanceof Individu) {
                    abstractBloc = ((Individu)obj).getParcelleUnitaire().getAbstractBloc();
                } else if (obj instanceof PuSurfacique) {
                    abstractBloc = ((PuSurfacique)obj).getAbstractBloc();
                }
                Bloc bloc = null;
                if (abstractBloc != null) {
                    if (abstractBloc instanceof SousBloc) {
                        bloc = ((SousBloc)abstractBloc).getBloc();
                    } else if (abstractBloc instanceof Bloc) {
                        bloc = (Bloc)abstractBloc;
                    }
                }
                if (bloc == null) continue;
                setBlocs.add(bloc);
            }
            return setBlocs.size();
        }
        if (niveau2.equals((Object)TypeUniteParcours.DISPOSITIF)) {
            HashSet<Dispositif> setDispositifs = new HashSet<Dispositif>();
            for (ObjetMetier obj : individusFiltres2) {
                AbstractBloc abstractBloc = null;
                if (obj instanceof Individu) {
                    abstractBloc = ((Individu)obj).getParcelleUnitaire().getAbstractBloc();
                } else if (obj instanceof PuSurfacique) {
                    abstractBloc = ((PuSurfacique)obj).getAbstractBloc();
                }
                Bloc bloc = null;
                if (abstractBloc != null) {
                    if (abstractBloc instanceof SousBloc) {
                        bloc = ((SousBloc)abstractBloc).getBloc();
                    } else if (abstractBloc instanceof Bloc) {
                        bloc = (Bloc)abstractBloc;
                    }
                }
                if (bloc == null) continue;
                setDispositifs.add(bloc.getDispositif());
            }
            return setDispositifs.size();
        }
        return 0;
    }

    public boolean isCloseEditor() {
        return this.closeEditor;
    }

    private boolean isTypeConnectionExist(ObjetMetier objMetier, TypeConnection type) {
        for (Connection conn : this.getConnections()) {
            ObjetMetier objTarget;
            ObjetMetier objSource;
            if (!(type == TypeConnection.SOURCE ? EcoreUtil.equals((EObject)(objSource = (ObjetMetier)conn.getSource().getModel()), (EObject)objMetier) : type == TypeConnection.TARGET && EcoreUtil.equals((EObject)(objTarget = (ObjetMetier)conn.getTarget().getModel()), (EObject)objMetier))) continue;
            return true;
        }
        return false;
    }

    private boolean isCheminementCorrect() {
        return this.getConnections().size() > 0 && this.isCheminementContigu();
    }

    private boolean isCheminementContigu() {
        int nbObjetsMetier;
        int nbConnections = this.getConnections().size();
        return nbConnections + 1 == (nbObjetsMetier = this.getObjetsConnectes().size());
    }

    private List<ObjetMetier> getObjetsConnectes() {
        ArrayList<ObjetMetier> objetsMetier = new ArrayList<ObjetMetier>();
        if (this.getConnections().size() > 0) {
            ObjetMetier objMetier = this.getFirstObjetMetier();
            if (objMetier == null) {
                objMetier = (ObjetMetier)this.getConnections().get(0).getSource().getModel();
            }
            this.setObjetsMetier(objMetier, objetsMetier);
        }
        return objetsMetier;
    }

    private void setObjetsMetier(ObjetMetier objMetier, List<ObjetMetier> objetsMetier) {
        if (objMetier == null) {
            return;
        }
        if (!objetsMetier.contains(objMetier)) {
            objetsMetier.add(objMetier);
            this.setObjetsMetier(this.getTargetFromSource(objMetier), objetsMetier);
        } else {
            this.setObjetsMetier(null, objetsMetier);
        }
    }

    private ObjetMetier getFirstObjetMetier() {
        ObjetMetier firstObj = null;
        ArrayList<ObjetMetier> setObjets = new ArrayList<ObjetMetier>(this.getSetObjetsConnectes());
        if (setObjets.size() > 0) {
            firstObj = (ObjetMetier)setObjets.get(0);
        }
        for (ObjetMetier ind : this.getSetObjetsConnectes()) {
            if (!this.isTypeConnectionExist(ind, TypeConnection.SOURCE) || this.isTypeConnectionExist(ind, TypeConnection.TARGET)) continue;
            firstObj = ind;
        }
        return firstObj;
    }

    private Set<ObjetMetier> getSetObjetsConnectes() {
        HashSet<ObjetMetier> objets = new HashSet<ObjetMetier>();
        for (Connection conn : this.getConnections()) {
            ObjetMetier source = (ObjetMetier)conn.getSource().getModel();
            ObjetMetier target = (ObjetMetier)conn.getTarget().getModel();
            if (!objets.contains(source)) {
                objets.add(source);
            }
            if (objets.contains(target)) continue;
            objets.add(target);
        }
        return objets;
    }

    private ObjetMetier getTargetFromSource(ObjetMetier objMetier) {
        for (Connection conn : this.getConnections()) {
            ObjetMetier source = (ObjetMetier)conn.getSource().getModel();
            ObjetMetier target = (ObjetMetier)conn.getTarget().getModel();
            if (!EcoreUtil.equals((EObject)source, (EObject)objMetier)) continue;
            return target;
        }
        return null;
    }

    private List<Connection> getConnections() {
        if (this.connections == null) {
            this.connections = new ArrayList<Connection>();
        }
        return this.connections;
    }

    public List<ObjetMetier> getIndividusFiltres() {
        return this.individusFiltres;
    }

    public TypeUniteParcours getNiveau() {
        return this.niveau;
    }

    public static interface ICheminementChange {
        public void cheminementChange(CheminementGraphFactory var1);
    }

    private static enum TypeConnection {
        SOURCE,
        TARGET;

    }
}

