/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.commands;

import fr.inra.adonis.core.command.AbstractAdonisHandler;
import fr.inra.adonis.core.controle.Deplacement;
import fr.inra.adonis.core.controle.DeplacementInterditException;
import fr.inra.adonis.core.idgenerator.IdGeneratorService;
import fr.inra.adonis.core.rcp.AdonisLabelProvider;
import fr.inra.adonis.core.util.DispositifUtil;
import fr.inra.adonis.core.util.EditorUtils;
import fr.inra.adonis.core.util.UtilisateurCourant;
import fr.inra.adonis.droitsacces.util.DroitsAccesUtil;
import fr.inra.adonis.editeurgraphique.part.AdonisRootEditPart;
import fr.inra.adonis.editeurgraphique.part.ObjetMetierPart;
import fr.inra.adonis.editeurgraphique.part.ZoneDeTextePart;
import fr.inra.adonis.editeurgraphique.tools.GraphicalProperties;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.graphique.ZoneDeTexte;
import fr.inra.adonis.modeleMetier.plateforme.AbstractBloc;
import fr.inra.adonis.modeleMetier.plateforme.Bloc;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.EtatDispositif;
import fr.inra.adonis.modeleMetier.plateforme.Individu;
import fr.inra.adonis.modeleMetier.plateforme.ParcelleUnitaire;
import fr.inra.adonis.modeleMetier.plateforme.Plateforme;
import fr.inra.adonis.modeleMetier.plateforme.PuIndividuel;
import fr.inra.adonis.modeleMetier.plateforme.SousBloc;
import fr.inra.adonis.modeleMetier.plateforme.UniteDeParcours;
import fr.inra.adonis.modeleMetier.plateforme.ZheAvecEpaisseur;
import fr.inra.adonis.modeleMetier.protocole.Traitement;
import fr.inra.adonis.modeleMetier.utilisateur.TypeAction;
import fr.inra.adonis.modeleMetier.utilisateur.Utilisateur;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class PasteCommand
extends org.eclipse.gef.commands.Command
implements MouseListener,
MouseMoveListener,
KeyListener {
    private Rectangle originalBounds;
    private RectangleFigure figure;
    private final GraphicalViewer graphicalViewer;
    private final IFigure feedbackLayer;
    private Collection<ObjetMetierPart> objetMetierPartTocopy = new ArrayList<ObjetMetierPart>();
    private Collection<ZoneDeTextePart> zonePartTocopy = new ArrayList<ZoneDeTextePart>();
    private ObjetMetierPart parentPart;
    private ObjetMetier target;

    public PasteCommand(GraphicalViewer gv) {
        this.graphicalViewer = gv;
        this.feedbackLayer = LayerManager.Helper.find((EditPart)this.graphicalViewer.getRootEditPart()).getLayer((Object)"Feedback Layer");
    }

    public boolean canExecute() {
        Collection tocopy = (Collection)Clipboard.getDefault().getContents();
        if (tocopy == null || tocopy.isEmpty()) {
            return false;
        }
        Object firstObj = tocopy.iterator().next();
        if (firstObj instanceof ObjetMetierPart) {
            this.objetMetierPartTocopy = tocopy;
        } else if (firstObj instanceof ZoneDeTextePart) {
            this.zonePartTocopy = tocopy;
        } else {
            return false;
        }
        StructuredSelection selection = (StructuredSelection)this.graphicalViewer.getSelection();
        if (!selection.isEmpty() && selection.getFirstElement() instanceof ObjetMetierPart) {
            this.parentPart = (ObjetMetierPart)((Object)selection.getFirstElement());
            this.target = (ObjetMetier)this.parentPart.getModel();
        }
        if (this.zonePartTocopy.size() == 0 && (this.parentPart == null || this.target == null)) {
            return false;
        }
        for (ObjetMetierPart p : this.objetMetierPartTocopy) {
            ObjetMetier obj = (ObjetMetier)p.getModel();
            Dispositif disp = DispositifUtil.getDispositifFrom((EObject)obj);
            if (disp.getEtat() != EtatDispositif.CREE || !DroitsAccesUtil.isDroitsAccesDispositif((Utilisateur)UtilisateurCourant.getInstance(), (Dispositif)disp, (TypeAction)TypeAction.EDITER)) {
                return false;
            }
            if (this.canPaste(obj)) continue;
            return false;
        }
        return true;
    }

    private boolean canPaste(ObjetMetier obj) {
        if (obj instanceof Individu && !(this.target instanceof PuIndividuel)) {
            return false;
        }
        if (obj instanceof ParcelleUnitaire && !(this.target instanceof AbstractBloc)) {
            return false;
        }
        if (obj instanceof SousBloc && !(this.target instanceof Bloc)) {
            return false;
        }
        if (obj instanceof Bloc && !(this.target instanceof Dispositif)) {
            return false;
        }
        if (obj instanceof Dispositif && !(this.target instanceof Plateforme)) {
            return false;
        }
        return !(obj instanceof ZheAvecEpaisseur) || this.target instanceof UniteDeParcours;
    }

    public boolean canUndo() {
        return !this.objetMetierPartTocopy.isEmpty() || !this.zonePartTocopy.isEmpty();
    }

    public void execute() {
        if (!this.canExecute()) {
            return;
        }
        this.figure = new RectangleFigure();
        this.feedbackLayer.add((IFigure)this.figure);
        Rectangle bounds = null;
        for (ObjetMetierPart part : this.objetMetierPartTocopy) {
            if (bounds == null) {
                bounds = part.getFigure().getBounds();
                continue;
            }
            bounds.union(part.getFigure().getBounds());
        }
        for (ZoneDeTextePart zonePart : this.zonePartTocopy) {
            if (bounds == null) {
                bounds = zonePart.getFigure().getBounds();
                continue;
            }
            bounds.union(zonePart.getFigure().getBounds());
        }
        this.figure.setBounds(bounds);
        FigureUtilities.makeGhostShape((Shape)this.figure);
        this.figure.setLineStyle(3);
        this.figure.setForegroundColor(ColorConstants.white);
        this.originalBounds = new Rectangle(this.figure.getBounds());
        ((FigureCanvas)this.graphicalViewer.getControl()).addMouseListener((MouseListener)this);
        ((FigureCanvas)this.graphicalViewer.getControl()).addMouseMoveListener((MouseMoveListener)this);
        ((FigureCanvas)this.graphicalViewer.getControl()).addKeyListener((KeyListener)this);
    }

    private void copyAndTranslate() {
        GraphicalProperties properties = (GraphicalProperties)this.graphicalViewer.getProperty("graphicalProperties");
        Point pmove = new Point();
        double zoom = ((AdonisRootEditPart)this.graphicalViewer.getRootEditPart()).getZoomManager().getZoom();
        Rectangle originalBoundsWithZoom = new Rectangle(this.originalBounds).scale(zoom);
        pmove.x = (this.figure.getBounds().x - originalBoundsWithZoom.x) * properties.getCoeffX();
        pmove.y = (this.figure.getBounds().y - originalBoundsWithZoom.y) * properties.getCoeffY();
        Point scaledpmove = pmove.scale(1.0 / zoom);
        final Point newpoint = new Point();
        newpoint.x = (int)Math.round((double)scaledpmove.x / (double)properties.getLargeurMaille());
        newpoint.y = (int)Math.round((double)scaledpmove.y / (double)properties.getHauteurMaille());
        TransactionalEditingDomain editDomain = EditorUtils.getTransactionalEditingDomain();
        editDomain.getCommandStack().execute((Command)new RecordingCommand(editDomain){

            protected void doExecute() {
                if (PasteCommand.this.objetMetierPartTocopy.size() > 0) {
                    PasteCommand.this.performCopyObjetMetier(newpoint);
                }
                if (PasteCommand.this.zonePartTocopy.size() > 0) {
                    PasteCommand.this.performZonePartTocopy(newpoint);
                }
                PasteCommand.this.graphicalViewer.getRootEditPart().getContents().refresh();
            }
        });
        if (this.parentPart != null) {
            this.graphicalViewer.deselectAll();
            StructuredSelection selection = new StructuredSelection((Object)this.parentPart);
            this.graphicalViewer.setSelection((ISelection)selection);
        }
    }

    private ObjetMetier copyRecursive(ObjetMetier node) {
        return (ObjetMetier)EcoreUtil.copy((EObject)node);
    }

    private void performZonePartTocopy(Point newpoint) {
        for (ZoneDeTextePart part : this.zonePartTocopy) {
            ZoneDeTexte zoneSource = (ZoneDeTexte)part.getModel();
            ZoneDeTexte zoneCopy = (ZoneDeTexte)EcoreUtil.copy((EObject)zoneSource);
            ((Plateforme)zoneSource.eContainer()).getZonesDeTexte().add((Object)zoneCopy);
            zoneCopy.setX(zoneCopy.getX() + newpoint.x);
            zoneCopy.setY(zoneCopy.getY() + newpoint.y);
        }
    }

    private void performCopyObjetMetier(Point newpoint) {
        ArrayList<ObjetMetier> copied = new ArrayList<ObjetMetier>();
        Dispositif root = (Dispositif)DispositifUtil.getParent((ObjetMetier)this.target, Dispositif.class);
        for (ObjetMetierPart part : this.objetMetierPartTocopy) {
            ObjetMetier node = (ObjetMetier)part.getModel();
            ObjetMetier nodeCopy = this.copyRecursive(node);
            if (node instanceof Dispositif) {
                ((Dispositif)nodeCopy).setNom(String.valueOf(((Dispositif)nodeCopy).getNom()) + "_copie");
                ((Plateforme)this.target).getDispositifs().add((Object)((Dispositif)nodeCopy));
            } else if (node instanceof Bloc) {
                ((Dispositif)this.target).getBlocs().add((Object)((Bloc)nodeCopy));
            } else if (node instanceof SousBloc) {
                ((Bloc)this.target).getSousBlocs().add((Object)((SousBloc)nodeCopy));
            } else if (node instanceof ParcelleUnitaire) {
                if (root != null) {
                    Traitement t;
                    EList traits = root.getProtocoles().getTraitements();
                    if (!traits.contains(t = ((ParcelleUnitaire)nodeCopy).getTraitement())) {
                        ((ParcelleUnitaire)nodeCopy).setTraitement(null);
                        ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)AdonisLabelProvider.getInstance());
                        dialog.setTitle("Choix du traitement");
                        dialog.setMessage("Vous copiez une Parcelle d'un dispositif \u00e0 un autre. Merci de changer son traitement.");
                        dialog.setMultipleSelection(false);
                        dialog.setElements(traits.toArray());
                        if (dialog.open() != 0 || dialog.getResult().length != 1) continue;
                        ((ParcelleUnitaire)nodeCopy).setTraitement((Traitement)dialog.getResult()[0]);
                    }
                    ((AbstractBloc)this.target).getParcellesUnitaire().add((Object)((ParcelleUnitaire)nodeCopy));
                }
            } else if (node instanceof Individu) {
                ((PuIndividuel)this.target).getIndividus().add((Object)((Individu)nodeCopy));
            } else if (node instanceof ZheAvecEpaisseur) {
                ((UniteDeParcours)this.target).getZheAvecEpaisseurs().add((Object)((ZheAvecEpaisseur)nodeCopy));
            }
            copied.add(nodeCopy);
        }
        IdGeneratorService.recalculeNumeros((Dispositif)root);
        Deplacement d = new Deplacement();
        Deplacement.SensDeplacement sens = Deplacement.SensDeplacement.Horizontal;
        if (((Boolean)this.graphicalViewer.getProperty("shiftPressed")).booleanValue()) {
            sens = Deplacement.SensDeplacement.Vertical;
        }
        ObjetMetierPart.setWaitForRefresh(true);
        try {
            try {
                d.translation(copied, newpoint.x, newpoint.y, sens);
            }
            catch (DeplacementInterditException deplacementInterditException) {
                MessageDialog.openError((Shell)this.graphicalViewer.getControl().getShell(), (String)"D\u00e9placement interdit", (String)"Cette action provoque un d\u00e9placement non autoris\u00e9.");
                AbstractAdonisHandler.cancelCommand((String)"fr.inra.editeurgraphique", (String)"D\u00e9placement interdit");
                ObjetMetierPart.setWaitForRefresh(false);
            }
        }
        finally {
            ObjetMetierPart.setWaitForRefresh(false);
        }
    }

    public void mouseDown(MouseEvent e) {
        ((FigureCanvas)this.graphicalViewer.getControl()).removeMouseListener((MouseListener)this);
        ((FigureCanvas)this.graphicalViewer.getControl()).removeMouseMoveListener((MouseMoveListener)this);
        ((FigureCanvas)this.graphicalViewer.getControl()).removeKeyListener((KeyListener)this);
        this.feedbackLayer.remove((IFigure)this.figure);
        this.feedbackLayer.repaint();
        this.copyAndTranslate();
    }

    public void mouseMove(MouseEvent e) {
        if (e.x < 0 || e.y < 0) {
            return;
        }
        Rectangle rect = new Rectangle(this.originalBounds);
        double zoom = ((AdonisRootEditPart)this.graphicalViewer.getRootEditPart()).getZoomManager().getZoom();
        rect = rect.scale(zoom);
        int xscrolled = ((FigureCanvas)this.graphicalViewer.getControl()).getViewport().getHorizontalRangeModel().getValue();
        int yscrolled = ((FigureCanvas)this.graphicalViewer.getControl()).getViewport().getVerticalRangeModel().getValue();
        rect.x = e.x + xscrolled;
        rect.y = e.y + yscrolled;
        this.figure.setBounds(rect);
        this.figure.repaint();
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 27) {
            ((FigureCanvas)this.graphicalViewer.getControl()).removeMouseListener((MouseListener)this);
            ((FigureCanvas)this.graphicalViewer.getControl()).removeMouseMoveListener((MouseMoveListener)this);
            ((FigureCanvas)this.graphicalViewer.getControl()).removeKeyListener((KeyListener)this);
            if (this.feedbackLayer.getChildren().contains(this.figure)) {
                this.feedbackLayer.remove((IFigure)this.figure);
            }
            this.feedbackLayer.repaint();
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }
}

