/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.commands;

import fr.inra.adonis.core.util.DispositifUtil;
import fr.inra.adonis.editeurgraphique.commands.AbstractCommand;
import fr.inra.adonis.editeurgraphique.tools.GraphicalProperties;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.graphique.GraphiqueFactory;
import fr.inra.adonis.modeleMetier.graphique.ZoneDeTexte;
import fr.inra.adonis.modeleMetier.plateforme.Plateforme;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;

public class ZoneDeTexteCreateCommand
extends AbstractCommand {
    private final GraphicalViewer graphicalViewer;
    private final Rectangle constraint;

    public ZoneDeTexteCreateCommand(GraphicalViewer gv, Rectangle constraint, Object model) {
        super(model, gv.getControl().getShell());
        this.graphicalViewer = gv;
        this.constraint = constraint;
    }

    @Override
    public void executeCommand() {
        GraphicalProperties properties = (GraphicalProperties)this.graphicalViewer.getProperty("graphicalProperties");
        int x = properties.getCoeffX() * this.constraint.x / properties.getLargeurMaille();
        int y = properties.getCoeffY() * this.constraint.y / properties.getHauteurMaille();
        if (properties.getCoeffX() > 0) {
            ++x;
        }
        if (properties.getCoeffY() > 0) {
            ++y;
        }
        int largeur = this.constraint.width;
        int hauteur = this.constraint.height;
        ZoneDeTexte zdt = GraphiqueFactory.eINSTANCE.createZoneDeTexte();
        zdt.setCouleurFond("RGB{255,255,255}");
        zdt.setCouleurTexte("RGB{0,0,0}");
        zdt.setTailleTexte(12);
        zdt.setStyleTexte(0);
        zdt.setX(x);
        zdt.setY(y);
        if (hauteur < 1) {
            zdt.setHauteur(1);
        } else {
            zdt.setHauteur(hauteur);
        }
        if (largeur < 1) {
            zdt.setLongueur(1);
        } else {
            zdt.setLongueur(largeur);
        }
        zdt.setTexte("");
        zdt.setPolice("Arial");
        ObjetMetier root = (ObjetMetier)this.graphicalViewer.getContents().getModel();
        Plateforme pf = (Plateforme)DispositifUtil.getParent((ObjetMetier)root, Plateforme.class);
        if (pf != null) {
            pf.getZonesDeTexte().add((Object)zdt);
        }
    }
}

