/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.editpolicies;

import fr.inra.adonis.core.command.AbstractAdonisHandler;
import fr.inra.adonis.core.controle.Deplacement;
import fr.inra.adonis.core.controle.DeplacementInterditException;
import fr.inra.adonis.core.util.DispositifUtil;
import fr.inra.adonis.core.util.UtilisateurCourant;
import fr.inra.adonis.droitsacces.util.DroitsAccesUtil;
import fr.inra.adonis.editeurgraphique.commands.AbstractCommand;
import fr.inra.adonis.editeurgraphique.part.ObjetMetierPart;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.EtatDispositif;
import fr.inra.adonis.modeleMetier.utilisateur.TypeAction;
import fr.inra.adonis.modeleMetier.utilisateur.Utilisateur;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class TranslateCommand
extends AbstractCommand {
    private final List<ObjetMetier> objs = new ArrayList<ObjetMetier>();
    private int x;
    private int y;
    private Deplacement.SensDeplacement sens;
    private final GraphicalViewer graphicalViewer;
    private boolean executed = false;
    private final ObjetMetier objSource;
    private final List<ITranslationDoneListener> translationDoneListeners = new ArrayList<ITranslationDoneListener>();

    public void addTranslationDoneListener(ITranslationDoneListener listener) {
        this.translationDoneListeners.add(listener);
    }

    public void removeTranslationDoneListener(ITranslationDoneListener listener) {
        this.translationDoneListeners.remove(listener);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Deplacement.SensDeplacement getSens() {
        return this.sens;
    }

    public TranslateCommand(int x, int y, Deplacement.SensDeplacement sens, GraphicalViewer graphicalViewer, ObjetMetier objSource) {
        super(null, graphicalViewer.getControl().getShell());
        this.graphicalViewer = graphicalViewer;
        this.objSource = objSource;
        this.x = x;
        this.y = y;
        this.sens = sens;
    }

    public void changeProperties(int x, int y, Deplacement.SensDeplacement sens, ObjetMetier objSource) {
        if (this.objSource == objSource) {
            this.x = x;
            this.y = y;
            this.sens = sens;
        }
    }

    public void addObj(ObjetMetier o) {
        if (!this.objs.contains(o)) {
            this.objs.add(o);
        }
    }

    public boolean canExecute() {
        Deplacement d = new Deplacement();
        List objets = d.getObjetsADeplacer(this.objs, this.x, this.y, this.sens);
        HashSet<Dispositif> dispoADeplacer = new HashSet<Dispositif>();
        for (ObjetMetier obj : objets) {
            dispoADeplacer.add((Dispositif)DispositifUtil.getParent((ObjetMetier)obj, Dispositif.class));
        }
        boolean dispoModifiable = true;
        for (Dispositif dispo : dispoADeplacer) {
            if ((dispo.getEtat() == EtatDispositif.CREE || dispo.getEtat() == EtatDispositif.VALIDE) && DroitsAccesUtil.isDroitsAccesDispositif((Utilisateur)UtilisateurCourant.getInstance(), (Dispositif)dispo, (TypeAction)TypeAction.EDITER)) continue;
            dispoModifiable = false;
        }
        return dispoModifiable;
    }

    @Override
    public void executeCommand() {
        if (!(this.executed || this.x == 0 && this.y == 0)) {
            block8: {
                ObjetMetierPart.setWaitForRefresh(true);
                Deplacement d = new Deplacement();
                try {
                    try {
                        Deplacement.SensDeplacement sens2 = Deplacement.SensDeplacement.Horizontal;
                        if (((Boolean)this.graphicalViewer.getProperty("shiftPressed")).booleanValue()) {
                            sens2 = Deplacement.SensDeplacement.Vertical;
                        }
                        d.translation(this.objs, this.x, this.y, sens2);
                    }
                    catch (DeplacementInterditException deplacementInterditException) {
                        MessageDialog.openError((Shell)this.graphicalViewer.getControl().getShell(), (String)"D\u00e9placement interdit", (String)"Cette action provoque un d\u00e9placement non autoris\u00e9.");
                        AbstractAdonisHandler.cancelCommand((String)"fr.inra.editeurgraphique", (String)"D\u00e9placement interdit");
                        ObjetMetierPart.setWaitForRefresh(false);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    ObjetMetierPart.setWaitForRefresh(false);
                    throw throwable;
                }
                ObjetMetierPart.setWaitForRefresh(false);
            }
            this.graphicalViewer.getRootEditPart().getContents().refresh();
        }
        this.executed = true;
        for (ITranslationDoneListener listener : this.translationDoneListeners) {
            listener.translationDone();
        }
    }

    @Override
    public void preUndoRedo() {
        ObjetMetierPart.setWaitForRefresh(true);
    }

    @Override
    public void postUndoRedo() {
        ObjetMetierPart.setWaitForRefresh(false);
        this.graphicalViewer.getRootEditPart().getContents().refresh();
    }

    public static interface ITranslationDoneListener {
        public void translationDone();
    }
}

