/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.part;

import fr.inra.adonis.core.rcp.AdonisAdapterFactory;
import fr.inra.adonis.editeurgraphique.EditorModeEnum;
import fr.inra.adonis.editeurgraphique.editpolicies.DeletePolicies;
import fr.inra.adonis.editeurgraphique.figure.FlecheNordFigure;
import fr.inra.adonis.editeurgraphique.part.NodePart;
import fr.inra.adonis.editeurgraphique.part.ObjetMetierPart;
import fr.inra.adonis.editeurgraphique.tools.GraphicalProperties;
import fr.inra.adonis.icons.IconsRegistry;
import fr.inra.adonis.modeleMetier.graphique.FlecheNord;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.ui.views.properties.IPropertySource;

public class FlecheNordPart
extends AbstractGraphicalEditPart {
    private final Rectangle constraint = new Rectangle();
    protected AdapterImpl adapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            FlecheNordPart.this.propertyChanged(notification);
        }
    };

    public void activate() {
        super.activate();
        FlecheNord fleche = (FlecheNord)this.getModel();
        if (fleche != null) {
            fleche.eAdapters().add((Object)this.adapter);
        }
    }

    public void deactivate() {
        FlecheNord fleche = (FlecheNord)this.getModel();
        if (fleche != null) {
            fleche.eAdapters().remove((Object)this.adapter);
        }
        super.deactivate();
    }

    protected IFigure createFigure() {
        FlecheNordFigure figure = new FlecheNordFigure();
        this.refreshFigure();
        return figure;
    }

    protected void createEditPolicies() {
        if (this.getViewer().getProperty("editorMode") == EditorModeEnum.EDITION_PLATEFORME) {
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeletePolicies(null));
        }
    }

    protected void propertyChanged(Notification notification) {
        if (notification.getEventType() == 1 && notification.getOldValue() == notification.getNewValue()) {
            return;
        }
        if (notification.getEventType() == 8) {
            return;
        }
        if (notification.getEventType() == 1 && notification.getOldValue() == this.getParent().getModel() && notification.getNewValue() == null) {
            return;
        }
        if (notification.getEventType() == 1 && notification.getOldValue() == this.getParent() && notification.getNewValue() == null) {
            return;
        }
        if (notification.getEventType() == 1) {
            this.refreshFigure();
            EditPart parent = this.getParent();
            while (parent != null) {
                if (parent instanceof NodePart) {
                    ((NodePart)parent).setHasToRefresh(true);
                }
                parent = parent.getParent();
            }
            if (!ObjetMetierPart.waitForRefresh()) {
                this.getRoot().getContents().refresh();
            }
        } else {
            this.refreshVisuals();
        }
    }

    public Object getAdapter(Class key) {
        if (key == IPropertySource.class) {
            AdapterFactoryContentProvider adpterFactory = new AdapterFactoryContentProvider((AdapterFactory)AdonisAdapterFactory.getAdapterFactory());
            IPropertySource res = adpterFactory.getPropertySource(this.getModel());
            return res;
        }
        return super.getAdapter(key);
    }

    private void refreshFigure() {
        FlecheNord model = (FlecheNord)this.getModel();
        GraphicalProperties properties = (GraphicalProperties)this.getViewer().getProperty("graphicalProperties");
        this.constraint.x = properties.getCoeffX() * (properties.getLargeurMaille() * (model.getX() - properties.getCoeffX()));
        this.constraint.y = properties.getCoeffY() * (properties.getHauteurMaille() * (model.getY() - properties.getCoeffY()));
        this.constraint.width = IconsRegistry.IMG_FLECHE_NORD.getBounds().width;
        this.constraint.height = IconsRegistry.IMG_FLECHE_NORD.getBounds().height;
    }

    public void refreshVisuals() {
        FlecheNord model = (FlecheNord)this.getModel();
        FlecheNordFigure figure = (FlecheNordFigure)this.getFigure();
        figure.setBounds(this.constraint);
        figure.setRotationDegrees(model.getAngleNord());
        figure.setVisible(model.isAfficher());
        figure.repaint();
    }

    public List getModelChildren() {
        return new ArrayList();
    }

    public Rectangle getConstraint() {
        return this.constraint;
    }

    public DragTracker getDragTracker(Request request) {
        return new DragEditPartsTracker((EditPart)this){

            protected boolean isMove() {
                return true;
            }

            protected void updateTargetRequest() {
                this.repairStartLocation();
                ChangeBoundsRequest request = (ChangeBoundsRequest)this.getTargetRequest();
                request.setEditParts(this.getOperationSet());
                Dimension delta = this.getDragMoveDelta();
                request.setConstrainedMove(false);
                Point moveDelta = new Point(delta.width, delta.height);
                request.getExtendedData().clear();
                request.setMoveDelta(moveDelta);
                this.snapPoint(request);
                request.setLocation(this.getLocation());
                request.setType((Object)this.getCommandName());
            }
        };
    }

    public void showTargetFeedback(Request request) {
        GraphicalProperties properties = (GraphicalProperties)this.getViewer().getProperty("graphicalProperties");
        if (properties.isTooltipsActive()) {
            super.showTargetFeedback(request);
            Label tooltip = (Label)this.getFigure().getToolTip();
            if (tooltip == null) {
                tooltip = new Label();
                this.getFigure().setToolTip((IFigure)tooltip);
            }
            tooltip.setText("Fl\u00e8che Nord : pour modifier l'orientation, utiliser l'attribut 'Angle Nord' de la fen\u00eatre de propri\u00e9t\u00e9.");
        }
    }
}

