/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.part;

import com.swtdesigner.SWTResourceManager;
import fr.inra.adonis.core.rcp.AdonisAdapterFactory;
import fr.inra.adonis.core.util.ColorUtil;
import fr.inra.adonis.editeurgraphique.EditorModeEnum;
import fr.inra.adonis.editeurgraphique.editpolicies.DeletePolicies;
import fr.inra.adonis.editeurgraphique.editpolicies.ZdtCellEditorLocator;
import fr.inra.adonis.editeurgraphique.editpolicies.ZdtDirectEditManager;
import fr.inra.adonis.editeurgraphique.editpolicies.ZdtDirectEditPolicy;
import fr.inra.adonis.editeurgraphique.figure.ZoneDeTexteFigure;
import fr.inra.adonis.editeurgraphique.part.NodePart;
import fr.inra.adonis.editeurgraphique.part.ObjetMetierPart;
import fr.inra.adonis.editeurgraphique.tools.GraphicalProperties;
import fr.inra.adonis.modeleMetier.graphique.ZoneDeTexte;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.views.properties.IPropertySource;

public class ZoneDeTextePart
extends AbstractGraphicalEditPart {
    private final Rectangle constraint = new Rectangle();
    protected DirectEditManager manager;
    protected AdapterImpl adapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            ZoneDeTextePart.this.propertyChanged(notification);
        }
    };

    public void activate() {
        super.activate();
        ZoneDeTexte zone = (ZoneDeTexte)this.getModel();
        if (zone != null) {
            zone.eAdapters().add((Object)this.adapter);
        }
    }

    public void deactivate() {
        ZoneDeTexte zone = (ZoneDeTexte)this.getModel();
        if (zone != null) {
            zone.eAdapters().remove((Object)this.adapter);
        }
        super.deactivate();
    }

    protected IFigure createFigure() {
        ZoneDeTexteFigure figure = new ZoneDeTexteFigure();
        figure.setBorder((Border)new LineBorder(1));
        figure.setOpaque(true);
        this.refreshFigure();
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ZdtDirectEditPolicy());
        if (this.getViewer().getProperty("editorMode") == EditorModeEnum.EDITION_PLATEFORME) {
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeletePolicies(null));
        }
    }

    protected void propertyChanged(Notification notification) {
        if (notification.getEventType() == 1 && notification.getOldValue() == notification.getNewValue()) {
            return;
        }
        if (notification.getEventType() == 8) {
            return;
        }
        if (notification.getEventType() == 1 && notification.getOldValue() == this.getParent().getModel() && notification.getNewValue() == null) {
            return;
        }
        if (notification.getEventType() == 1 && notification.getOldValue() == this.getParent() && notification.getNewValue() == null) {
            return;
        }
        if (notification.getEventType() == 1) {
            this.refreshFigure();
            EditPart parent = this.getParent();
            while (parent != null) {
                if (parent instanceof NodePart) {
                    ((NodePart)parent).setHasToRefresh(true);
                }
                parent = parent.getParent();
            }
            if (!ObjetMetierPart.waitForRefresh()) {
                this.getRoot().getContents().refresh();
            }
        } else {
            this.refreshVisuals();
        }
    }

    public Object getAdapter(Class key) {
        if (key == IPropertySource.class) {
            AdapterFactoryContentProvider adpterFactory = new AdapterFactoryContentProvider((AdapterFactory)AdonisAdapterFactory.getAdapterFactory());
            IPropertySource res = adpterFactory.getPropertySource(this.getModel());
            return res;
        }
        return super.getAdapter(key);
    }

    private void refreshFigure() {
        ZoneDeTexte model = (ZoneDeTexte)this.getModel();
        GraphicalProperties properties = (GraphicalProperties)this.getViewer().getProperty("graphicalProperties");
        this.constraint.x = properties.getCoeffX() * (properties.getLargeurMaille() * (model.getX() - properties.getCoeffX()));
        this.constraint.y = properties.getCoeffY() * (properties.getHauteurMaille() * (model.getY() - properties.getCoeffY()));
        this.constraint.width = model.getLongueur();
        this.constraint.height = model.getHauteur();
    }

    public void refreshVisuals() {
        ZoneDeTexte model = (ZoneDeTexte)this.getModel();
        ZoneDeTexteFigure figure = (ZoneDeTexteFigure)this.getFigure();
        Color c = ColorUtil.getColor((String)model.getCouleurFond());
        if (c != null) {
            figure.setBackgroundColor(c);
        }
        if ((c = ColorUtil.getColor((String)model.getCouleurTexte())) != null) {
            figure.setForegroundColor(c);
        }
        Font f = SWTResourceManager.getFont((String)model.getPolice(), (int)model.getTailleTexte(), (int)model.getStyleTexte());
        figure.setFont(f);
        if (model.getTexte() == null || model.getTexte().isEmpty()) {
            figure.setText("description");
        } else {
            figure.setText(model.getTexte());
        }
        figure.setBounds(this.constraint);
        figure.repaint();
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" && request instanceof DirectEditRequest) {
            if (this.manager == null) {
                ZoneDeTexteFigure figure = (ZoneDeTexteFigure)this.getFigure();
                this.manager = new ZdtDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, new ZdtCellEditorLocator(figure), figure);
            }
            this.manager.show();
        }
    }

    protected void performDirectEdit() {
    }

    public List getModelChildren() {
        return new ArrayList();
    }

    public Rectangle getConstraint() {
        return this.constraint;
    }

    public DragTracker getDragTracker(Request request) {
        return new DragEditPartsTracker((EditPart)this){

            protected boolean isMove() {
                return true;
            }

            protected void updateTargetRequest() {
                this.repairStartLocation();
                ChangeBoundsRequest request = (ChangeBoundsRequest)this.getTargetRequest();
                request.setEditParts(this.getOperationSet());
                Dimension delta = this.getDragMoveDelta();
                request.setConstrainedMove(false);
                Point moveDelta = new Point(delta.width, delta.height);
                request.getExtendedData().clear();
                request.setMoveDelta(moveDelta);
                this.snapPoint(request);
                request.setLocation(this.getLocation());
                request.setType((Object)this.getCommandName());
            }
        };
    }
}

