/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.tools;

import com.swtdesigner.SWTResourceManager;
import fr.inra.adonis.editeurgraphique.part.AdonisRootEditPart;
import fr.inra.adonis.editeurgraphique.part.NodePart;
import fr.inra.adonis.editeurgraphique.rulers.custom.AdonisRulerComposite;
import fr.inra.adonis.editeurgraphique.rulers.custom.AdonisRulerEditPart;
import fr.inra.adonis.editeurgraphique.tools.GraphicalProperties;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.export.GraphicsSVG;
import org.eclipse.swt.graphics.FontData;

public final class SVGImageExporter {
    private SVGImageExporter() {
    }

    public static void export(AdonisRootEditPart rootEditPart, AdonisRulerComposite rulerComposite, List<IFigure> figures, OutputStream outputStream) {
        IFigure graphAdonis = figures.get(0);
        if (rootEditPart.getContents() instanceof NodePart) {
            graphAdonis = ((NodePart)rootEditPart.getContents()).getFigure();
        }
        Rectangle bounds = graphAdonis.getBounds();
        AdonisRootEditPart child = rootEditPart;
        while (child.getChildren() != null && !child.getChildren().isEmpty()) {
            child = (EditPart)child.getChildren().get(0);
        }
        GraphicalProperties properties = (GraphicalProperties)rootEditPart.getViewer().getProperty("graphicalProperties");
        properties.getOrigine();
        RootEditPart leftRuleRootPart = rulerComposite.getLeft().getContents().getRoot();
        RootEditPart topRuleRootPart = rulerComposite.getTop().getContents().getRoot();
        AdonisRulerEditPart leftRulePart = (AdonisRulerEditPart)leftRuleRootPart.getContents();
        AdonisRulerEditPart topRulePart = (AdonisRulerEditPart)topRuleRootPart.getContents();
        Dimension ruleLeftDimension = leftRulePart.getFigure().getSize();
        Dimension ruleTopDimension = topRulePart.getFigure().getSize();
        bounds.expand(ruleLeftDimension.width, ruleTopDimension.height);
        GraphicsSVG graphics = GraphicsSVG.getInstance((Rectangle)bounds.getTranslated(bounds.getLocation().negate()));
        graphics.translate(bounds.getLocation().negate());
        FontData[] fds = graphics.getFont().getFontData();
        FontData[] fontDataArray = fds;
        if (fds.length != 0) {
            FontData fd = fontDataArray[0];
            int h = Math.max(2, fd.getHeight() - 1);
            graphics.setFont(SWTResourceManager.getFont((String)fd.getName(), (int)h, (int)fd.getStyle()));
        }
        graphics.pushState();
        for (IFigure fig : figures) {
            fig.validate();
            fig.paint((Graphics)graphics);
            graphics.restoreState();
        }
        graphics.translate(bounds.x, 0);
        leftRulePart.getFigure().paint((Graphics)graphics);
        graphics.restoreState();
        graphics.translate(bounds.getRight().x - ruleLeftDimension.width, 0);
        leftRulePart.getFigure().paint((Graphics)graphics);
        graphics.restoreState();
        graphics.translate(0, bounds.y);
        topRulePart.getFigure().paint((Graphics)graphics);
        graphics.restoreState();
        graphics.translate(0, bounds.getBottom().y - ruleTopDimension.height);
        topRulePart.getFigure().paint((Graphics)graphics);
        graphics.restoreState();
        graphics.popState();
        try {
            graphics.getSVGGraphics2D().stream((Writer)new BufferedWriter(new OutputStreamWriter(outputStream)));
        }
        catch (SVGGraphics2DIOException e) {
            throw new RuntimeException("Error while saving image", e);
        }
    }
}

