/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.tools;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;

public class ShrinkPolygon {
    private final PointList points;

    public ShrinkPolygon(PointList points) {
        this.points = points;
    }

    private void normalize(double[] p) {
        double length = Math.sqrt(p[0] * p[0] + p[1] * p[1]);
        p[0] = p[0] / length;
        p[1] = p[1] / length;
    }

    private double[] getDirectorVector(int index) {
        double[] res = new double[2];
        int nextPoint = (index + this.points.size() + 1) % this.points.size();
        int currentPoint = (index + this.points.size()) % this.points.size();
        res[0] = this.points.getPoint((int)nextPoint).x - this.points.getPoint((int)currentPoint).x;
        res[1] = this.points.getPoint((int)nextPoint).y - this.points.getPoint((int)currentPoint).y;
        this.normalize(res);
        return res;
    }

    private double crossProductZ(double[] a, double[] b) {
        return a[0] * b[1] - a[1] * b[0];
    }

    public List<Point> getShrinkedPolygon(double innerMargin) {
        ArrayList<Point> res = new ArrayList<Point>();
        if (this.points.size() == 0) {
            return res;
        }
        innerMargin = (double)this.getOrientation() * innerMargin;
        int i = 0;
        while (i < this.points.size()) {
            double[] u;
            double[] v = this.getDirectorVector(i);
            double sinAlpha = -this.crossProductZ(v, u = this.getDirectorVector(i - 1));
            if (Math.abs(sinAlpha) > 1.0E-12) {
                double k = innerMargin / sinAlpha;
                double dx = k * v[0] - k * u[0];
                double dy = k * v[1] - k * u[1];
                double x = this.points.getPoint((int)i).x;
                double y = this.points.getPoint((int)i).y;
                Point p = new Point();
                p.x = (int)(x + dx);
                p.y = (int)(y + dy);
                res.add(p);
            }
            ++i;
        }
        return res;
    }

    private int getOrientation() {
        double[] b;
        int indexMini = 0;
        int i = 1;
        while (i < this.points.size()) {
            if (this.points.getPoint((int)i).x < this.points.getPoint((int)indexMini).x) {
                indexMini = i;
            } else if (this.points.getPoint((int)i).x == this.points.getPoint((int)indexMini).x && this.points.getPoint((int)i).y < this.points.getPoint((int)indexMini).y) {
                indexMini = i;
            }
            ++i;
        }
        double[] a = this.getDirectorVector(indexMini);
        if (this.crossProductZ(a, b = this.getDirectorVector(indexMini - 1)) < 0.0) {
            return 1;
        }
        return -1;
    }
}

