/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.wizard;

import fr.inra.adonis.core.controle.Deplacement;
import fr.inra.adonis.core.controle.DeplacementInterditException;
import fr.inra.adonis.core.rcp.AdonisLabelProvider;
import fr.inra.adonis.core.util.ui.DialogUtil;
import fr.inra.adonis.editeurgraphique.EditorModeEnum;
import fr.inra.adonis.editeurgraphique.composite.GraphicalComposite;
import fr.inra.adonis.editeurgraphique.part.AdonisRootEditPart;
import fr.inra.adonis.editeurgraphique.part.ObjetMetierPart;
import fr.inra.adonis.editeurgraphique.tools.GraphicalProperties;
import fr.inra.adonis.editeurgraphique.tools.ObjectSelectionUtil;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.Plateforme;
import fr.inra.adonis.modeleMetier.plateforme.TypeUniteParcours;
import java.util.ArrayList;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PositionnementGraphiqueDialog
extends Dialog
implements MouseListener,
MouseMoveListener {
    protected Shell shell;
    private final Plateforme plateforme;
    private final Dispositif dispositif;
    private GraphicalViewer graphicalViewer;
    private IFigure feedbackLayer;
    private Rectangle originalBounds;
    private RectangleFigure figure;
    private boolean placed = false;

    public PositionnementGraphiqueDialog(Shell parent, Plateforme pf, Dispositif d) {
        super(parent, 65536);
        this.setText("Positionnement de dispositif");
        this.plateforme = pf;
        this.dispositif = d;
    }

    public boolean open() {
        this.createContents();
        this.shell.setMaximized(true);
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.placed;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 66672);
        this.shell.setSize(800, 600);
        this.shell.setText(this.getText());
        this.shell.setLayout((Layout)new FillLayout(256));
        GraphicalComposite comp = new GraphicalComposite((Composite)this.shell, "Positionnement du dispositif " + this.dispositif.getNom());
        comp.setEditorMode(EditorModeEnum.EDITION_PLATEFORME);
        comp.createToolBar();
        comp.setLayersToDisplay(TypeUniteParcours.DISPOSITIF);
        comp.setCancelListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PositionnementGraphiqueDialog.this.placed = false;
            }
        });
        comp.setRootObjetMetier((ObjetMetier)this.plateforme);
        comp.createRulerGraphicalViewer();
        this.graphicalViewer = comp.getGraphicalViewer();
        ArrayList<Object> dispositifsToDisplay = new ArrayList<Object>();
        for (Dispositif d : this.plateforme.getDispositifs()) {
            if (d == this.dispositif) continue;
            dispositifsToDisplay.add(d);
        }
        dispositifsToDisplay.add(this.plateforme);
        this.graphicalViewer.setProperty("disposToDisplay", dispositifsToDisplay);
        this.feedbackLayer = LayerManager.Helper.find((EditPart)this.graphicalViewer.getRootEditPart()).getLayer((Object)"Feedback Layer");
        this.figure = new RectangleFigure();
        this.feedbackLayer.add((IFigure)this.figure);
        ObjetMetierPart root = (ObjetMetierPart)this.graphicalViewer.getContents();
        ObjetMetierPart part = (ObjetMetierPart)ObjectSelectionUtil.parcoursEditParts((EditPart)root, (ObjetMetier)this.dispositif);
        part.getFigure().setVisible(false);
        Rectangle bounds = part.getFigure().getBounds();
        if (bounds.isEmpty()) {
            this.placed = true;
        }
        this.figure.setBounds(bounds);
        FigureUtilities.makeGhostShape((Shape)this.figure);
        this.figure.setLineStyle(3);
        this.figure.setForegroundColor(ColorConstants.white);
        this.originalBounds = new Rectangle(this.figure.getBounds());
        ((FigureCanvas)this.graphicalViewer.getControl()).addMouseListener((MouseListener)this);
        ((FigureCanvas)this.graphicalViewer.getControl()).addMouseMoveListener((MouseMoveListener)this);
        DialogUtil.placeDialogInCenter((Shell)this.getParent(), (Shell)this.shell);
    }

    private void translate() {
        Deplacement.SensDeplacement sens = Deplacement.SensDeplacement.Horizontal;
        double zoom = ((AdonisRootEditPart)this.graphicalViewer.getRootEditPart()).getZoomManager().getZoom();
        if (((Boolean)this.graphicalViewer.getProperty("shiftPressed")).booleanValue()) {
            sens = Deplacement.SensDeplacement.Vertical;
        }
        GraphicalProperties properties = (GraphicalProperties)this.graphicalViewer.getProperty("graphicalProperties");
        Point pmove = new Point();
        Rectangle originalBoundsWithZoom = new Rectangle(this.originalBounds).scale(zoom);
        pmove.x = (this.figure.getBounds().x - originalBoundsWithZoom.x) * properties.getCoeffX();
        pmove.y = (this.figure.getBounds().y - originalBoundsWithZoom.y) * properties.getCoeffY();
        Point scaledpmove = pmove.scale(1.0 / zoom);
        Point newpoint = new Point();
        newpoint.x = (int)Math.round((double)scaledpmove.x / (double)properties.getLargeurMaille());
        newpoint.y = (int)Math.round((double)scaledpmove.y / (double)properties.getHauteurMaille());
        Deplacement d = new Deplacement();
        ArrayList<Dispositif> list = new ArrayList<Dispositif>();
        list.add(this.dispositif);
        ObjetMetierPart.setWaitForRefresh(true);
        try {
            d.translation(list, newpoint.x, newpoint.y, sens);
            ObjetMetierPart.setWaitForRefresh(false);
            this.graphicalViewer.getRootEditPart().getContents().refresh();
            this.placed = true;
        }
        catch (DeplacementInterditException e) {
            MessageDialog.openError((Shell)this.graphicalViewer.getControl().getShell(), (String)"D\u00e9placement interdit", (String)("Cette action provoque un d\u00e9placement non autoris\u00e9.\nDispositif concern\u00e9: " + AdonisLabelProvider.getInstance().getText((Object)e.getDispositif()) + "\n-Etat du dispositif: " + e.getDispositif().getEtat().getName()));
            this.placed = false;
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (this.placed) {
            return;
        }
        if ((e.stateMask & 0x20000) != 0) {
            this.graphicalViewer.setProperty("shiftPressed", (Object)true);
        } else {
            this.graphicalViewer.setProperty("shiftPressed", (Object)false);
        }
        ((FigureCanvas)this.graphicalViewer.getControl()).removeMouseListener((MouseListener)this);
        ((FigureCanvas)this.graphicalViewer.getControl()).removeMouseMoveListener((MouseMoveListener)this);
        this.feedbackLayer.remove((IFigure)this.figure);
        this.feedbackLayer.repaint();
        this.translate();
        this.graphicalViewer.setCursor(Cursors.ARROW);
        if (this.placed) {
            this.graphicalViewer.setProperty("disposToDisplay", null);
        } else {
            ((FigureCanvas)this.graphicalViewer.getControl()).addMouseListener((MouseListener)this);
            ((FigureCanvas)this.graphicalViewer.getControl()).addMouseMoveListener((MouseMoveListener)this);
            this.feedbackLayer.add((IFigure)this.figure);
            this.feedbackLayer.repaint();
        }
        this.graphicalViewer.getContents().refresh();
    }

    public void mouseUp(MouseEvent e) {
    }

    public void mouseMove(MouseEvent e) {
        if (e.x < 0 || e.y < 0) {
            return;
        }
        Rectangle rect = new Rectangle(this.originalBounds);
        double zoom = ((AdonisRootEditPart)this.graphicalViewer.getRootEditPart()).getZoomManager().getZoom();
        rect = rect.scale(zoom);
        int xscrolled = ((FigureCanvas)this.graphicalViewer.getControl()).getViewport().getHorizontalRangeModel().getValue();
        int yscrolled = ((FigureCanvas)this.graphicalViewer.getControl()).getViewport().getVerticalRangeModel().getValue();
        rect.x = e.x + xscrolled;
        rect.y = e.y + yscrolled;
        this.figure.setBounds(rect);
        this.figure.repaint();
        if ((e.stateMask & 0x20000) != 0) {
            this.graphicalViewer.setCursor(Cursors.SIZENS);
        } else {
            this.graphicalViewer.setCursor(Cursors.SIZEWE);
        }
    }
}

