/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.wizard.filtres;

import fr.inra.adonis.editeurgraphique.wizard.filtres.CommonFilter;
import fr.inra.adonis.editeurgraphique.wizard.filtres.CommonViewerComparator;
import fr.inra.adonis.modeleMetier.plateforme.TypeUniteParcours;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public abstract class AbstractTableViewer
extends TableViewer {
    private final CommonViewerComparator comparator;
    private final CommonFilter filter;
    protected String[] titles;
    protected Integer[] bounds;

    public AbstractTableViewer(Composite parent, int style) {
        super(parent, style);
        this.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comparator = new CommonViewerComparator();
        this.setComparator(this.comparator);
        this.filter = new CommonFilter(this);
        this.addFilter(this.filter);
    }

    protected abstract void assignColumnLabelProvider(TableViewerColumn var1, int var2);

    public abstract TypeUniteParcours getTypeUniteParcours();

    public int getColumnIndex(String colName) {
        int i = 0;
        while (i < this.titles.length) {
            if (this.titles[i].equals(colName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String[] getTitles() {
        return this.titles;
    }

    public CommonFilter getFilter() {
        return this.filter;
    }

    public Object[] getFilteredInput() {
        Object[] input = (Object[])this.getInput();
        if (input != null) {
            return this.filter(input);
        }
        return new Object[0];
    }

    protected void createColumns(Composite parent) {
        final Menu headerMenu = new Menu((Control)parent);
        int i = 0;
        while (i < this.titles.length) {
            TableViewerColumn col = this.createTableViewerColumn(this.titles[i], this.bounds[i]);
            this.assignColumnLabelProvider(col, i);
            col.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(col.getColumn(), i));
            this.createMenuItem(headerMenu, col.getColumn(), this.bounds[i]);
            ++i;
        }
        final Table table = this.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                table.setMenu(headerMenu);
            }
        });
    }

    protected TableViewerColumn createTableViewerColumn(String title, int bound) {
        TableViewerColumn viewerColumn = new TableViewerColumn((TableViewer)this, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    protected SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTableViewer.this.comparator.setColumn(index);
                int dir = AbstractTableViewer.this.getTable().getSortDirection();
                dir = AbstractTableViewer.this.getTable().getSortColumn() == column ? (dir == 128 ? 1024 : 128) : 1024;
                AbstractTableViewer.this.getTable().setSortDirection(dir);
                AbstractTableViewer.this.getTable().setSortColumn(column);
                AbstractTableViewer.this.refresh();
            }
        };
        return selectionAdapter;
    }

    protected void createMenuItem(Menu parent, final TableColumn column, final int originalBounds) {
        final MenuItem itemName = new MenuItem(parent, 32);
        itemName.setText(column.getText());
        itemName.setSelection(column.getResizable());
        itemName.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (itemName.getSelection()) {
                    column.setWidth(originalBounds);
                    column.setResizable(true);
                } else {
                    column.setWidth(0);
                    column.setResizable(false);
                }
            }
        });
    }
}

