/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.wizard.traitement;

import fr.inra.adonis.core.labelprovider.TraitementLabelProvider;
import fr.inra.adonis.modeleMetier.protocole.Traitement;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class SelectTraitementWizardPage
extends WizardPage {
    private static final String PAGE_TITLE = "S\u00e9lection d'un Traitement";
    private static final String PAGE_DESC = "Cette commande provoque la cr\u00e9ation automatique d'une Parcelle Unitaire.\nMerci de s\u00e9lectionner un traitement.";
    private static final String PAGE_ERROR_MSG = "Merci de s\u00e9lectionner un traitement";
    private Set<Traitement> traitements;
    private Traitement selectedTraitement;
    private TableViewer tableViewer;

    public SelectTraitementWizardPage(Set<Traitement> traitements) {
        super("wizardPage");
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESC);
        this.traitements = traitements;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        this.tableViewer = new TableViewer(container, 67584);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TraitementLabelProvider());
        this.tableViewer.setInput(this.traitements);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectTraitementWizardPage.this.selectedTraitement = (Traitement)((IStructuredSelection)SelectTraitementWizardPage.this.tableViewer.getSelection()).getFirstElement();
                SelectTraitementWizardPage.this.validatePage();
            }
        });
        this.setPageComplete(false);
    }

    private void validatePage() {
        if (this.tableViewer.getTable().getSelectionCount() > 0 && this.selectedTraitement != null) {
            this.setPageComplete(true);
            this.setErrorMessage(null);
        } else {
            this.setPageComplete(false);
            this.setErrorMessage(PAGE_ERROR_MSG);
        }
    }

    public Traitement getTraitement() {
        return this.selectedTraitement;
    }
}

