/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.importlistevaleur.wizard;

import fr.inra.adonis.importgenerique.importcsv.ICreationObjetImport;
import fr.inra.adonis.importgenerique.importcsv.ImportCsv;
import fr.inra.adonis.importgenerique.importcsv.SetColonnesRef;
import fr.inra.adonis.importgenerique.ui.importwizard.IValidationMappingPage;
import fr.inra.adonis.importgenerique.ui.importwizard.ImportWizard;
import fr.inra.adonis.importlistevaleur.Activator;
import fr.inra.adonis.importlistevaleur.builder.CreationListeValeurImportImpl;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ListeValeurImportWizard
extends ImportWizard {
    private static final String WINDOW_TITLE = "Import d'une liste de valeurs";
    private final CreationListeValeurImportImpl creationListeValeurImportImpl;

    public ListeValeurImportWizard(SetColonnesRef listColonneReferences, CreationListeValeurImportImpl creationObjetImport) {
        super(listColonneReferences, (ICreationObjetImport)creationObjetImport);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(WINDOW_TITLE);
        this.creationListeValeurImportImpl = creationObjetImport;
    }

    public void addPages() {
        super.addPages();
        if (this.getImportPage2() != null) {
            this.getImportPage2().setValidationMappingPage((IValidationMappingPage)this.creationListeValeurImportImpl);
        }
    }

    public boolean performFinish() {
        boolean performOk = true;
        final ImportCsv importCsv = this.getImportCsv();
        CreationListeValeurImportImpl builder = (CreationListeValeurImportImpl)importCsv.getCreationObjetImport();
        builder.setImportCsv(importCsv);
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        importCsv.parseFichier(false, monitor);
                    }
                    catch (IOException e) {
                        Activator.getLogger().logError((Throwable)e);
                        String titleErr = "Erreur lors de l'import";
                        String messageErr = "Une erreur est survenue lors du traitement du fichier";
                        MessageDialog msgDial = new MessageDialog(ListeValeurImportWizard.this.getShell(), titleErr, null, messageErr, 1, new String[]{"OK"}, 0);
                        msgDial.open();
                    }
                }
            });
        }
        catch (Exception e) {
            Activator.getLogger().logError((Throwable)e);
            performOk = false;
        }
        return performOk;
    }
}

