/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.equinox.internal.p2.ui.model.QueriedElement;
import org.eclipse.equinox.internal.p2.ui.viewers.DeferredQueryContentProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.IInputChangeListener;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.QueryableMetadataRepositoryManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class DelayedFilterCheckboxTree
extends FilteredTree {
    private static final String LOAD_JOB_NAME = ProvUIMessages.DeferredFetchFilteredTree_RetrievingList;
    private static final long FILTER_DELAY = 400L;
    ToolBar toolBar;
    Display display;
    PatternFilter patternFilter;
    DeferredQueryContentProvider contentProvider;
    String savedFilterText;
    Job loadJob;
    WorkbenchJob filterJob;
    boolean ignoreFiltering = true;
    Object viewerInput;
    ArrayList checkState = new ArrayList();
    Set expanded = new HashSet();
    ContainerCheckedTreeViewer checkboxViewer;

    public DelayedFilterCheckboxTree(Composite parent, int treeStyle, PatternFilter filter) {
        super(parent, true);
        this.display = parent.getDisplay();
        this.patternFilter = filter;
        this.init(treeStyle, filter);
    }

    protected TreeViewer doCreateTreeViewer(Composite composite, int style) {
        this.checkboxViewer = new ContainerCheckedTreeViewer(composite, style);
        this.checkboxViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (!event.getChecked() && DelayedFilterCheckboxTree.this.checkState != null) {
                    Iterator iter = DelayedFilterCheckboxTree.this.checkState.iterator();
                    ArrayList toRemove = new ArrayList(1);
                    while (iter.hasNext()) {
                        Object element = iter.next();
                        if (!DelayedFilterCheckboxTree.this.checkboxViewer.getComparer().equals(element, event.getElement())) continue;
                        toRemove.add(element);
                    }
                    DelayedFilterCheckboxTree.this.checkState.removeAll(toRemove);
                } else if (event.getChecked()) {
                    DelayedFilterCheckboxTree.this.rememberLeafCheckState();
                }
            }
        });
        return this.checkboxViewer;
    }

    protected Composite createFilterControls(Composite filterParent) {
        super.createFilterControls(filterParent);
        filterParent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DelayedFilterCheckboxTree.this.cancelLoadJob();
            }
        });
        return filterParent;
    }

    public void contentProviderSet(DeferredQueryContentProvider deferredProvider) {
        this.contentProvider = deferredProvider;
        deferredProvider.addListener(new IInputChangeListener(){

            public void inputChanged(Viewer v, Object oldInput, Object newInput) {
                if (newInput == null) {
                    return;
                }
                DelayedFilterCheckboxTree.this.viewerInput = newInput;
                DelayedFilterCheckboxTree.this.cancelLoadJob();
                DelayedFilterCheckboxTree.this.cancelAndResetFilterJob();
                DelayedFilterCheckboxTree.this.contentProvider.setSynchronous(false);
                DelayedFilterCheckboxTree.this.rememberExpansions();
                DelayedFilterCheckboxTree.this.checkboxViewer.getTree().setRedraw(false);
                DelayedFilterCheckboxTree.this.display.asyncExec(new Runnable(this){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        3.access$0(this.this$1).rememberExpansions();
                        3.access$0(this.this$1).restoreLeafCheckState();
                        3.access$0(this.this$1).rememberExpansions();
                        3.access$0(this.this$1).restoreExpansions();
                        3.access$0(this.this$1).checkboxViewer.getTree().setRedraw(true);
                    }
                });
            }

            static /* synthetic */ DelayedFilterCheckboxTree access$0(3 var0) {
                return var0.DelayedFilterCheckboxTree.this;
            }
        });
    }

    public void clearCheckStateCache() {
        this.checkState = null;
    }

    protected WorkbenchJob doCreateRefreshJob() {
        this.filterJob = super.doCreateRefreshJob();
        this.filterJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent event) {
                if (!DelayedFilterCheckboxTree.this.ignoreFiltering) {
                    return;
                }
                boolean[] shouldLoad = new boolean[]{false};
                DelayedFilterCheckboxTree.this.display.syncExec(new Runnable(this, shouldLoad){
                    final /* synthetic */ 5 this$1;
                    private final /* synthetic */ boolean[] val$shouldLoad;
                    {
                        this.this$1 = var1_1;
                        this.val$shouldLoad = blArray;
                    }

                    public void run() {
                        if (DelayedFilterCheckboxTree.access$0(5.access$0(this.this$1)) != null && !DelayedFilterCheckboxTree.access$0(5.access$0(this.this$1)).isDisposed()) {
                            String text = DelayedFilterCheckboxTree.access$1(5.access$0(this.this$1));
                            if (text == null || DelayedFilterCheckboxTree.access$2(5.access$0(this.this$1)) != null && DelayedFilterCheckboxTree.access$2(5.access$0(this.this$1)).equals(text)) {
                                return;
                            }
                            if (!5.access$0(this.this$1).contentProvider.getSynchronous() && 5.access$0(this.this$1).loadJob == null && DelayedFilterCheckboxTree.access$0(5.access$0(this.this$1)) != null && !DelayedFilterCheckboxTree.access$0(5.access$0(this.this$1)).isDisposed()) {
                                this.val$shouldLoad[0] = true;
                            }
                        }
                    }
                });
                if (shouldLoad[0]) {
                    event.getJob().sleep();
                    DelayedFilterCheckboxTree.this.scheduleLoadJob();
                } else if (DelayedFilterCheckboxTree.this.ignoreFiltering) {
                    event.getJob().sleep();
                } else {
                    DelayedFilterCheckboxTree.this.rememberLeafCheckState();
                }
            }

            public void running(IJobChangeEvent event) {
                DelayedFilterCheckboxTree.this.display.syncExec(new Runnable(this){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        5.access$0(this.this$1).rememberLeafCheckState();
                    }
                });
            }

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    DelayedFilterCheckboxTree.this.display.asyncExec(new Runnable(this){
                        final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            5.access$0(this.this$1).checkboxViewer.getTree().setRedraw(false);
                            5.access$0(this.this$1).rememberExpansions();
                            5.access$0(this.this$1).restoreLeafCheckState();
                            5.access$0(this.this$1).restoreExpansions();
                            5.access$0(this.this$1).checkboxViewer.getTree().setRedraw(true);
                        }
                    });
                }
            }

            static /* synthetic */ DelayedFilterCheckboxTree access$0(5 var0) {
                return var0.DelayedFilterCheckboxTree.this;
            }
        });
        return this.filterJob;
    }

    void scheduleLoadJob() {
        if (this.loadJob != null) {
            return;
        }
        this.loadJob = new Job(LOAD_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                QueryableMetadataRepositoryManager q = null;
                if (DelayedFilterCheckboxTree.this.viewerInput instanceof QueryableMetadataRepositoryManager) {
                    q = (QueryableMetadataRepositoryManager)DelayedFilterCheckboxTree.this.viewerInput;
                } else if (DelayedFilterCheckboxTree.this.viewerInput instanceof QueriedElement && ((QueriedElement)DelayedFilterCheckboxTree.this.viewerInput).getQueryable() instanceof QueryableMetadataRepositoryManager) {
                    q = (QueryableMetadataRepositoryManager)((QueriedElement)DelayedFilterCheckboxTree.this.viewerInput).getQueryable();
                }
                if (q != null) {
                    q.loadAll(monitor);
                    q.reportAccumulatedStatus();
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        this.loadJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    DelayedFilterCheckboxTree.this.contentProvider.setSynchronous(true);
                    DelayedFilterCheckboxTree.this.ignoreFiltering = false;
                    if (DelayedFilterCheckboxTree.this.filterJob != null) {
                        DelayedFilterCheckboxTree.this.filterJob.wakeUp();
                    }
                }
                DelayedFilterCheckboxTree.this.loadJob = null;
            }
        });
        this.loadJob.setSystem(true);
        this.loadJob.setUser(false);
        ProvisioningOperationRunner.manageJob(this.loadJob);
        this.loadJob.schedule();
    }

    void cancelLoadJob() {
        if (this.loadJob != null) {
            this.loadJob.cancel();
            this.loadJob = null;
        }
    }

    void cancelAndResetFilterJob() {
        if (this.filterJob != null) {
            this.filterJob.cancel();
        }
        this.ignoreFiltering = true;
    }

    void rememberLeafCheckState() {
        ContainerCheckedTreeViewer v = (ContainerCheckedTreeViewer)this.getViewer();
        Object[] checked = v.getCheckedElements();
        if (this.checkState == null) {
            this.checkState = new ArrayList(checked.length);
        }
        int i = 0;
        while (i < checked.length) {
            if (!v.getGrayed(checked[i]) && this.contentProvider.getChildren(checked[i]).length == 0 && !this.checkState.contains(checked[i])) {
                this.checkState.add(checked[i]);
            }
            ++i;
        }
    }

    void restoreLeafCheckState() {
        if (this.checkboxViewer == null || this.checkboxViewer.getTree().isDisposed()) {
            return;
        }
        if (this.checkState == null) {
            return;
        }
        this.checkboxViewer.setCheckedElements(new Object[0]);
        this.checkboxViewer.setGrayedElements(new Object[0]);
        Iterator iter = this.checkState.iterator();
        Object element = null;
        if (iter.hasNext()) {
            this.checkboxViewer.expandAll();
        }
        while (iter.hasNext()) {
            element = iter.next();
            this.checkboxViewer.setChecked(element, true);
        }
        if (element != null) {
            this.checkboxViewer.fireCheckStateChanged(element, true);
        }
    }

    void rememberExpansions() {
        this.expanded.addAll(Arrays.asList(this.getViewer().getExpandedElements()));
    }

    void restoreExpansions() {
        this.getViewer().setExpandedElements(this.expanded.toArray());
    }

    public ContainerCheckedTreeViewer getCheckboxTreeViewer() {
        return this.checkboxViewer;
    }

    protected long getRefreshJobDelay() {
        return 400L;
    }

    static /* synthetic */ Text access$0(DelayedFilterCheckboxTree delayedFilterCheckboxTree) {
        return delayedFilterCheckboxTree.filterText;
    }

    static /* synthetic */ String access$1(DelayedFilterCheckboxTree delayedFilterCheckboxTree) {
        return delayedFilterCheckboxTree.getFilterString();
    }

    static /* synthetic */ String access$2(DelayedFilterCheckboxTree delayedFilterCheckboxTree) {
        return delayedFilterCheckboxTree.initialText;
    }
}

