/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique;

import fr.inra.adonis.core.parcours.ParcoursUtil;
import fr.inra.adonis.core.rcp.AdonisLabelProvider;
import fr.inra.adonis.core.rcp.AdonisPropertySheetPage;
import fr.inra.adonis.editeurgraphique.AbstractGraphicalEditor;
import fr.inra.adonis.editeurgraphique.AdonisContextMenuProvider;
import fr.inra.adonis.editeurgraphique.EditionGraphiqueCommand;
import fr.inra.adonis.editeurgraphique.EditorModeEnum;
import fr.inra.adonis.editeurgraphique.GraphicalConfigurator;
import fr.inra.adonis.editeurgraphique.OutlinePage;
import fr.inra.adonis.editeurgraphique.VisualisationGraphiqueVariable;
import fr.inra.adonis.editeurgraphique.actions.ArrierePlanAction;
import fr.inra.adonis.editeurgraphique.actions.CopyAction;
import fr.inra.adonis.editeurgraphique.actions.CouleurAction;
import fr.inra.adonis.editeurgraphique.actions.ExportImageAction;
import fr.inra.adonis.editeurgraphique.actions.FlecheNordAction;
import fr.inra.adonis.editeurgraphique.actions.IndMortAction;
import fr.inra.adonis.editeurgraphique.actions.IndReplanterAction;
import fr.inra.adonis.editeurgraphique.actions.NiveauVisualisationAction;
import fr.inra.adonis.editeurgraphique.actions.PasteAction;
import fr.inra.adonis.editeurgraphique.actions.SupprimerAction;
import fr.inra.adonis.editeurgraphique.actions.TextureAction;
import fr.inra.adonis.editeurgraphique.actions.ZdtEditAction;
import fr.inra.adonis.editeurgraphique.actions.ZoomInFontAction;
import fr.inra.adonis.editeurgraphique.actions.ZoomOutFontAction;
import fr.inra.adonis.editeurgraphique.model.AdonisCreationFactory;
import fr.inra.adonis.editeurgraphique.part.AdonisRootEditPart;
import fr.inra.adonis.editeurgraphique.rulers.custom.AdonisRulerComposite;
import fr.inra.adonis.editeurgraphique.tools.Synchronizer;
import fr.inra.adonis.editeurgraphique.tools.ViewUtil;
import fr.inra.adonis.editeurgraphique.tools.ZoomUtil;
import fr.inra.adonis.editeurgraphique.tools.palette.AdonisPaletteSelectionTool;
import fr.inra.adonis.editeurgraphique.tools.palette.AdonisSelectionToolEntry;
import fr.inra.adonis.editeurgraphique.tools.palette.AdonisToolEntry;
import fr.inra.adonis.editeurgraphique.tools.palette.AdvancedFilterToolEntry;
import fr.inra.adonis.editeurgraphique.tools.palette.AdvancedSelectionToolEntry;
import fr.inra.adonis.editeurgraphique.tools.palette.SwitchTraitementsToolEntry;
import fr.inra.adonis.icons.IconsRegistry;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.graphique.ZoneDeTexte;
import fr.inra.adonis.modeleMetier.plateforme.Bloc;
import fr.inra.adonis.modeleMetier.plateforme.Individu;
import fr.inra.adonis.modeleMetier.plateforme.NatureZhe;
import fr.inra.adonis.modeleMetier.plateforme.ParcelleUnitaire;
import fr.inra.adonis.modeleMetier.plateforme.Plateforme;
import fr.inra.adonis.modeleMetier.plateforme.SousBloc;
import fr.inra.adonis.modeleMetier.plateforme.UniteDeParcours;
import fr.inra.adonis.modeleMetier.plateforme.ZheAvecEpaisseur;
import fr.inra.adonis.persistance.AbstractDAOFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.Tool;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.gef.ui.actions.ToggleGridAction;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class AdonisGraphicalEditor
extends AbstractGraphicalEditor {
    public static final String ID = "fr.inra.adonis.editeurgraphique.graphicaleditor";
    private ObjetMetier rootObjetMetier;
    private AdonisPropertySheetPage propertySheetPage;
    private AdonisRulerComposite rulerComp;
    private PaletteRoot paletteRoot;
    private final Map<Class<?>, Tool> creationTools = new HashMap();
    private Synchronizer synchronizer;
    private CommonNavigator explorateur;

    public AdonisRulerComposite getRulerComp() {
        return this.rulerComp;
    }

    public Synchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public AdonisGraphicalEditor() {
        DefaultEditDomain editDomain = new DefaultEditDomain((IEditorPart)this){

            public void keyDown(KeyEvent keyEvent, EditPartViewer viewer) {
                AdonisGraphicalEditor.this.handleKeyDown(keyEvent);
                super.keyDown(keyEvent, viewer);
            }

            public void keyUp(KeyEvent keyEvent, EditPartViewer viewer) {
                AdonisGraphicalEditor.this.handleKeyUp(keyEvent);
                super.keyUp(keyEvent, viewer);
            }
        };
        this.setEditDomain(editDomain);
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    @Override
    public void dispose() {
        EditorModeEnum mode = (EditorModeEnum)((Object)this.getEditorInput().getAdapter(EditorModeEnum.class));
        if (mode != EditorModeEnum.VISUALISATION_VARIABLE) {
            this.explorateur.removePropertyListener((IPropertyListener)this.synchronizer);
            this.getGraphicalViewer().removeSelectionChangedListener((ISelectionChangedListener)this.synchronizer);
        }
        super.dispose();
        EditionGraphiqueCommand.editorOpened.remove(this.rootObjetMetier);
        if (EditionGraphiqueCommand.editorOpened.size() == 0) {
            ViewUtil.closeView("org.eclipse.ui.views.ContentOutline");
        }
    }

    @Override
    protected void createGraphicalViewer(Composite parent) {
        this.rulerComp = new AdonisRulerComposite(parent, 0);
        super.createGraphicalViewer(this.rulerComp);
        this.rulerComp.setGraphicalViewer((ScrollingGraphicalViewer)this.getGraphicalViewer());
    }

    @Override
    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        final GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setProperty("graphicalEditor", (Object)this);
        EditorModeEnum mode = (EditorModeEnum)((Object)this.getEditorInput().getAdapter(EditorModeEnum.class));
        this.rootObjetMetier = (ObjetMetier)this.getEditorInput().getAdapter(ObjetMetier.class);
        GraphicalConfigurator.configureGraphicalViewer(viewer, mode, this.rootObjetMetier);
        if (mode == EditorModeEnum.EDITION_PLATEFORME) {
            PaletteGroup traitementsGroup = new PaletteGroup("Traitements");
            this.paletteRoot.add((PaletteEntry)traitementsGroup);
            traitementsGroup.add((PaletteEntry)new SwitchTraitementsToolEntry());
            this.createPaletteActions();
        }
        switch (mode) {
            case CREATION_CHEMINEMENT: {
                this.setPartName("Cheminements");
                break;
            }
            case EDITION_PLATEFORME: {
                this.setPartName("Edition Graphique");
                break;
            }
            case VISUALISATION: {
                this.setPartName("Visualisation Graphique");
                break;
            }
            case VISUALISATION_VARIABLE: {
                this.setPartName("Visualisation Graphique Variable " + VisualisationGraphiqueVariable.getVariable().getNom());
                break;
            }
            case VISUALISATION_CONTROLE: {
                this.setPartName("Visualisation Graphique retour de contr\u00f4le");
                break;
            }
            default: {
                this.setPartName("Editeur Graphique");
            }
        }
        this.getGraphicalViewer().setProperty("shiftPressed", (Object)false);
        AdonisContextMenuProvider contextMenu = new AdonisContextMenuProvider((EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)contextMenu);
        this.getActionRegistry().registerAction((IAction)new ToggleGridAction(viewer));
        ZoomUtil.configureZoom(this.getActionRegistry(), this.getGraphicalViewer());
        viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)0), (Object)MouseWheelZoomHandler.SINGLETON);
        this.createKeyHandler();
        this.getPaletteViewer().getEditDomain().setDefaultTool((Tool)new AdonisPaletteSelectionTool());
        this.getPaletteViewer().getEditDomain().loadDefaultTool();
        final AdonisGraphicalEditor editor = this;
        this.getEditDomain().getPaletteViewer().addPaletteListener(new PaletteListener(){

            public void activeToolChanged(PaletteViewer palette, ToolEntry tool) {
                if (tool instanceof AdonisToolEntry) {
                    ((AdonisToolEntry)tool).execute(editor);
                    palette.setActiveTool((ToolEntry)AdonisSelectionToolEntry.DEFAULT_TOOL_ENTRY);
                    return;
                }
                Object factory = tool.getToolProperty(CreationTool.PROPERTY_CREATION_FACTORY);
                if (factory != null && factory instanceof AdonisCreationFactory) {
                    Class classObjectToCreate = (Class)((AdonisCreationFactory)factory).getObjectType();
                    viewer.setProperty("typeObjetToCreate", (Object)classObjectToCreate);
                    if (classObjectToCreate == ZheAvecEpaisseur.class) {
                        AdonisGraphicalEditor.this.getGraphicalViewer().setProperty("natureZhe", tool.getToolProperty((Object)"nature"));
                        AdonisGraphicalEditor.this.paletteRoot.setDefaultEntry(tool);
                    } else {
                        AdonisGraphicalEditor.this.paletteRoot.setDefaultEntry(tool);
                    }
                }
            }
        });
        if (mode != EditorModeEnum.VISUALISATION_VARIABLE) {
            String idCNF = "fr.inra.adonis.vues.explorateur.vuePlateforme";
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage activePage = workbenchWindow.getActivePage();
            IViewReference findView = activePage.findViewReference(idCNF);
            this.explorateur = (CommonNavigator)findView.getPart(false);
            this.synchronizer = new Synchronizer(this.getGraphicalViewer(), this.explorateur);
            this.explorateur.addPropertyListener((IPropertyListener)this.synchronizer);
            this.getGraphicalViewer().addSelectionChangedListener((ISelectionChangedListener)this.synchronizer);
        }
    }

    @Override
    protected void initializeGraphicalViewer() {
        if (this.rootObjetMetier instanceof UniteDeParcours) {
            UniteDeParcours unite = (UniteDeParcours)this.rootObjetMetier;
            this.setEditorDescription(unite);
            EditionGraphiqueCommand.editorOpened.add(unite);
            this.getGraphicalViewer().setContents((Object)unite);
            Rectangle contentsBounds = ((GraphicalEditPart)this.getGraphicalViewer().getContents()).getFigure().getBounds();
            int x = contentsBounds.x;
            int y = contentsBounds.y;
            FigureCanvas canvas = (FigureCanvas)this.getGraphicalViewer().getControl();
            FreeformViewport viewport = (FreeformViewport)canvas.getViewport();
            viewport.getHorizontalRangeModel().setMinimum(Math.min(x, viewport.getHorizontalRangeModel().getMinimum()));
            viewport.getVerticalRangeModel().setMinimum(Math.min(y, viewport.getVerticalRangeModel().getMinimum()));
            viewport.setViewLocation(x, y);
        }
    }

    @Override
    public Object getAdapter(Class type) {
        if (IPropertySheetPage.class == type) {
            return this.getPropertySheetPage();
        }
        if (type == ZoomManager.class) {
            return ((AdonisRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        if (type == IContentOutlinePage.class) {
            return new OutlinePage(this.getGraphicalViewer());
        }
        if (type == SnapToGrid.class) {
            return null;
        }
        return super.getAdapter(type);
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new AdonisPropertySheetPage();
        }
        return this.propertySheetPage;
    }

    protected boolean handleKeyUp(KeyEvent keyEvent) {
        if (keyEvent.keyCode == 131072) {
            this.getGraphicalViewer().setProperty("shiftPressed", (Object)false);
            return true;
        }
        return false;
    }

    protected boolean handleKeyDown(KeyEvent keyEvent) {
        if (keyEvent.keyCode == 27) {
            this.paletteRoot.setDefaultEntry((ToolEntry)AdonisSelectionToolEntry.DEFAULT_TOOL_ENTRY);
            this.getEditDomain().getPaletteViewer().setActiveTool((ToolEntry)AdonisSelectionToolEntry.DEFAULT_TOOL_ENTRY);
            return true;
        }
        if (keyEvent.keyCode == 131072) {
            this.getGraphicalViewer().setProperty("shiftPressed", (Object)true);
            return true;
        }
        IAction action = null;
        if (keyEvent.keyCode == 127) {
            action = this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId());
        } else if (keyEvent.character == '+' || keyEvent.keyCode == 16777259) {
            action = this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in");
        } else if (keyEvent.character == '-' || keyEvent.keyCode == 16777261) {
            action = this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_out");
        } else if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 99) {
            action = this.getActionRegistry().getAction((Object)ActionFactory.COPY.getId());
        } else if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 118) {
            action = this.getActionRegistry().getAction((Object)ActionFactory.PASTE.getId());
        }
        if (action != null && action.isEnabled()) {
            action.run();
            return true;
        }
        return false;
    }

    private void createKeyHandler() {
        KeyHandler keyHandler = new KeyHandler(){};
        this.getGraphicalViewer().setKeyHandler(keyHandler);
        this.getEditDomain().getPaletteViewer().setKeyHandler(keyHandler);
    }

    private void setEditorDescription(UniteDeParcours unite) {
        String navigation = "";
        ObjetMetier parent = ParcoursUtil.getParent((ObjetMetier)unite);
        AdonisLabelProvider e = AdonisLabelProvider.getInstance();
        ArrayList<String> orderNavigation = new ArrayList<String>();
        while (parent != null) {
            orderNavigation.add(" > " + parent.getClass().getSimpleName() + " " + e.getText((Object)parent));
            parent = ParcoursUtil.getParent((ObjetMetier)parent);
        }
        int ind = orderNavigation.size();
        while (ind > 0) {
            navigation = String.valueOf(navigation) + (String)orderNavigation.get(ind - 1);
            --ind;
        }
        navigation = String.valueOf(navigation) + " > " + unite.getClass().getSimpleName() + " " + e.getText((Object)unite);
        this.setContentDescription(navigation);
    }

    @Override
    protected void createActions() {
        super.createActions();
        EditorModeEnum mode = (EditorModeEnum)((Object)this.getEditorInput().getAdapter(EditorModeEnum.class));
        if (mode == EditorModeEnum.EDITION_PLATEFORME || mode == EditorModeEnum.CREATION_CHEMINEMENT) {
            Object action = new SupprimerAction(this, this.rootObjetMetier);
            this.getActionRegistry().registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
            action = new IndMortAction((IWorkbenchPart)this, this.rootObjetMetier);
            this.getActionRegistry().registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
            action = new IndReplanterAction((IWorkbenchPart)this, this.rootObjetMetier);
            this.getActionRegistry().registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
            action = new CopyAction(this);
            this.getActionRegistry().registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
            action = new PasteAction((IWorkbenchPart)this, this.rootObjetMetier);
            this.getActionRegistry().registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
            action = new ZdtEditAction((IEditorPart)this, this.rootObjetMetier);
            this.getActionRegistry().registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
            action = new CouleurAction((IWorkbenchPart)this, this.rootObjetMetier);
            this.getActionRegistry().registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
            action = new TextureAction((IWorkbenchPart)this, this.rootObjetMetier);
            this.getActionRegistry().registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
            action = new ArrierePlanAction((IWorkbenchPart)this, this.rootObjetMetier);
            this.getActionRegistry().registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
        }
        this.getActionRegistry().registerAction((IAction)new ZoomOutFontAction(this.getGraphicalViewer(), this.getRulerComp()));
        this.getActionRegistry().registerAction((IAction)new ZoomInFontAction(this.getGraphicalViewer(), this.getRulerComp()));
        this.getActionRegistry().registerAction((IAction)new ExportImageAction(this.getGraphicalViewer(), this.getRulerComp()));
        this.getActionRegistry().registerAction((IAction)new FlecheNordAction(this));
        this.getActionRegistry().registerAction((IAction)new NiveauVisualisationAction(this));
    }

    public void createPaletteActions() {
        CreationToolEntry tool;
        this.paletteRoot.add((PaletteEntry)new PaletteSeparator());
        PaletteGroup creationGroup = new PaletteGroup("Creation");
        this.paletteRoot.add((PaletteEntry)creationGroup);
        if (this.rootObjetMetier instanceof Plateforme) {
            tool = new CreationToolEntry("Zone de texte", "Creation d'une zone de texte libre", (CreationFactory)new AdonisCreationFactory(ZoneDeTexte.class), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
            tool.setToolClass(CreationTool.class);
            this.creationTools.put(ZoneDeTexte.class, tool.createTool());
            creationGroup.add((PaletteEntry)tool);
            creationGroup.add((PaletteEntry)new PaletteSeparator());
        }
        EList zheList = AbstractDAOFactory.getInstance().getSiteDAO().getBibliotheque().getNatureZhe();
        for (NatureZhe nzhe : zheList) {
            tool = new CreationToolEntry("Zhe " + nzhe.getNom(), "Placer des Zones hors exp\u00e9rimentations", (CreationFactory)new AdonisCreationFactory(ZheAvecEpaisseur.class), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
            tool.setToolClass(CreationTool.class);
            tool.setToolProperty((Object)"nature", (Object)nzhe);
            this.creationTools.put(ZheAvecEpaisseur.class, tool.createTool());
            creationGroup.add((PaletteEntry)tool);
        }
        if (!zheList.isEmpty()) {
            creationGroup.add((PaletteEntry)new PaletteSeparator());
        }
        tool = new CreationToolEntry("Placer Individu", "Placer des Individus", (CreationFactory)new AdonisCreationFactory(Individu.class), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        tool.setToolClass(CreationTool.class);
        this.creationTools.put(Individu.class, tool.createTool());
        creationGroup.add((PaletteEntry)tool);
        tool = new CreationToolEntry("PU Suppl\u00e9mentaire", "Creation d'une PU contenant un individu", (CreationFactory)new AdonisCreationFactory(ParcelleUnitaire.class), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        tool.setToolClass(CreationTool.class);
        this.creationTools.put(ParcelleUnitaire.class, tool.createTool());
        creationGroup.add((PaletteEntry)tool);
        tool = new CreationToolEntry("Sous Bloc Suppl\u00e9mentaire", "Creation d'un sous bloc contenant une PU et un individu", (CreationFactory)new AdonisCreationFactory(SousBloc.class), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        tool.setToolClass(CreationTool.class);
        this.creationTools.put(SousBloc.class, tool.createTool());
        creationGroup.add((PaletteEntry)tool);
        tool = new CreationToolEntry("Bloc Suppl\u00e9mentaire", "Creation d'un bloc contenant un sous bloc optionnel, une PU et un individu", (CreationFactory)new AdonisCreationFactory(Bloc.class), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        tool.setToolClass(CreationTool.class);
        this.creationTools.put(Bloc.class, tool.createTool());
        creationGroup.add((PaletteEntry)tool);
    }

    @Override
    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot != null) {
            return this.paletteRoot;
        }
        this.paletteRoot = new PaletteRoot();
        PaletteGroup manipGroup = new PaletteGroup("Manipulation");
        this.paletteRoot.add((PaletteEntry)manipGroup);
        manipGroup.add((PaletteEntry)AdonisSelectionToolEntry.DEFAULT_TOOL_ENTRY);
        this.paletteRoot.setDefaultEntry((ToolEntry)AdonisSelectionToolEntry.DEFAULT_TOOL_ENTRY);
        manipGroup.add((PaletteEntry)new AdvancedSelectionToolEntry());
        this.paletteRoot.add((PaletteEntry)new PaletteSeparator());
        PaletteGroup filtreGroup = new PaletteGroup("Filtres");
        this.paletteRoot.add((PaletteEntry)filtreGroup);
        filtreGroup.add((PaletteEntry)new AdvancedFilterToolEntry());
        filtreGroup.add((PaletteEntry)new AdonisToolEntry("Annuler filtres", "Retire les filtres graphiques", ImageDescriptor.createFromImage((Image)IconsRegistry.IMG_FILTER_16), ImageDescriptor.createFromImage((Image)IconsRegistry.IMG_FILTER_16)){

            @Override
            public void execute(AdonisGraphicalEditor editor) {
                AdonisGraphicalEditor.this.getGraphicalViewer().setProperty("indsToDisplay", null);
                AdonisGraphicalEditor.this.getGraphicalViewer().setProperty("pusToDisplay", null);
                AdonisGraphicalEditor.this.getGraphicalViewer().setProperty("ssblocsToDisplay", null);
                AdonisGraphicalEditor.this.getGraphicalViewer().setProperty("blocsToDisplay", null);
                AdonisGraphicalEditor.this.getGraphicalViewer().setProperty("disposToDisplay", null);
                AdonisGraphicalEditor.this.getGraphicalViewer().getContents().refresh();
            }
        });
        this.paletteRoot.add((PaletteEntry)new PaletteSeparator());
        return this.paletteRoot;
    }

    public Map<Class<?>, Tool> getCreationTools() {
        return this.creationTools;
    }

    public ObjetMetier getRootObjetMetier() {
        return this.rootObjetMetier;
    }

    public static void refreshAllEditors() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        int i = 0;
        while (i < page.getEditorReferences().length) {
            IEditorReference edRef = page.getEditorReferences()[i];
            if (ID.equals(edRef.getId())) {
                AdonisGraphicalEditor editor = (AdonisGraphicalEditor)edRef.getEditor(true);
                editor.getGraphicalViewer().getContents().refresh();
            }
            ++i;
        }
    }
}

