/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique;

import fr.inra.adonis.editeurgraphique.AdonisEditorInput;
import fr.inra.adonis.editeurgraphique.AdonisGraphicalEditor;
import fr.inra.adonis.editeurgraphique.EditeurGraphiqueActivator;
import fr.inra.adonis.editeurgraphique.EditorModeEnum;
import fr.inra.adonis.editeurgraphique.tools.palette.LayerFilterToolEntry;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.Plateforme;
import fr.inra.adonis.modeleMetier.projetDeSaisie.variables.Variable;
import fr.inra.adonis.modeleMetier.saisieTerrain.MesureVariable;
import java.util.HashMap;
import java.util.List;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public final class VisualisationGraphiqueVariable {
    private static Plateforme plateformeToDisplay;
    private static Variable variable;
    private static HashMap<ObjetMetier, HashMap<Variable, List<MesureVariable>>> tableVariablesMesures;

    public static void initialize(Plateforme plateforme, Variable obj, HashMap<ObjetMetier, HashMap<Variable, List<MesureVariable>>> mapObjetMetierVarMesurVar) {
        plateformeToDisplay = plateforme;
        variable = obj;
        tableVariablesMesures = mapObjetMetierVarMesurVar;
    }

    public static void showEditor() {
        AdonisEditorInput editorInput = new AdonisEditorInput();
        editorInput.setRootObjetMetier((ObjetMetier)plateformeToDisplay);
        editorInput.setEditorMode(EditorModeEnum.VISUALISATION_VARIABLE);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editorPart = page.findEditor((IEditorInput)editorInput);
        if (editorPart != null) {
            page.closeEditor(editorPart, true);
        }
        try {
            IEditorPart editor = page.openEditor((IEditorInput)editorInput, "fr.inra.adonis.editeurgraphique.graphicaleditor", false);
            LayerFilterToolEntry layer = new LayerFilterToolEntry(variable.getUniteParcoursType());
            layer.execute((AdonisGraphicalEditor)editor);
            page.showView("org.eclipse.ui.views.ContentOutline");
        }
        catch (PartInitException e) {
            EditeurGraphiqueActivator.getLogger().logError((Throwable)e);
        }
    }

    public static Variable getVariable() {
        return variable;
    }

    public static List<MesureVariable> getMesuresForObject(ObjetMetier obj) {
        HashMap<Variable, List<MesureVariable>> mapMesures = tableVariablesMesures.get(obj);
        if (mapMesures == null) {
            return null;
        }
        return mapMesures.get(variable);
    }

    private VisualisationGraphiqueVariable() {
    }
}

