/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.cheminement.editpolicy.commands;

import fr.inra.adonis.editeurgraphique.cheminement.factory.CheminementGraphFactory;
import fr.inra.adonis.editeurgraphique.model.Connection;
import fr.inra.adonis.editeurgraphique.part.ObjetMetierPart;
import org.eclipse.gef.commands.Command;

public class ConnectionCreateCommand
extends Command {
    private ObjetMetierPart sourceObjGraphique;
    private ObjetMetierPart targetObjGraphique;
    private Connection conn;
    private int connectionType;

    public boolean canExecute() {
        if (this.sourceObjGraphique == null || this.targetObjGraphique == null) {
            return false;
        }
        return !((Object)((Object)this.sourceObjGraphique)).equals((Object)this.targetObjGraphique);
    }

    public void execute() {
        this.conn = new Connection(this.sourceObjGraphique, this.targetObjGraphique, this.connectionType);
        this.conn.connect();
        CheminementGraphFactory.getInstance().addConnection(this.conn);
    }

    public boolean canUndo() {
        return this.sourceObjGraphique != null && this.targetObjGraphique != null && this.conn != null;
    }

    public void undo() {
        this.conn.disconnect();
        CheminementGraphFactory.getInstance().deleteConnection(this.conn);
    }

    public void redo() {
        this.conn.connect();
        CheminementGraphFactory.getInstance().addConnection(this.conn);
    }

    public void setSource(ObjetMetierPart aSourceObjGraphique) {
        this.sourceObjGraphique = aSourceObjGraphique;
    }

    public void setTarget(ObjetMetierPart targetObjetGraphique) {
        this.targetObjGraphique = targetObjetGraphique;
    }

    public void setConnectionType(int connectionType) {
        this.connectionType = connectionType;
    }

    public int getConnectionType() {
        return this.connectionType;
    }
}

