/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.commands;

import fr.inra.adonis.core.controle.Coordonnees;
import fr.inra.adonis.core.parcours.Parcours;
import fr.inra.adonis.editeurgraphique.commands.AbstractCreateCommand;
import fr.inra.adonis.editeurgraphique.tools.ObjectSelectionUtil;
import fr.inra.adonis.editeurgraphique.wizard.WantSousBlocDialog;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.Bloc;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.Individu;
import fr.inra.adonis.modeleMetier.plateforme.ZheAvecEpaisseur;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.swt.widgets.Display;

public class BlocCreateCommand
extends AbstractCreateCommand {
    public BlocCreateCommand(GraphicalViewer gv, List<Point> pointsToAdd, EditPart part) {
        super(gv, pointsToAdd, part);
        this.setParent(ObjectSelectionUtil.selectParent(gv, Bloc.class));
    }

    @Override
    public boolean canExecute() {
        if (!super.canExecute()) {
            return false;
        }
        if (!(this.getParent() instanceof Dispositif)) {
            return false;
        }
        Dispositif metier = (Dispositif)this.getParent();
        Set<Coordonnees> coords = BlocCreateCommand.getListCoordVoisins((ObjetMetier)metier);
        for (Coordonnees coord : coords) {
            for (Point p : this.getListPointToAdd()) {
                if (coord.getX() != p.x || coord.getY() != p.y) continue;
                return true;
            }
        }
        final ArrayList contenu = new ArrayList();
        Parcours parcours = new Parcours(){

            public void parcoursIndividu(Individu ind) {
                contenu.add(ind);
            }

            public void parcoursZhe(ZheAvecEpaisseur zhe) {
                contenu.add(zhe);
            }
        };
        parcours.setAscendant(false);
        parcours.parcours(this.getParent());
        return contenu.isEmpty();
    }

    @Override
    public void executeCommand() {
        Boolean wantSousBloc = false;
        Object want = this.getGraphicalViewer().getProperty("wantToCreateSousBloc");
        if (want == null) {
            WantSousBlocDialog dialog = new WantSousBlocDialog(Display.getCurrent().getActiveShell());
            int result = dialog.open();
            if (result == 0) {
                wantSousBloc = true;
                if (dialog.isIgnore()) {
                    this.getGraphicalViewer().setProperty("wantToCreateSousBloc", (Object)new Boolean(true));
                }
            } else {
                wantSousBloc = false;
                if (dialog.isIgnore()) {
                    this.getGraphicalViewer().setProperty("wantToCreateSousBloc", (Object)new Boolean(false));
                }
            }
        } else if (want instanceof Boolean) {
            wantSousBloc = (Boolean)want;
        }
        BlocCreateCommand.createBloc(this.getListPointToAdd(), (Dispositif)this.getParent(), wantSousBloc);
        this.refreshPropertyTester();
    }
}

