/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.commands;

import fr.inra.adonis.core.idgenerator.IdGeneratorService;
import fr.inra.adonis.core.util.DispositifUtil;
import fr.inra.adonis.core.util.UtilisateurCourant;
import fr.inra.adonis.droitsacces.propertytester.SuppressionTester;
import fr.inra.adonis.droitsacces.util.DroitsAccesUtil;
import fr.inra.adonis.editeurgraphique.commands.AbstractCommand;
import fr.inra.adonis.editeurgraphique.part.ObjetMetierPart;
import fr.inra.adonis.editeurgraphique.part.ZoneDeTextePart;
import fr.inra.adonis.editeurgraphique.tools.Synchronizer;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.graphique.ZoneDeTexte;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.EtatDispositif;
import fr.inra.adonis.modeleMetier.plateforme.Plateforme;
import fr.inra.adonis.modeleMetier.utilisateur.TypeAction;
import fr.inra.adonis.modeleMetier.utilisateur.Utilisateur;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.swt.widgets.Shell;

public class DeleteCommand
extends AbstractCommand {
    private final GraphicalViewer graphicalViewer;
    private final List<ObjetMetier> listObjetMetierToDelete;
    private final List<ZoneDeTexte> listZoneDeTexteToDelete;
    private final Synchronizer synchroniseur;

    public DeleteCommand(GraphicalViewer gv, List<EditPart> objsPartToDelete, Object rootObject, Shell shell, Synchronizer synchroniseur) {
        super(rootObject, shell);
        this.graphicalViewer = gv;
        this.synchroniseur = synchroniseur;
        this.listObjetMetierToDelete = new ArrayList<ObjetMetier>();
        this.listZoneDeTexteToDelete = new ArrayList<ZoneDeTexte>();
        for (EditPart obj : objsPartToDelete) {
            if (obj instanceof ObjetMetierPart) {
                this.listObjetMetierToDelete.add((ObjetMetier)obj.getModel());
                continue;
            }
            if (!(obj instanceof ZoneDeTextePart)) continue;
            this.listZoneDeTexteToDelete.add((ZoneDeTexte)obj.getModel());
        }
    }

    @Override
    public void executeCommand() {
        if (this.listObjetMetierToDelete.size() > 1) {
            ObjetMetierPart.setWaitForRefresh(true);
            if (this.synchroniseur != null) {
                this.synchroniseur.setWaitForRefresh(true);
            }
        }
        try {
            HashSet<Dispositif> dispsImpactes = new HashSet<Dispositif>();
            for (ObjetMetier obj : this.listObjetMetierToDelete) {
                Dispositif parent = (Dispositif)DispositifUtil.getParent((ObjetMetier)obj, Dispositif.class);
                if (parent != null) {
                    dispsImpactes.add(parent);
                }
                if (!(obj instanceof ObjetMetier)) continue;
                DispositifUtil.deleteObjectAndDependencies((ObjetMetier)obj);
            }
            ObjetMetier root = (ObjetMetier)this.graphicalViewer.getContents().getModel();
            Plateforme pf = (Plateforme)DispositifUtil.getParent((ObjetMetier)root, Plateforme.class);
            if (pf != null) {
                for (ZoneDeTexte zdt : this.listZoneDeTexteToDelete) {
                    if (!pf.getZonesDeTexte().contains((Object)zdt)) continue;
                    pf.getZonesDeTexte().remove((Object)zdt);
                }
            }
            for (Dispositif disp : dispsImpactes) {
                IdGeneratorService.recalculeNumeros((Dispositif)disp);
            }
        }
        finally {
            if (this.listObjetMetierToDelete.size() > 1) {
                ObjetMetierPart.setWaitForRefresh(false);
                this.graphicalViewer.getRootEditPart().getContents().refresh();
                if (this.synchroniseur != null) {
                    this.synchroniseur.setWaitForRefresh(false);
                }
            }
        }
    }

    public boolean canExecute() {
        if (this.listObjetMetierToDelete.size() + this.listZoneDeTexteToDelete.size() == 0) {
            return false;
        }
        for (ObjetMetier obj : this.listObjetMetierToDelete) {
            Dispositif disp = DispositifUtil.getDispositifFrom((EObject)obj);
            if (disp != null && disp.getEtat() == EtatDispositif.CREE && SuppressionTester.isRemovable((Object)obj) && DroitsAccesUtil.isDroitsAccesDispositif((Utilisateur)UtilisateurCourant.getInstance(), (Dispositif)disp, (TypeAction)TypeAction.EDITER)) continue;
            return false;
        }
        return true;
    }
}

