/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.part;

import fr.inra.adonis.editeurgraphique.editpolicies.TranslateCommand;
import java.util.ArrayList;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.swt.events.MouseEvent;

public class ObjetMetierDragTracker
extends DragEditPartsTracker {
    private final EditPartViewer editPartViewer;

    public ObjetMetierDragTracker(EditPart sourceEditPart) {
        super(sourceEditPart);
        this.editPartViewer = sourceEditPart.getViewer();
    }

    protected boolean isMove() {
        if (this.getLocation().x < 20 || this.getLocation().y < 20) {
            this.deactivate();
            return false;
        }
        return true;
    }

    public void mouseUp(MouseEvent me, EditPartViewer viewer) {
        if ((me.stateMask & 0x20000) != 0) {
            this.editPartViewer.setProperty("shiftPressed", (Object)true);
        } else {
            this.editPartViewer.setProperty("shiftPressed", (Object)false);
        }
        super.mouseUp(me, viewer);
    }

    protected boolean handleDragInProgress() {
        try {
            return super.handleDragInProgress();
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void executeCommand(Command command) {
        if (command instanceof CompoundCommand) {
            CompoundCommand compoundCmd = (CompoundCommand)command;
            TranslateCommand translateCommandFound = null;
            ArrayList cmdToDelete = new ArrayList();
            int i = 0;
            while (i < compoundCmd.getCommands().size()) {
                Object cmd = compoundCmd.getCommands().get(i);
                if (cmd instanceof TranslateCommand) {
                    if (translateCommandFound == null) {
                        translateCommandFound = (TranslateCommand)((Object)cmd);
                    } else {
                        cmdToDelete.add(cmd);
                    }
                }
                ++i;
            }
            compoundCmd.getCommands().removeAll(cmdToDelete);
            if (translateCommandFound != null && !compoundCmd.getCommands().contains((Object)translateCommandFound)) {
                compoundCmd.getCommands().add(translateCommandFound);
            }
        }
        super.executeCommand(command);
    }

    protected void updateTargetRequest() {
        if (this.getLocation().x < 20 || this.getLocation().y < 20) {
            this.deactivate();
            return;
        }
        this.repairStartLocation();
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getTargetRequest();
        request.setEditParts(this.getOperationSet());
        Dimension delta = this.getDragMoveDelta();
        request.setConstrainedMove(false);
        Point moveDelta = new Point(delta.width, delta.height);
        request.getExtendedData().clear();
        request.setMoveDelta(moveDelta);
        this.snapPoint(request);
        request.setLocation(this.getLocation());
        request.setType((Object)this.getCommandName());
    }
}

