/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.rulers.custom;

import fr.inra.adonis.editeurgraphique.rulers.AdonisRulerProvider;
import fr.inra.adonis.editeurgraphique.rulers.custom.AdonisRulerFigure;
import fr.inra.adonis.editeurgraphique.tools.GraphicalProperties;
import fr.inra.adonis.modeleMetier.graphique.Origine;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.rulers.RulerChangeListener;
import org.eclipse.gef.rulers.RulerProvider;
import org.eclipse.swt.accessibility.AccessibleEvent;

public class AdonisRulerEditPart
extends AbstractGraphicalEditPart {
    protected GraphicalViewer diagramViewer;
    private AccessibleEditPart accPart;
    private RulerProvider rulerProvider;
    private boolean horizontal;
    private final RulerChangeListener listener = new RulerChangeListener.Stub(){

        public void notifyGuideReparented(Object guide) {
            AdonisRulerEditPart.this.handleGuideReparented(guide);
        }

        public void notifyUnitsChanged(int newUnit) {
            AdonisRulerEditPart.this.handleUnitsChanged(newUnit);
        }
    };

    public AdonisRulerEditPart(Object model) {
        this.setModel(model);
    }

    public void activate() {
        this.getRulerProvider().addRulerChangeListener(this.listener);
        this.getRulerFigure().setZoomManager(this.getZoomManager());
        super.activate();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new RulerSelectionPolicy());
    }

    protected IFigure createFigure() {
        GraphicalProperties properties = (GraphicalProperties)this.getDiagramViewer().getProperty("graphicalProperties");
        Origine orgine = properties.getOrigine();
        AdonisRulerFigure ruler = new AdonisRulerFigure(this.isHorizontal(), this.getRulerProvider().getUnit(), orgine);
        ruler.setInterval(((AdonisRulerProvider)this.getRulerProvider()).getInterval(), -1);
        return ruler;
    }

    public void deactivate() {
        super.deactivate();
        this.getRulerProvider().removeRulerChangeListener(this.listener);
        this.rulerProvider = null;
        this.getRulerFigure().setZoomManager(null);
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accPart == null) {
            this.accPart = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

                public void getName(AccessibleEvent e) {
                    e.result = AdonisRulerEditPart.this.isHorizontal() ? GEFMessages.Ruler_Horizontal_Label : GEFMessages.Ruler_Vertical_Label;
                }

                public void getDescription(AccessibleEvent e) {
                    e.result = GEFMessages.Ruler_Desc;
                }
            };
        }
        return this.accPart;
    }

    protected GraphicalViewer getDiagramViewer() {
        return this.diagramViewer;
    }

    public DragTracker getDragTracker(Request request) {
        if (request.getType().equals("selection") && ((SelectionRequest)request).getLastButtonPressed() != 1) {
            return null;
        }
        return null;
    }

    public IFigure getGuideLayer() {
        LayerManager lm = (LayerManager)this.diagramViewer.getEditPartRegistry().get(LayerManager.ID);
        if (lm != null) {
            return lm.getLayer((Object)"Guide Layer");
        }
        return null;
    }

    protected List getModelChildren() {
        return this.getRulerProvider().getGuides();
    }

    protected AdonisRulerFigure getRulerFigure() {
        return (AdonisRulerFigure)this.getFigure();
    }

    public RulerProvider getRulerProvider() {
        return this.rulerProvider;
    }

    public EditPart getTargetEditPart(Request request) {
        if (request.getType().equals("move")) {
            return this;
        }
        return super.getTargetEditPart(request);
    }

    public ZoomManager getZoomManager() {
        return (ZoomManager)this.diagramViewer.getProperty(ZoomManager.class.toString());
    }

    public void handleGuideReparented(Object guide) {
        this.refreshChildren();
        EditPart guidePart = (EditPart)this.getViewer().getEditPartRegistry().get(guide);
        if (guidePart != null) {
            this.getViewer().select(guidePart);
        }
    }

    public void handleUnitsChanged(int newUnit) {
        this.getRulerFigure().setUnit(newUnit);
        if (newUnit == 2) {
            this.getRulerFigure().setInterval(100, 2);
        } else {
            this.getRulerFigure().setInterval(0, 0);
        }
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setParent(EditPart parent) {
        super.setParent(parent);
        if (this.getParent() != null && this.diagramViewer == null) {
            this.diagramViewer = (GraphicalViewer)this.getViewer().getProperty(GraphicalViewer.class.toString());
            RulerProvider hProvider = (RulerProvider)this.diagramViewer.getProperty("horizontal ruler");
            if (hProvider != null && hProvider.getRuler() == this.getModel()) {
                this.rulerProvider = hProvider;
                this.horizontal = true;
            } else {
                this.rulerProvider = (RulerProvider)this.diagramViewer.getProperty("vertical ruler");
            }
        }
    }

    public static class RulerSelectionPolicy
    extends SelectionEditPolicy {
        protected void hideFocus() {
            ((AdonisRulerFigure)this.getHostFigure()).setDrawFocus(false);
        }

        protected void hideSelection() {
            ((AdonisRulerFigure)this.getHostFigure()).setDrawFocus(false);
        }

        protected void showFocus() {
            ((AdonisRulerFigure)this.getHostFigure()).setDrawFocus(true);
        }

        protected void showSelection() {
            ((AdonisRulerFigure)this.getHostFigure()).setDrawFocus(true);
        }
    }
}

