/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.tools;

import fr.inra.adonis.editeurgraphique.EditeurGraphiqueActivator;
import fr.inra.adonis.editeurgraphique.part.ObjetMetierPart;
import fr.inra.adonis.editeurgraphique.tools.ObjectSelectionUtil;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.ZheAvecEpaisseur;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.navigator.CommonNavigator;

public class Synchronizer
implements IPropertyListener,
ISelectionChangedListener {
    private static boolean busy = false;
    private GraphicalViewer editeur;
    private CommonNavigator explorateur;
    private StructuredSelection lastStructuredSelection;
    private boolean waitForRefresh = false;

    public boolean waitForRefresh() {
        return this.waitForRefresh;
    }

    public void setWaitForRefresh(boolean waitForRefresh) {
        this.waitForRefresh = waitForRefresh;
        if (!waitForRefresh && this.lastStructuredSelection != null) {
            busy = true;
            this.explorateur.selectReveal((ISelection)this.lastStructuredSelection);
            busy = false;
        }
    }

    public Synchronizer(GraphicalViewer gv, CommonNavigator part) {
        this.editeur = gv;
        this.explorateur = part;
    }

    public void propertyChanged(Object source, int propId) {
        if (!busy && !this.waitForRefresh) {
            this.lastStructuredSelection = null;
            busy = true;
            IStructuredSelection selected = (IStructuredSelection)this.explorateur.getCommonViewer().getSelection();
            Iterator it = selected.iterator();
            ArrayList<EditPart> selection = new ArrayList<EditPart>();
            while (it.hasNext()) {
                EditPart ep;
                Object obj = it.next();
                if (!ObjetMetier.class.isInstance(obj) || (ep = ObjectSelectionUtil.parcoursEditParts((EditPart)this.editeur.getRootEditPart(), (ObjetMetier)obj)) == null) continue;
                selection.add(ep);
            }
            try {
                this.editeur.setSelection((ISelection)new StructuredSelection(selection));
                if (selection.size() > 0) {
                    this.editeur.reveal((EditPart)selection.get(0));
                }
            }
            catch (Exception e) {
                EditeurGraphiqueActivator.getLogger().logError((Throwable)e);
            }
            busy = false;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!busy) {
            this.lastStructuredSelection = null;
            busy = true;
            IStructuredSelection selected = (IStructuredSelection)event.getSelection();
            Iterator it = selected.iterator();
            ArrayList<ObjetMetier> selection = new ArrayList<ObjetMetier>();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!ObjetMetierPart.class.isInstance(obj)) continue;
                ObjetMetierPart part = (ObjetMetierPart)((Object)obj);
                ObjetMetier model = (ObjetMetier)part.getModel();
                selection.add(model);
                if (!(model instanceof ZheAvecEpaisseur)) continue;
                this.explorateur.getCommonViewer().expandToLevel((Object)((ZheAvecEpaisseur)model).getUniteDeParcours(), 2);
                this.explorateur.getCommonViewer().collapseToLevel((Object)((ZheAvecEpaisseur)model).getUniteDeParcours(), 2);
            }
            this.lastStructuredSelection = new StructuredSelection(selection);
            if (!this.waitForRefresh) {
                this.explorateur.selectReveal((ISelection)this.lastStructuredSelection);
                this.lastStructuredSelection = null;
            }
            busy = false;
        }
    }
}

