/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.tools.palette;

import fr.inra.adonis.core.util.DispositifUtil;
import fr.inra.adonis.core.util.EditorUtils;
import fr.inra.adonis.core.util.UtilisateurCourant;
import fr.inra.adonis.droitsacces.util.DroitsAccesUtil;
import fr.inra.adonis.editeurgraphique.AdonisGraphicalEditor;
import fr.inra.adonis.editeurgraphique.tools.palette.AdonisToolEntry;
import fr.inra.adonis.icons.IconsRegistry;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.EtatDispositif;
import fr.inra.adonis.modeleMetier.plateforme.ParcelleUnitaire;
import fr.inra.adonis.modeleMetier.protocole.Traitement;
import fr.inra.adonis.modeleMetier.utilisateur.TypeAction;
import fr.inra.adonis.modeleMetier.utilisateur.Utilisateur;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class SwitchTraitementsToolEntry
extends AdonisToolEntry {
    public SwitchTraitementsToolEntry() {
        super("Echanger les traitements", "Echanger les traitements des deux parcelles s\u00e9lectionn\u00e9es", ImageDescriptor.createFromImage((Image)IconsRegistry.IMG_ACQUISITION), ImageDescriptor.createFromImage((Image)IconsRegistry.IMG_ACQUISITION));
    }

    @Override
    public void execute(AdonisGraphicalEditor editor) {
        List partSelected = editor.getGraphicalViewer().getSelectedEditParts();
        if (partSelected.size() == 2) {
            EditPart obj1 = (EditPart)partSelected.get(0);
            EditPart obj2 = (EditPart)partSelected.get(1);
            if (obj1.getModel() instanceof ParcelleUnitaire && obj2.getModel() instanceof ParcelleUnitaire) {
                final ParcelleUnitaire pu1 = (ParcelleUnitaire)obj1.getModel();
                final ParcelleUnitaire pu2 = (ParcelleUnitaire)obj2.getModel();
                Dispositif disp = DispositifUtil.getDispositifFrom((EObject)pu1);
                if (disp == null || disp.getEtat() != EtatDispositif.CREE && disp.getEtat() != EtatDispositif.CONTROLE_AVALIDER && disp.getEtat() != EtatDispositif.SAISIE_COORDONNEE_AVALIDER || !DroitsAccesUtil.isDroitsAccesDispositif((Utilisateur)UtilisateurCourant.getInstance(), (Dispositif)disp, (TypeAction)TypeAction.EDITER)) {
                    MessageDialog.openError((Shell)editor.getGraphicalViewer().getControl().getShell(), (String)"Op\u00e9ration impossible", (String)"Les dispositifs concern\u00e9s ne sont pas dans un \u00e9tat permettant cette op\u00e9ration.");
                    return;
                }
                Dispositif disp2 = DispositifUtil.getDispositifFrom((EObject)pu2);
                if (disp == null || disp2.getEtat() != EtatDispositif.CREE && disp2.getEtat() != EtatDispositif.CONTROLE_AVALIDER && disp2.getEtat() != EtatDispositif.SAISIE_COORDONNEE_AVALIDER || !DroitsAccesUtil.isDroitsAccesDispositif((Utilisateur)UtilisateurCourant.getInstance(), (Dispositif)disp2, (TypeAction)TypeAction.EDITER)) {
                    MessageDialog.openError((Shell)editor.getGraphicalViewer().getControl().getShell(), (String)"Op\u00e9ration impossible", (String)"Les dispositifs concern\u00e9s ne sont pas dans un \u00e9tat permettant cette op\u00e9ration.");
                    return;
                }
                boolean confirm = MessageDialog.openConfirm((Shell)editor.getSite().getShell(), (String)"Echanger les traitements", (String)("Voulez vous \u00e9changer les traitements " + pu1.getTraitement().getNom() + " et " + pu2.getTraitement().getNom() + "?"));
                if (confirm) {
                    final Traitement t1 = pu1.getTraitement();
                    TransactionalEditingDomain editDomain = EditorUtils.getTransactionalEditingDomain();
                    editDomain.getCommandStack().execute((Command)new RecordingCommand(editDomain){

                        protected void doExecute() {
                            pu1.setTraitement(pu2.getTraitement());
                            pu2.setTraitement(t1);
                        }
                    });
                }
            } else {
                this.notAllowed(editor.getSite().getShell());
            }
        } else {
            this.notAllowed(editor.getSite().getShell());
        }
    }

    private void notAllowed(Shell parent) {
        MessageDialog.openError((Shell)parent, (String)"Op\u00e9ration impossible", (String)"S\u00e9lectionnez deux parcelles pour r\u00e9aliser l'\u00e9change de traitements");
    }
}

