/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.wizard;

import fr.inra.adonis.core.parcours.Parcours;
import fr.inra.adonis.core.rcp.AdonisLabelProvider;
import fr.inra.adonis.core.util.DispositifUtil;
import fr.inra.adonis.editeurgraphique.wizard.OperateurComparaisonManager;
import fr.inra.adonis.editeurgraphique.wizard.filtres.AbstractTableViewer;
import fr.inra.adonis.editeurgraphique.wizard.filtres.BlocsTableViewer;
import fr.inra.adonis.editeurgraphique.wizard.filtres.IndividusTableViewer;
import fr.inra.adonis.editeurgraphique.wizard.filtres.PusTableViewer;
import fr.inra.adonis.editeurgraphique.wizard.filtres.SsBlocsTableViewer;
import fr.inra.adonis.icons.IconsRegistry;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.Bloc;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.Individu;
import fr.inra.adonis.modeleMetier.plateforme.ParcelleUnitaire;
import fr.inra.adonis.modeleMetier.plateforme.Plateforme;
import fr.inra.adonis.modeleMetier.plateforme.SousBloc;
import fr.inra.adonis.modeleMetier.plateforme.TypeUniteParcours;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AdvancedDialog
extends TitleAreaDialog {
    protected GraphicalViewer graphicalViewer;
    protected ObjetMetier root;
    private ComboViewer operateursComboViewer;
    private ComboViewer niveauComboViewer;
    private ComboViewer colnameComboViewer;
    private Text colvalueTxt;
    private Label txtNbResult;
    private Button addFiltreBtn;
    private ListViewer filtresListViewer;
    private Button deleteFiltreBtn;
    private Composite mainComposite;
    private StackLayout mainStackLayout;
    private Composite individuComposite;
    private IndividusTableViewer individusTableViewer;
    private Composite puComposite;
    private PusTableViewer pusTableViewer;
    private Composite ssblocComposite;
    private SsBlocsTableViewer ssblocTableViewer;
    private Composite blocComposite;
    private BlocsTableViewer blocTableViewer;

    public AdvancedDialog(Shell parentShell, GraphicalViewer gv, ObjetMetier root) {
        super(parentShell);
        this.setShellStyle(2160);
        this.graphicalViewer = gv;
        this.root = root;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Point getInitialSize() {
        return new Point(700, 650);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = 20;
        gridLayout.horizontalSpacing = 20;
        gridLayout.marginTop = 20;
        gridLayout.marginBottom = 20;
        gridLayout.marginLeft = 20;
        gridLayout.marginRight = 20;
        container.setLayout((Layout)gridLayout);
        Label lblNiveau = new Label(container, 0);
        lblNiveau.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNiveau.setText("Niveau : ");
        this.niveauComboViewer = new ComboViewer(container, 0);
        Combo combo = this.niveauComboViewer.getCombo();
        GridData gd_combo = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_combo.widthHint = 154;
        combo.setLayoutData((Object)gd_combo);
        this.niveauComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.niveauComboViewer.setLabelProvider((IBaseLabelProvider)AdonisLabelProvider.getInstance());
        Group grpFiltre = new Group(container, 0);
        grpFiltre.setText("Filtre");
        GridLayout gl_grpFiltre = new GridLayout(3, false);
        gl_grpFiltre.horizontalSpacing = 20;
        grpFiltre.setLayout((Layout)gl_grpFiltre);
        grpFiltre.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.colnameComboViewer = new ComboViewer((Composite)grpFiltre, 0);
        GridData gd_combo_1 = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_combo_1.widthHint = 180;
        this.colnameComboViewer.getCombo().setLayoutData((Object)gd_combo_1);
        this.colnameComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.operateursComboViewer = new ComboViewer((Composite)grpFiltre, 0);
        GridData gd_combo_2 = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_combo_2.widthHint = 50;
        this.operateursComboViewer.getCombo().setLayoutData((Object)gd_combo_2);
        this.operateursComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.operateursComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.operateursComboViewer.setInput(OperateurComparaisonManager.getKeys());
        this.colvalueTxt = new Text((Composite)grpFiltre, 2048);
        GridData gd_text = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_text.widthHint = 170;
        this.colvalueTxt.setLayoutData((Object)gd_text);
        this.colvalueTxt.setToolTipText("Dans le cas o\u00f9 la valeur de la requ\u00eate est une image (ex: Individu mort), \n- Ne rien \u00e9crire signifie sans image (ex: l'individu n'est pas mort)\n- Ecrire quelque chose signifie avec image (ex: l'individu est mort)");
        this.addFiltreBtn = new Button((Composite)grpFiltre, 0);
        this.addFiltreBtn.setText("");
        this.addFiltreBtn.setImage(IconsRegistry.IMG_ADD);
        this.filtresListViewer = new ListViewer((Composite)grpFiltre, 2560);
        GridData gd_list = new GridData(4, 4, true, false, 2, 1);
        gd_list.heightHint = 53;
        this.filtresListViewer.getList().setLayoutData((Object)gd_list);
        this.filtresListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.deleteFiltreBtn = new Button((Composite)grpFiltre, 0);
        this.deleteFiltreBtn.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.deleteFiltreBtn.setText("");
        this.deleteFiltreBtn.setImage(IconsRegistry.IMG_DELETE);
        this.mainComposite = new Composite(container, 0);
        this.mainStackLayout = new StackLayout();
        this.mainComposite.setLayout((Layout)this.mainStackLayout);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.individuComposite = new Composite(this.mainComposite, 0);
        this.individuComposite.setLayout((Layout)new GridLayout(1, false));
        this.individusTableViewer = new IndividusTableViewer(this.individuComposite, 67584, this.root);
        this.individusTableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.puComposite = new Composite(this.mainComposite, 0);
        this.puComposite.setLayout((Layout)new GridLayout(1, false));
        this.pusTableViewer = new PusTableViewer(this.root, this.puComposite, 67584);
        this.pusTableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.ssblocComposite = new Composite(this.mainComposite, 0);
        this.ssblocComposite.setLayout((Layout)new GridLayout(1, false));
        this.ssblocTableViewer = new SsBlocsTableViewer(this.ssblocComposite, 67584);
        this.ssblocTableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.blocComposite = new Composite(this.mainComposite, 0);
        this.blocComposite.setLayout((Layout)new GridLayout(1, false));
        this.blocTableViewer = new BlocsTableViewer(this.blocComposite, 67584);
        this.blocTableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        Composite compoResult = new Composite(composite, 0);
        compoResult.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout gridLayoutResult = new GridLayout(2, false);
        gridLayoutResult.verticalSpacing = 20;
        gridLayoutResult.horizontalSpacing = 20;
        gridLayoutResult.marginTop = 20;
        gridLayoutResult.marginBottom = 20;
        gridLayoutResult.marginLeft = 20;
        gridLayoutResult.marginRight = 20;
        compoResult.setLayout((Layout)gridLayoutResult);
        Label lblNbResult = new Label(compoResult, 0);
        lblNbResult.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNbResult.setText("Nombre de r\u00e9sultats : ");
        this.txtNbResult = new Label(compoResult, 2048);
        GridData gd_textResult = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_textResult.widthHint = 170;
        this.txtNbResult.setLayoutData((Object)gd_textResult);
        this.addListeners();
        this.initialize();
        AbstractTableViewer table = this.getSelectedTable();
        this.txtNbResult.setText(Integer.toString(table.getFilteredInput().length));
        return container;
    }

    private void addListeners() {
        this.niveauComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    TypeUniteParcours selected = (TypeUniteParcours)selection.getFirstElement();
                    AbstractTableViewer table = null;
                    switch (selected) {
                        case INDIVIDU: {
                            ((AdvancedDialog)AdvancedDialog.this).mainStackLayout.topControl = AdvancedDialog.this.individuComposite;
                            table = AdvancedDialog.this.individusTableViewer;
                            break;
                        }
                        case PARCELLE: {
                            ((AdvancedDialog)AdvancedDialog.this).mainStackLayout.topControl = AdvancedDialog.this.puComposite;
                            table = AdvancedDialog.this.pusTableViewer;
                            break;
                        }
                        case SOUS_BLOC: {
                            ((AdvancedDialog)AdvancedDialog.this).mainStackLayout.topControl = AdvancedDialog.this.ssblocComposite;
                            table = AdvancedDialog.this.ssblocTableViewer;
                            break;
                        }
                        case BLOC: {
                            ((AdvancedDialog)AdvancedDialog.this).mainStackLayout.topControl = AdvancedDialog.this.blocComposite;
                            table = AdvancedDialog.this.blocTableViewer;
                            break;
                        }
                        default: {
                            ((AdvancedDialog)AdvancedDialog.this).mainStackLayout.topControl = AdvancedDialog.this.individuComposite;
                            table = AdvancedDialog.this.individusTableViewer;
                        }
                    }
                    String[] colnames = table.getTitles();
                    AdvancedDialog.this.colnameComboViewer.setInput((Object)colnames);
                    AdvancedDialog.this.filtresListViewer.setInput((Object)new Requete[0]);
                    AdvancedDialog.this.mainComposite.layout();
                }
            }
        });
        this.addFiltreBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection comboSelection = (StructuredSelection)AdvancedDialog.this.operateursComboViewer.getSelection();
                String op = (String)comboSelection.getFirstElement();
                StructuredSelection colnameSelection = (StructuredSelection)AdvancedDialog.this.colnameComboViewer.getSelection();
                if (!colnameSelection.isEmpty()) {
                    String colname = (String)colnameSelection.getFirstElement();
                    int i = 0;
                    String colvalue = AdvancedDialog.this.colvalueTxt.getText();
                    Requete req = new Requete(colname, op, colvalue);
                    Requete[] inputReq = (Requete[])AdvancedDialog.this.filtresListViewer.getInput();
                    Requete[] newInputReq = new Requete[inputReq.length + 1];
                    i = 0;
                    while (i < inputReq.length) {
                        newInputReq[i] = inputReq[i];
                        ++i;
                    }
                    newInputReq[inputReq.length] = req;
                    AdvancedDialog.this.filtresListViewer.setInput((Object)newInputReq);
                    AdvancedDialog.this.computeRequetes(newInputReq);
                }
            }
        });
        this.deleteFiltreBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection filtresSelection = (StructuredSelection)AdvancedDialog.this.filtresListViewer.getSelection();
                if (!filtresSelection.isEmpty()) {
                    List selection = filtresSelection.toList();
                    Requete[] inputReq = (Requete[])AdvancedDialog.this.filtresListViewer.getInput();
                    Requete[] newInputReq = new Requete[inputReq.length - selection.size()];
                    int i = 0;
                    Requete[] requeteArray = inputReq;
                    int n = inputReq.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Requete r = requeteArray[n2];
                        if (!selection.contains(r)) {
                            newInputReq[i] = r;
                            ++i;
                        }
                        ++n2;
                    }
                    AdvancedDialog.this.filtresListViewer.setInput((Object)newInputReq);
                    AdvancedDialog.this.computeRequetes(newInputReq);
                }
            }
        });
    }

    private void initialize() {
        boolean surfacique = false;
        if (this.root instanceof Plateforme) {
            for (Dispositif dispo : ((Plateforme)this.root).getDispositifs()) {
                boolean bl = surfacique = surfacique || dispo.isPuSurfacique();
            }
        } else {
            Dispositif dispo;
            dispo = DispositifUtil.getDispositifFrom((EObject)this.root);
            if (dispo != null) {
                surfacique = surfacique || dispo.isPuSurfacique();
            }
        }
        TypeUniteParcours[] typesInput = null;
        typesInput = surfacique ? new TypeUniteParcours[]{TypeUniteParcours.PARCELLE, TypeUniteParcours.SOUS_BLOC, TypeUniteParcours.BLOC} : new TypeUniteParcours[]{TypeUniteParcours.INDIVIDU, TypeUniteParcours.PARCELLE, TypeUniteParcours.SOUS_BLOC, TypeUniteParcours.BLOC};
        this.niveauComboViewer.setInput((Object)typesInput);
        final ArrayList individus = new ArrayList();
        final ArrayList pus = new ArrayList();
        final ArrayList ssblocs = new ArrayList();
        final ArrayList blocs = new ArrayList();
        Parcours parcours = new Parcours(){

            public void parcoursIndividu(Individu ind) {
                individus.add(ind);
            }

            public void parcoursParcelleUnitaire(ParcelleUnitaire pu) {
                pus.add(pu);
            }

            public void parcoursSousBloc(SousBloc sb) {
                ssblocs.add(sb);
            }

            public void parcoursBloc(Bloc b) {
                blocs.add(b);
            }
        };
        parcours.setAscendant(false);
        parcours.parcours(this.root);
        this.individusTableViewer.setInput(individus.toArray());
        this.pusTableViewer.setInput(pus.toArray());
        this.ssblocTableViewer.setInput(ssblocs.toArray());
        this.blocTableViewer.setInput(blocs.toArray());
        this.niveauComboViewer.setSelection((ISelection)new StructuredSelection((Object)typesInput[0]));
    }

    private void computeRequetes(Requete[] requetes) {
        AbstractTableViewer table = this.getSelectedTable();
        if (table != null) {
            table.getFilter().clearSearchEntry();
            Requete[] requeteArray = requetes;
            int n = requetes.length;
            int n2 = 0;
            while (n2 < n) {
                Requete req = requeteArray[n2];
                table.getFilter().addSearchEntry(req.colname, req.colvalue, req.op);
                ++n2;
            }
            table.refresh();
            this.txtNbResult.setText(Integer.toString(table.getFilteredInput().length));
        }
    }

    protected AbstractTableViewer getSelectedTable() {
        AbstractTableViewer table = null;
        if (this.mainStackLayout.topControl == this.individuComposite) {
            table = this.individusTableViewer;
        } else if (this.mainStackLayout.topControl == this.puComposite) {
            table = this.pusTableViewer;
        } else if (this.mainStackLayout.topControl == this.ssblocComposite) {
            table = this.ssblocTableViewer;
        } else if (this.mainStackLayout.topControl == this.blocComposite) {
            table = this.blocTableViewer;
        }
        return table;
    }

    private class Requete {
        String colname;
        String op;
        String colvalue;

        public Requete(String n, String v, String colvalue2) {
            this.colname = n;
            this.op = v;
            this.colvalue = colvalue2;
        }

        public String toString() {
            return String.valueOf(this.colname) + this.op + this.colvalue;
        }
    }
}

