/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.wizard.filtres;

import fr.inra.adonis.core.util.StringUtil;
import fr.inra.adonis.editeurgraphique.wizard.filtres.AbstractTableViewer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;

public class CommonFilter
extends ViewerFilter {
    private final AbstractTableViewer viewer;
    private final Map<Integer, List<CritereValue>> searchMap = new HashMap<Integer, List<CritereValue>>();

    public CommonFilter(AbstractTableViewer v) {
        this.viewer = v;
    }

    public void addSearchEntry(String colName, String value, String op) {
        Integer colIndex = this.viewer.getColumnIndex(colName);
        if (!this.searchMap.containsKey(colIndex)) {
            this.searchMap.put(colIndex, new ArrayList());
        }
        this.searchMap.get(colIndex).add(new CritereValue(op, value));
    }

    public void removeSearchEntry(Integer colIndex) {
        this.searchMap.remove(colIndex);
    }

    public void clearSearchEntry() {
        this.searchMap.clear();
    }

    public boolean select(Viewer pViewer, Object parentElement, Object element) {
        ColumnViewer tviewer = (ColumnViewer)pViewer;
        for (Integer colIndex : this.searchMap.keySet()) {
            ColumnLabelProvider labelProvider = (ColumnLabelProvider)tviewer.getLabelProvider(colIndex.intValue());
            String val = labelProvider.getText(element);
            boolean currentResult = false;
            for (CritereValue searchValue : this.searchMap.get(colIndex)) {
                if (val != null) {
                    if (!this.matchCritere(val, searchValue)) continue;
                    currentResult = true;
                    continue;
                }
                Image img = labelProvider.getImage(element);
                if ((img != null || !searchValue.getVal().isEmpty()) && (img == null || searchValue.getVal().isEmpty())) continue;
                currentResult = true;
            }
            if (currentResult) continue;
            return false;
        }
        return true;
    }

    private boolean matchCritere(String val, CritereValue cv) {
        return cv.match(val.toLowerCase());
    }

    private class CritereValue {
        private final String op;
        private final String val;

        public CritereValue(String op, String val) {
            this.op = op;
            this.val = val.toLowerCase();
        }

        public boolean match(String val) {
            int resultatCompareTo;
            if (StringUtil.isInteger((String)val) && StringUtil.isInteger((String)this.getVal())) {
                Integer i1 = Integer.parseInt(val);
                Integer i2 = Integer.parseInt(this.getVal());
                resultatCompareTo = i1.compareTo(i2);
            } else {
                resultatCompareTo = val.compareToIgnoreCase(this.getVal());
            }
            if (this.getOp().equals("<")) {
                return resultatCompareTo < 0;
            }
            if (this.getOp().equals(">")) {
                return resultatCompareTo > 0;
            }
            if (this.getOp().equals("<=")) {
                return resultatCompareTo <= 0;
            }
            if (this.getOp().equals(">=")) {
                return resultatCompareTo >= 0;
            }
            if (this.getOp().equals("CONTIENT")) {
                return val.toLowerCase().indexOf(this.getVal()) != -1;
            }
            if (this.getOp().equals("=")) {
                return resultatCompareTo == 0;
            }
            if (this.getOp().equals("!=")) {
                return resultatCompareTo != 0;
            }
            return false;
        }

        public String getOp() {
            return this.op;
        }

        public String getVal() {
            return this.val;
        }
    }
}

