/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.algorithmeplugin.carrelatin;

import fr.inra.adonis.modeleMetier.plateforme.TypeSpatialisation;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class AlgoDialog
extends TitleAreaDialog {
    private static final int DIALOG_MARGIN = 20;
    private final int nbTraitement;
    private final int nbRepetition;
    protected int nbIndsParPu = 1;
    protected int nbIndsParColonne = 1;
    private final boolean surfacique;
    private final TypeSpatialisation spatialisation;
    protected int nbSousBlocsParColonne = 1;
    protected int nbPusParColonne = 1;

    protected AlgoDialog(Shell parentShell, boolean surfacique, TypeSpatialisation spatialisation, int nbTrait, int nbRep) {
        super(parentShell);
        this.setShellStyle(65648);
        this.nbTraitement = nbTrait;
        this.nbRepetition = nbRep;
        this.surfacique = surfacique;
        this.spatialisation = spatialisation;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Mofifier les parametres de l'algorithme");
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle("Algorithme Carr\u00e9 Latin");
        this.setMessage("Merci de preciser la forme des Parcelles.", 1);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        container.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 10;
        gridLayout.marginTop = 20;
        gridLayout.marginBottom = 20;
        gridLayout.marginLeft = 20;
        gridLayout.marginRight = 20;
        container.setLayout((Layout)gridLayout);
        Group grpNbElements = new Group(container, 0);
        grpNbElements.setText("Nombre d'\u00e9l\u00e9ments");
        grpNbElements.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        grpNbElements.setLayout((Layout)new GridLayout(2, false));
        Label nbBlocLabel = new Label((Composite)grpNbElements, 0);
        nbBlocLabel.setText("Nombre de blocs : ");
        Text txtNbBlocs = new Text((Composite)grpNbElements, 2048);
        txtNbBlocs.setText(Integer.toString(this.nbRepetition));
        txtNbBlocs.setEnabled(false);
        Label nbPUTotal = new Label((Composite)grpNbElements, 0);
        nbPUTotal.setText("Nombre total de PU : ");
        Text txtNbPuTotal = new Text((Composite)grpNbElements, 2048);
        txtNbPuTotal.setText(Integer.toString(this.nbRepetition * this.nbTraitement));
        txtNbPuTotal.setEnabled(false);
        Group grpRepartition = new Group(container, 0);
        grpRepartition.setText("R\u00e9partition par colonne");
        grpRepartition.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        grpRepartition.setLayout((Layout)new GridLayout(2, false));
        Label lblLesBlocsSont = new Label((Composite)grpRepartition, 0);
        lblLesBlocsSont.setText("Les blocs sont dispos\u00e9s en colonne");
        new Label((Composite)grpRepartition, 0);
        grpRepartition.setVisible(this.spatialisation == TypeSpatialisation.BUREAU);
        Group grpForm = new Group(container, 0);
        grpForm.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        if (this.surfacique) {
            grpForm.setText("Facteur de forme");
        } else {
            grpForm.setText("Facteur de forme de la PU");
        }
        grpForm.setLayout((Layout)new GridLayout(2, false));
        Label lblNbInds = new Label((Composite)grpForm, 0);
        lblNbInds.setText("Nombre d'individus par parcelle : ");
        final Spinner spnNbIndsParPU = new Spinner((Composite)grpForm, 2048);
        spnNbIndsParPU.setMinimum(1);
        spnNbIndsParPU.setMaximum(30000);
        Label lblNbIndsParColonne = new Label((Composite)grpForm, 0);
        lblNbIndsParColonne.setText("Nombre d'individus par ligne: ");
        final Spinner spnNbIndsParColonne = new Spinner((Composite)grpForm, 2048);
        spnNbIndsParColonne.setMinimum(1);
        spnNbIndsParPU.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlgoDialog.this.nbIndsParPu = spnNbIndsParPU.getSelection();
                spnNbIndsParColonne.setMaximum(AlgoDialog.this.nbIndsParPu);
            }
        });
        spnNbIndsParColonne.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlgoDialog.this.nbIndsParColonne = spnNbIndsParColonne.getSelection();
            }
        });
        grpForm.setVisible(!this.surfacique);
        parent.pack();
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, "Annuler", false);
    }

    public int getNbIndsParPu() {
        return this.nbIndsParPu;
    }

    public int getNbIndsParColonne() {
        return this.nbIndsParColonne;
    }

    public int getNbSousBlocsParColonne() {
        return this.nbSousBlocsParColonne;
    }

    public int getNbPusParColonne() {
        return this.nbPusParColonne;
    }
}

