/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.List;
import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.ExtendsForbiddenException;
import org.eclipse.birt.report.model.api.command.InvalidParentException;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.command.ElementLocalizeRecord;
import org.eclipse.birt.report.model.command.ExtendsRecord;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.command.PropertyRecord;
import org.eclipse.birt.report.model.command.UserPropertyCommand;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;

public class ExtendsCommand
extends AbstractElementCommand {
    public ExtendsCommand(Module module, DesignElement obj) {
        super(module, obj);
    }

    public void setExtendsName(String base) throws ExtendsException {
        ElementRefValue retValue;
        block8: {
            base = StringUtil.trimString(base);
            if (this.element.isVirtualElement()) {
                throw new ExtendsForbiddenException(this.element, base, "Error.ExtendsForbiddenException.EXTENDS_FORBIDDEN");
            }
            if (base == null && this.element.getExtendsName() == null) {
                return;
            }
            ElementDefn metaData = (ElementDefn)this.element.getDefn();
            retValue = null;
            if (base == null) {
                if (!metaData.canExtend()) {
                    return;
                }
            } else {
                if (!metaData.canExtend()) {
                    throw new ExtendsForbiddenException(this.element, base, "Error.ExtendsForbiddenException.CANT_EXTEND");
                }
                ElementPropertyDefn propDefn = this.element.getPropertyDefn("extends");
                try {
                    retValue = (ElementRefValue)propDefn.validateValue(this.module, base);
                }
                catch (PropertyValueException propertyValueException) {
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError();
                }
            }
        }
        this.doSetExtendsRefValue(retValue);
    }

    private void doSetExtendsRefValue(ElementRefValue newExtendsValue) throws ExtendsException {
        if (newExtendsValue != null) {
            ElementDefn metaData = (ElementDefn)this.element.getDefn();
            PropertyDefn propDefn = (PropertyDefn)((Object)metaData.getProperty("extends"));
            DesignElement resolvedParent = null;
            Module root = this.module;
            if (!metaData.canExtend()) {
                throw new ExtendsForbiddenException(this.element, newExtendsValue.getName(), "Error.ExtendsForbiddenException.CANT_EXTEND");
            }
            resolvedParent = !newExtendsValue.isResolved() ? root.resolveElement(ReferenceValueUtil.needTheNamespacePrefix(newExtendsValue, this.module), propDefn, (IElementDefn)metaData) : root.resolveElement(newExtendsValue.getElement(), propDefn, (IElementDefn)metaData);
            DesignElement parent = newExtendsValue.getElement();
            if (parent != null && parent != resolvedParent) {
                throw new InvalidParentException(this.element, newExtendsValue.getName(), "Error.InvalidParentException.PARENT_NOT_FOUND");
            }
            if (parent == null && resolvedParent != null) {
                parent = resolvedParent;
                newExtendsValue.resolve(parent);
            }
            this.element.checkExtends(parent);
            if (metaData.getNameSpaceID() == 1) {
                IElementDefn moduleDefn = MetaDataDictionary.getInstance().getElement("Module");
                if (!parent.getContainer().getDefn().isKindOf(moduleDefn) || parent.getContainerInfo().getSlotID() != 5) {
                    throw new ExtendsForbiddenException(this.element, newExtendsValue.getName(), "Error.ExtendsForbiddenException.PARENT_NOT_IN_COMPONENT");
                }
            }
        }
        if (newExtendsValue != null && newExtendsValue.isResolved() && newExtendsValue.getElement() == this.element.getExtendsElement()) {
            return;
        }
        ActivityStack stack = this.getActivityStack();
        ExtendsRecord record = new ExtendsRecord(this.element, newExtendsValue);
        stack.startTrans(record.getLabel());
        this.adjustUserProperties(this.element, newExtendsValue == null ? null : newExtendsValue.getElement());
        stack.execute(record);
        stack.commit();
    }

    private void adjustUserProperties(DesignElement element, DesignElement parent) {
        ActivityStack stack = this.getActivityStack();
        DesignElement ancestor = element.getExtendsElement();
        while (ancestor != null && ancestor != parent) {
            List<UserPropertyDefn> props = ancestor.getUserProperties();
            if (props != null) {
                for (UserPropertyDefn prop : props) {
                    if (element.getLocalProperty(this.module, prop) == null) continue;
                    PropertyRecord record = new PropertyRecord(element, prop.getName(), null);
                    stack.execute(record);
                }
            }
            ancestor = ancestor.getExtendsElement();
        }
    }

    public void setExtendsElement(DesignElement parent) throws ExtendsException {
        if (parent == null) {
            this.setExtendsName(null);
            return;
        }
        String name = parent.getName();
        if (StringUtil.isBlank(name)) {
            throw new InvalidParentException(this.element, "", "Error.InvalidParentException.UNNAMED_PARENT");
        }
        Module module = parent.getRoot();
        name = parent.getFullName();
        if (module instanceof Library) {
            String namespace = ((Library)module).getNamespace();
            name = StringUtil.buildQualifiedReference(namespace, name);
        }
        this.setExtendsName(name);
    }

    public void setExtendsElement(DesignElementHandle parent) throws ExtendsException {
        if (parent == null) {
            this.setExtendsName(null);
            return;
        }
        String name = parent.getName();
        if (StringUtil.isBlank(name)) {
            throw new InvalidParentException(this.element, "", "Error.InvalidParentException.UNNAMED_PARENT");
        }
        this.setExtendsName(ReferenceValueUtil.needTheNamespacePrefix(parent.getElement(), parent.getModule(), this.module));
    }

    public void localizeElement() throws SemanticException {
        DesignElement parent = this.element.getExtendsElement();
        if (parent == null) {
            throw new InvalidParentException(this.element, null, "Error.InvalidParentException.NO_PARENT");
        }
        ContentIterator parentIter = new ContentIterator(parent.getRoot(), parent);
        ContentIterator childIter = new ContentIterator(this.module, this.element);
        while (parentIter.hasNext()) {
            assert (childIter.hasNext());
            DesignElement e1 = parentIter.next();
            DesignElement e2 = childIter.next();
            assert (e1.getDefn() == e2.getDefn());
            assert (e2.getBaseId() == e1.getID());
        }
        ActivityStack activityStack = this.getActivityStack();
        activityStack.startTrans(CommandLabelFactory.getCommandLabel("Message.SetExtends"));
        try {
            if (parent.getDefn().allowsUserProperties()) {
                for (UserPropertyDefn userPropertyDefn : parent.getUserProperties()) {
                    UserPropertyCommand command = new UserPropertyCommand(this.module, this.element);
                    command.addUserProperty(userPropertyDefn);
                }
            }
            for (ElementPropertyDefn elementPropertyDefn : parent.getDefn().getProperties()) {
                String propName = elementPropertyDefn.getName();
                if (!elementPropertyDefn.canInherit() || "style".equals(propName) || "extends".equals(propName) || "userProperties".equals(propName)) continue;
                Object localValue = this.element.getLocalProperty(this.module, elementPropertyDefn);
                Object parentValue = parent.getStrategy().getPropertyFromElement(this.module, parent, elementPropertyDefn);
                if (localValue != null || parentValue == null) continue;
                PropertyCommand command = new PropertyCommand(this.module, this.element);
                if (elementPropertyDefn.getTypeCode() == 16) {
                    command.makeLocalCompositeValue(new StructureContext(this.element, elementPropertyDefn, null));
                    continue;
                }
                command.setProperty(elementPropertyDefn, ModelUtil.copyValue(elementPropertyDefn, parentValue));
            }
            ExtendsCommand extendsCommand = new ExtendsCommand(this.module, this.element);
            extendsCommand.setExtendsElement((DesignElement)null);
        }
        catch (SemanticException ex) {
            activityStack.rollback();
            throw ex;
        }
        parentIter = new ContentIterator(parent.getRoot(), parent);
        childIter = new ContentIterator(this.module, this.element);
        while (parentIter.hasNext()) {
            DesignElement e1 = parentIter.next();
            DesignElement designElement = childIter.next();
            ElementLocalizeRecord record = new ElementLocalizeRecord(this.module, designElement, e1);
            activityStack.execute(record);
        }
        activityStack.commit();
    }

    protected void setExtendsRefValue(ElementRefValue refValue) throws ExtendsException {
        if (refValue == null && this.element.getExtendsName() == null) {
            return;
        }
        this.doSetExtendsRefValue(refValue);
    }
}

