/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ThemeException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.command.ThemeRecord;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;

public class ThemeCommand
extends AbstractElementCommand {
    public ThemeCommand(Module module) {
        super(module, module);
    }

    public void setTheme(String name) throws SemanticException {
        Object retValue = this.doValidateValue(name);
        this.doSetThemeRefValue((ElementRefValue)retValue);
    }

    public void setThemeElement(ThemeHandle theme) throws SemanticException {
        Object retValue;
        ElementRefValue refValue;
        if (theme == null) {
            this.setTheme(null);
            return;
        }
        String name = null;
        if (theme != null) {
            name = ReferenceValueUtil.needTheNamespacePrefix(theme.getElement(), theme.getModule(), (Module)this.element);
        }
        if ((refValue = (ElementRefValue)(retValue = this.doValidateValue(name))).isResolved() && refValue.getElement() != theme.getElement()) {
            throw new SemanticError(this.element, new String[]{"theme", refValue.getName()}, "Error.SemanticError.INVALID_ELEMENT_REF");
        }
        this.doSetThemeRefValue((ElementRefValue)retValue);
    }

    protected void setThemeRefValue(ElementRefValue refValue) throws SemanticException {
        if (refValue == null && ((Module)this.element).getThemeName() == null) {
            return;
        }
        this.doSetThemeRefValue(refValue);
    }

    private Object doValidateValue(String name) throws PropertyValueException {
        name = StringUtil.trimString(name);
        Module currentModule = (Module)this.element;
        ElementPropertyDefn propDefn = currentModule.getPropertyDefn("theme");
        if (name == null && currentModule.getThemeName() == null) {
            return null;
        }
        return propDefn.validateValue(currentModule, name);
    }

    private void doSetThemeRefValue(ElementRefValue newThemeValue) throws SemanticException {
        if (newThemeValue != null && !newThemeValue.isResolved()) {
            String name = ReferenceValueUtil.needTheNamespacePrefix(newThemeValue, (Module)this.element);
            throw new ThemeException(this.element, name, "Error.ThemeException.NOT_FOUND");
        }
        if (newThemeValue != null && newThemeValue.isResolved() && newThemeValue.getElement() == ((Module)this.element).getTheme()) {
            return;
        }
        ThemeRecord themeRecord = new ThemeRecord((Module)this.element, newThemeValue);
        this.getModule().getActivityStack().execute(themeRecord);
    }
}

