/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements.olap;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.olap.Cube;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;
import org.eclipse.birt.report.model.metadata.ElementRefValue;

public class TabularCube
extends Cube {
    public TabularCube() {
    }

    public TabularCube(String name) {
        super(name);
    }

    public void apply(ElementVisitor visitor) {
        visitor.visitTabularCube(this);
    }

    public String getElementName() {
        return "TabularCube";
    }

    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public TabularCubeHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new TabularCubeHandle(module, this);
        }
        return (TabularCubeHandle)this.handle;
    }

    public Object doClone(CopyPolicy policy) throws CloneNotSupportedException {
        DesignElement element = (DesignElement)super.doClone(policy);
        this.handleDefaultMeasureGroup(element);
        return element;
    }

    protected void handleDefaultMeasureGroup(DesignElement cloned) {
        Module module = this.getRoot();
        DesignElement measureGroup = this.getDefaultMeasureGroup(module);
        if (measureGroup != null) {
            int index = measureGroup.getIndex(module);
            DesignElement clonedMeasureGroup = new ContainerContext(cloned, "measureGroups").getContent(module, index);
            assert (clonedMeasureGroup != null);
            cloned.setProperty("defaultMeasureGroup", (Object)new ElementRefValue(null, clonedMeasureGroup));
        }
    }

    public void setDefaultMeasureGroup(int index) {
        List<Object> groups = this.getListProperty(this.getRoot(), "measureGroups");
        if (groups == null || groups.isEmpty()) {
            return;
        }
        if (index >= 0 && index < groups.size()) {
            this.setProperty("defaultMeasureGroup", (Object)new ElementRefValue(null, (DesignElement)groups.get(index)));
        }
    }
}

