/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.parser.DesignParseState;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ParserSchemaConstants;
import org.eclipse.birt.report.model.parser.ReportElementState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.AnyElementState;
import org.eclipse.birt.report.model.util.ElementStructureUtil;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.eclipse.birt.report.model.util.XMLParserHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class OverriddenValuesState
extends AbstractParseState {
    private ModuleParserHandler handler;
    private Map baseIdMap = new HashMap();
    private ReportElementState parentState;

    OverriddenValuesState(ModuleParserHandler handler, DesignElement element, ReportElementState partentState) {
        this.handler = handler;
        this.parentState = partentState;
        assert (element.canContainVirtualElements());
        this.baseIdMap = ElementStructureUtil.getIdMap(handler.module, element);
    }

    public XMLParserHandler getHandler() {
        return this.handler;
    }

    public AbstractParseState startElement(String tagName) {
        if ("ref-entry".equalsIgnoreCase(tagName)) {
            return new RefEntryState(this.handler);
        }
        return super.startElement(tagName);
    }

    class PropertyNodeState
    extends DesignParseState {
        private long id;
        private String propName;

        PropertyNodeState(ModuleParserHandler handler, long id) {
            super(handler);
            this.propName = null;
            this.id = id;
        }

        public DesignElement getElement() {
            return null;
        }

        public void end() throws SAXException {
            String value = this.text.toString();
            if (OverriddenValuesState.this.parentState != null) {
                OverriddenValuesState.this.parentState.insertOverridenPropertyValue(this.id, this.propName, value);
            }
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            this.propName = attrs.getValue("name");
        }
    }

    class RefEntryState
    extends DesignParseState {
        private long baseId;
        private boolean isBaseValid;

        RefEntryState(ModuleParserHandler handler) {
            super(handler);
            this.baseId = 0L;
            this.isBaseValid = true;
        }

        public XMLParserHandler getHandler() {
            return this.handler;
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            block14: {
                String baseIdStr = attrs.getValue("baseId");
                if (baseIdStr == null) {
                    return;
                }
                try {
                    this.baseId = Long.parseLong(baseIdStr);
                }
                catch (NumberFormatException numberFormatException) {
                    DesignParserException ex = new DesignParserException(new String[]{baseIdStr}, "Error.DesignParserException.INVALID_ELEMENT_ID");
                    this.handler.getErrorHandler().semanticError((Exception)((Object)ex));
                    this.isBaseValid = false;
                    return;
                }
                boolean handleWithParentState = false;
                DesignElement virtualChild = this.getElement();
                if (virtualChild == null) {
                    if (OverriddenValuesState.this.parentState.getElement().getExtendsElement() == null) {
                        handleWithParentState = true;
                    } else {
                        this.isBaseValid = false;
                        DesignParserException ex = new DesignParserException(new String[]{baseIdStr}, "Error.DesignParserException.VIRTUAL_PARENT_NOT_FOUND");
                        this.handler.getErrorHandler().semanticWarning((Exception)((Object)ex));
                        return;
                    }
                }
                String name = attrs.getValue("name");
                if (virtualChild != null && !StringUtil.isBlank(name)) {
                    virtualChild.setName(name);
                }
                long id = 0L;
                try {
                    String theID = attrs.getValue("id");
                    if (!StringUtil.isBlank(theID)) {
                        id = Long.parseLong(theID);
                        if (id <= 0L) {
                            if (virtualChild != null) {
                                this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException(new String[]{virtualChild.getIdentifier(), attrs.getValue("id")}, "Error.DesignParserException.INVALID_ELEMENT_ID")));
                            }
                            return;
                        }
                        if (handleWithParentState) {
                            OverriddenValuesState.this.parentState.insertOverriddenRefValue(this.baseId, new ReportElementState.OverriddenRefValue(id, name));
                            return;
                        }
                        DesignElement theElement = this.handler.module.getElementByID(id);
                        if (theElement != null && this.handler.versionNumber >= 3020700 && theElement != virtualChild) {
                            this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException(new String[]{theElement.getIdentifier(), virtualChild.getIdentifier()}, "Error.DesignParserException.DUPLICATE_ELEMENT_ID")));
                        }
                        virtualChild.setID(id);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (virtualChild == null) break block14;
                    this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException(new String[]{virtualChild.getIdentifier(), attrs.getValue("id")}, "Error.DesignParserException.INVALID_ELEMENT_ID")));
                }
            }
        }

        public DesignElement getElement() {
            Object obj = OverriddenValuesState.this.baseIdMap.get(this.baseId);
            return (DesignElement)obj;
        }

        public AbstractParseState startElement(String tagName) {
            if (!this.isBaseValid) {
                return new AnyElementState(this.getHandler());
            }
            if (OverriddenValuesState.this.parentState.getElement().getDefn().canExtend()) {
                return super.startElement(tagName);
            }
            int tagValue = tagName.toLowerCase().hashCode();
            if (ParserSchemaConstants.PROPERTY_TAG == tagValue) {
                return new PropertyNodeState(this.handler, this.baseId);
            }
            return new AnyElementState(this.getHandler());
        }
    }
}

