/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.crypto;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.crypto.AESFastEngine;
import com.lowagie.text.pdf.crypto.CBCBlockCipher;
import com.lowagie.text.pdf.crypto.KeyParameter;
import com.lowagie.text.pdf.crypto.PaddedBufferedBlockCipher;
import com.lowagie.text.pdf.crypto.ParametersWithIV;

public class AESCipher {
    private PaddedBufferedBlockCipher bp;

    public AESCipher(boolean bl, byte[] byArray, byte[] byArray2) {
        AESFastEngine aESFastEngine = new AESFastEngine();
        CBCBlockCipher cBCBlockCipher = new CBCBlockCipher(aESFastEngine);
        this.bp = new PaddedBufferedBlockCipher(cBCBlockCipher);
        KeyParameter keyParameter = new KeyParameter(byArray);
        ParametersWithIV parametersWithIV = new ParametersWithIV(keyParameter, byArray2);
        this.bp.init(bl, parametersWithIV);
    }

    public byte[] update(byte[] byArray, int n, int n2) {
        int n3 = this.bp.getUpdateOutputSize(n2);
        byte[] byArray2 = null;
        if (n3 > 0) {
            byArray2 = new byte[n3];
        } else {
            n3 = 0;
        }
        this.bp.processBytes(byArray, n, n2, byArray2, 0);
        return byArray2;
    }

    public byte[] doFinal() {
        int n = this.bp.getOutputSize(0);
        byte[] byArray = new byte[n];
        int n2 = 0;
        try {
            n2 = this.bp.doFinal(byArray, 0);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        if (n2 != byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return byArray;
    }
}

