/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSetCacheConfig;
import org.eclipse.birt.data.engine.executor.DataSourceAndDataSet;
import org.eclipse.birt.data.engine.executor.IDataSetCacheObject;
import org.eclipse.birt.data.engine.odi.IResultClass;

class CacheMapManager {
    private static Map JVMLevelCacheMap = Collections.synchronizedMap(new HashMap());
    private Map cacheMap;

    CacheMapManager(boolean useJVMLevelCache) {
        this.cacheMap = useJVMLevelCache ? JVMLevelCacheMap : new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doesSaveToCache(DataSourceAndDataSet dsAndDs, DataSetCacheConfig dscc) throws DataException {
        Map map = this.cacheMap;
        synchronized (map) {
            IDataSetCacheObject cacheObject = (IDataSetCacheObject)this.cacheMap.get(dsAndDs);
            if (cacheObject != null) {
                return cacheObject.needUpdateCache(dscc.getCacheCapability());
            }
            IDataSetCacheObject dsco = dscc.createDataSetCacheObject();
            this.cacheMap.put(dsAndDs, dsco);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doesLoadFromCache(DataSourceAndDataSet dsAndDs, int requiredCapability) {
        Map map = this.cacheMap;
        synchronized (map) {
            IDataSetCacheObject cacheObject = (IDataSetCacheObject)this.cacheMap.get(dsAndDs);
            if (cacheObject != null) {
                return cacheObject.isCachedDataReusable(requiredCapability);
            }
            return false;
        }
    }

    IDataSetCacheObject getCacheObject(DataSourceAndDataSet dsAndDs) {
        return (IDataSetCacheObject)this.cacheMap.get(dsAndDs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache(DataSourceAndDataSet dsAndDs) {
        ArrayList cacheObjects = new ArrayList();
        Map map = this.cacheMap;
        synchronized (map) {
            Object key = this.getKey(dsAndDs);
            while (key != null) {
                cacheObjects.add(this.cacheMap.remove(key));
                key = this.getKey(dsAndDs);
            }
        }
        int i = 0;
        while (i < cacheObjects.size()) {
            IDataSetCacheObject cacheObject = (IDataSetCacheObject)cacheObjects.get(i);
            cacheObject.release();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetForTest() {
        CacheMapManager cacheMapManager = this;
        synchronized (cacheMapManager) {
            this.cacheMap.clear();
        }
    }

    IResultClass getCachedResultClass(DataSourceAndDataSet dsAndDs) throws DataException {
        IDataSetCacheObject cacheObject = null;
        Object key = this.getKey(dsAndDs);
        if (key != null) {
            cacheObject = (IDataSetCacheObject)this.cacheMap.get(key);
        }
        if (cacheObject != null) {
            return cacheObject.getResultClass();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getKey(DataSourceAndDataSet dsAndDs) {
        Map map = this.cacheMap;
        synchronized (map) {
            for (DataSourceAndDataSet temp : this.cacheMap.keySet()) {
                if (!temp.isDataSourceDataSetEqual(dsAndDs, false)) continue;
                return temp;
            }
            return null;
        }
    }
}

