/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.birt.data.engine.expression.BytecodeExpression;
import org.eclipse.birt.data.engine.expression.ColumnReferenceExpression;
import org.eclipse.birt.data.engine.expression.CompiledExpression;

public final class ComplexExpression
extends BytecodeExpression {
    private ArrayList m_subExpressions;
    private ArrayList m_tokenList;
    private ArrayList m_constantExpressions;

    ComplexExpression() {
        logger.entering(ComplexExpression.class.getName(), "ComplexExpression");
        this.m_subExpressions = new ArrayList();
        this.m_tokenList = new ArrayList();
        this.m_constantExpressions = new ArrayList();
        logger.exiting(ComplexExpression.class.getName(), "ComplexExpression");
    }

    public int getType() {
        return 3;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof ComplexExpression)) {
            return false;
        }
        ComplexExpression expr2 = (ComplexExpression)other;
        if (this.m_subExpressions.size() != expr2.getSubExpressions().size()) {
            return false;
        }
        if (this.m_tokenList.size() != expr2.getTokenList().size()) {
            return false;
        }
        if (this.m_constantExpressions.size() != expr2.getConstantExpressions().size()) {
            return false;
        }
        Iterator iter = expr2.getSubExpressions().iterator();
        int i = 0;
        while (i < this.m_subExpressions.size()) {
            if (!this.m_subExpressions.get(i).equals(iter.next())) {
                return false;
            }
            ++i;
        }
        Iterator tokenIterator = expr2.getTokenList().iterator();
        int i2 = 0;
        while (i2 < this.m_tokenList.size()) {
            if (!this.m_tokenList.get(i2).equals(tokenIterator.next())) {
                return false;
            }
            ++i2;
        }
        Iterator constantIterator = expr2.getConstantExpressions().iterator();
        int i3 = 0;
        while (i3 < this.m_constantExpressions.size()) {
            if (!this.m_constantExpressions.get(i3).equals(constantIterator.next())) {
                return false;
            }
            ++i3;
        }
        return true;
    }

    void addSubExpressions(Collection subExprs) {
        assert (subExprs != null);
        this.m_subExpressions.addAll(subExprs);
    }

    void addSubExpression(CompiledExpression subExpr) {
        assert (subExpr != null);
        this.m_subExpressions.add(subExpr);
    }

    void addContantsExpressions(Collection subExprs) {
        assert (subExprs != null);
        this.m_constantExpressions.addAll(subExprs);
    }

    void addContantsExpressions(CompiledExpression subExprs) {
        assert (subExprs != null);
        this.m_constantExpressions.add(subExprs);
    }

    void addTokenList(Integer token) {
        this.m_tokenList.add(token);
    }

    Collection getTokenList() {
        return this.m_tokenList;
    }

    public Collection getConstantExpressions() {
        return this.m_constantExpressions;
    }

    public Collection getSubExpressions() {
        return this.m_subExpressions;
    }

    public int getGroupLevel() {
        int result = -1;
        boolean isOverall = false;
        int i = 0;
        while (i < this.m_subExpressions.size()) {
            if (this.m_subExpressions.get(i) instanceof BytecodeExpression) {
                int level = ((BytecodeExpression)this.m_subExpressions.get(i)).getGroupLevel();
                if (level > result) {
                    result = level;
                }
                if (level == 0) {
                    isOverall = true;
                }
            } else if (this.m_subExpressions.get(i) instanceof ColumnReferenceExpression) {
                isOverall = true;
            }
            ++i;
        }
        if (result != -1 && isOverall) {
            result = 0;
        }
        return result;
    }
}

