/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ExprEvaluateUtil;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.GroupComputedColumn;
import org.eclipse.birt.data.engine.impl.util.DirectedGraph;
import org.eclipse.birt.data.engine.impl.util.DirectedGraphEdge;
import org.eclipse.birt.data.engine.impl.util.GraphNode;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;

class ComputedColumnHelperInstance {
    private DataSetRuntime dataSet;
    private DataSetRuntime.Mode mode;
    private List ccList = new ArrayList();
    private IComputedColumn[] computedColumn;
    private int[] columnIndexArray;
    private boolean isPrepared;
    private ScriptContext cx;
    protected static Logger logger = Logger.getLogger(ComputedColumnHelper.class.getName());

    public ComputedColumnHelperInstance(DataSetRuntime dataSet, List computedColumns, DataSetRuntime.Mode mode, ScriptContext cx) throws DataException {
        int i = 0;
        while (i < computedColumns.size()) {
            this.ccList.add(computedColumns.get(i));
            ++i;
        }
        this.isPrepared = false;
        this.dataSet = dataSet;
        this.mode = mode;
        this.cx = cx.newContext((Object)this.dataSet.getScriptScope());
    }

    public List getComputedColumnList() {
        return this.ccList;
    }

    public boolean process(IResultObject resultObject, int rowIndex) throws DataException {
        logger.entering(ComputedColumnHelper.class.getName(), "process");
        assert (resultObject != null);
        IResultClass resultClass = resultObject.getResultClass();
        if (!this.isPrepared) {
            this.prepare(resultClass);
        }
        if (this.computedColumn.length == 0) {
            logger.exiting(ComputedColumnHelper.class.getName(), "process");
            return true;
        }
        this.dataSet.setRowObject(resultObject, true);
        this.dataSet.setCurrentRowIndex(rowIndex);
        DataSetRuntime.Mode temp = this.dataSet.getMode();
        this.dataSet.setMode(this.mode);
        try {
            int i = 0;
            while (i < this.computedColumn.length) {
                if (!this.isAggrComputedColumn(this.computedColumn[i])) {
                    if (this.computedColumn[i].getExpression() != null) {
                        Object value = null;
                        try {
                            if (this.computedColumn[i].getExpression().getHandle() != null && this.computedColumn[i].getExpression().getHandle() instanceof CompiledExpression) {
                                value = ExprEvaluateUtil.evaluateCompiledExpression((CompiledExpression)this.computedColumn[i].getExpression().getHandle(), resultObject, rowIndex, this.dataSet.getScriptScope(), this.cx);
                            } else {
                                IScriptExpression expr = (IScriptExpression)this.computedColumn[i].getExpression();
                                String exprText = expr.getText();
                                if (exprText != null) {
                                    if (expr.getHandle() == null) {
                                        expr.setHandle(this.cx.compile(expr.getScriptId(), null, 0, exprText));
                                    }
                                    value = expr.getHandle() != null && expr.getHandle() instanceof CompiledExpression ? ExprEvaluateUtil.evaluateCompiledExpression((CompiledExpression)expr.getHandle(), resultObject, rowIndex, this.dataSet.getScriptScope(), this.cx) : ScriptEvalUtil.evalExpr(expr, this.cx, null, 0);
                                }
                            }
                            if (this.computedColumn[i] instanceof GroupComputedColumn) {
                                try {
                                    value = ((GroupComputedColumn)this.computedColumn[i]).calculate(value);
                                }
                                catch (BirtException e) {
                                    throw DataException.wrap(e);
                                }
                            }
                            value = DataTypeUtil.convert((Object)value, (Class)resultClass.getFieldValueClass(this.columnIndexArray[i]));
                        }
                        catch (BirtException e) {
                            String fieldName = resultClass.getFieldName(this.columnIndexArray[i]);
                            if (fieldName != null && fieldName.startsWith("_{$TEMP_")) {
                                throw new DataException("data.engine.ScriptResult.WrongSystemComputedColumn", e);
                            }
                            if (resultClass.wasAnyType(this.columnIndexArray[i])) {
                                throw new DataException("data.engine.possibleMixedDataTypeInColumn", e);
                            }
                            throw new DataException("data.engine.CompCol.FailRetrieveValueComputedColumn", (Throwable)e, resultClass.getFieldName(this.columnIndexArray[i]));
                        }
                        resultObject.setCustomFieldValue(this.columnIndexArray[i], value);
                    } else {
                        throw new DataException("data.engine.BadCompColExpr", resultObject.getResultClass().getFieldName(this.columnIndexArray[i]));
                    }
                }
                ++i;
            }
        }
        finally {
            this.dataSet.setMode(temp);
        }
        logger.exiting(ComputedColumnHelper.class.getName(), "process");
        return true;
    }

    private boolean isAggrComputedColumn(IComputedColumn cc) {
        return cc.getAggregateFunction() != null;
    }

    public void setRePrepare(boolean rePrepare) {
        this.isPrepared = !rePrepare;
    }

    private void prepare(IResultClass resultClass) throws DataException {
        assert (resultClass != null);
        ArrayList<Integer> cmptList = new ArrayList<Integer>();
        HashMap<String, IComputedColumn> nameToComptCol = new HashMap<String, IComputedColumn>();
        int i = 0;
        while (i < this.ccList.size()) {
            IComputedColumn cmptdColumn = (IComputedColumn)this.ccList.get(i);
            int cmptdColumnIdx = resultClass.getFieldIndex(cmptdColumn.getName());
            if (cmptdColumnIdx >= 1 && resultClass.isCustomField(cmptdColumnIdx)) {
                cmptList.add(new Integer(i));
                nameToComptCol.put(cmptdColumn.getName(), cmptdColumn);
            }
            ++i;
        }
        int size = cmptList.size();
        this.columnIndexArray = new int[size];
        this.computedColumn = new IComputedColumn[size];
        int cmptColPos = 0;
        HashSet<DirectedGraphEdge> edges = new HashSet<DirectedGraphEdge>();
        int i2 = 0;
        while (i2 < size) {
            int pos = (Integer)cmptList.get(i2);
            IComputedColumn cmptdColumn = (IComputedColumn)this.ccList.get(pos);
            List referencedBindings = ExpressionCompilerUtil.extractColumnExpression(cmptdColumn.getExpression(), "row");
            boolean existReference = false;
            for (String name : referencedBindings) {
                if (!nameToComptCol.containsKey(name)) continue;
                edges.add(new DirectedGraphEdge(new GraphNode(cmptdColumn.getName()), new GraphNode(name)));
                existReference = true;
            }
            if (!existReference) {
                this.computedColumn[cmptColPos] = cmptdColumn;
                this.columnIndexArray[cmptColPos] = resultClass.getFieldIndex(cmptdColumn.getName());
                ++cmptColPos;
            }
            ++i2;
        }
        GraphNode[] nodes = null;
        try {
            nodes = new DirectedGraph(edges).flattenNodesByDependency();
        }
        catch (DirectedGraph.CycleFoundException e) {
            throw new DataException("data.engine.ComputedColumnCycle", e.getNode().getValue());
        }
        GraphNode[] graphNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            GraphNode node = graphNodeArray[n2];
            name = (String)node.getValue();
            boolean isAdded = false;
            int i3 = 0;
            while (i3 < cmptColPos) {
                if (name.equals(this.computedColumn[i3].getName())) {
                    isAdded = true;
                    break;
                }
                ++i3;
            }
            if (!isAdded) {
                IComputedColumn cmptdColumn;
                this.computedColumn[cmptColPos] = cmptdColumn = (IComputedColumn)nameToComptCol.get(name);
                this.columnIndexArray[cmptColPos] = resultClass.getFieldIndex(cmptdColumn.getName());
                ++cmptColPos;
            }
            ++n2;
        }
        this.isPrepared = true;
    }
}

