/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSetCacheManager;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.DataSourceRuntime;
import org.eclipse.birt.data.engine.impl.IPreparedQueryService;
import org.eclipse.birt.data.engine.impl.IQueryContextVisitor;
import org.eclipse.birt.data.engine.impl.IQueryExecutor;
import org.eclipse.birt.data.engine.impl.IQueryService;
import org.eclipse.birt.data.engine.impl.ParameterUtil;
import org.eclipse.birt.data.engine.impl.PreparedQuery;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Scriptable;

public abstract class PreparedDataSourceQuery
implements IPreparedQuery,
IPreparedQueryService {
    protected IBaseDataSetDesign dataSetDesign;
    protected DataEngineImpl dataEngine;
    protected IQueryDefinition queryDefn;
    protected PreparedQuery preparedQuery;
    protected Map appContext;
    protected IQueryContextVisitor contextVisitor;
    protected static Logger logger = Logger.getLogger(PreparedDataSourceQuery.class.getName());

    public PreparedDataSourceQuery(DataEngineImpl dataEngine, IQueryDefinition queryDefn, IBaseDataSetDesign dataSetDesign, Map appContext, IQueryContextVisitor contextVisitor) throws DataException {
        Object[] params = new Object[]{dataEngine, queryDefn, dataSetDesign, appContext};
        logger.entering(PreparedDataSourceQuery.class.getName(), "PreparedDataSourceQuery", params);
        this.dataSetDesign = dataSetDesign;
        this.queryDefn = queryDefn;
        this.dataEngine = dataEngine;
        this.appContext = appContext;
        this.preparedQuery = new PreparedQuery(dataEngine.getSession(), dataEngine.getContext(), queryDefn, this, appContext);
        this.contextVisitor = contextVisitor;
        logger.exiting(PreparedDataSourceQuery.class.getName(), "PreparedDataSourceQuery");
    }

    PreparedDataSourceQuery(DataEngineImpl dataEngine, IBaseQueryDefinition baseQueryDefn, IQueryDefinition queryDefn, IBaseDataSetDesign dataSetDesign, Map appContext) throws DataException {
        Object[] params = new Object[]{dataEngine, baseQueryDefn, queryDefn, dataSetDesign, appContext};
        logger.entering(PreparedDataSourceQuery.class.getName(), "PreparedDataSourceQuery", params);
        this.dataSetDesign = dataSetDesign;
        this.queryDefn = queryDefn;
        this.dataEngine = dataEngine;
        this.appContext = appContext;
        this.preparedQuery = new PreparedQuery(dataEngine.getSession(), dataEngine.getContext(), baseQueryDefn, this, appContext);
        logger.exiting(PreparedDataSourceQuery.class.getName(), "PreparedDataSourceQuery");
    }

    public IQueryDefinition getReportQueryDefn() {
        return this.queryDefn;
    }

    public PreparedDataSourceQuery getDataSourceQuery() {
        return this;
    }

    public IQueryResults execute(Scriptable scope) throws DataException {
        return this.execute(null, scope);
    }

    public IQueryResults execute(IQueryResults outerResults, Scriptable scope) throws DataException {
        return this.execute((IBaseQueryResults)outerResults, scope);
    }

    public IQueryResults execute(IBaseQueryResults outerResults, Scriptable scope) throws DataException {
        this.configureDataSetCache(outerResults instanceof IQueryService ? ((IQueryService)((Object)outerResults)).getQueryScope() : null, this.queryDefn, this.appContext, scope != null ? scope : this.dataEngine.getSession().getSharedScope());
        this.initializeExecution(outerResults, scope);
        return this.produceQueryResults(outerResults, scope);
    }

    protected IQueryResults produceQueryResults(IBaseQueryResults outerResults, Scriptable scope) throws DataException {
        return this.preparedQuery.doPrepare(outerResults, scope, this.newExecutor(), this);
    }

    protected void initializeExecution(IBaseQueryResults outerResults, Scriptable scope) throws DataException {
    }

    private void configureDataSetCache(Scriptable outerScope, IQueryDefinition querySpec, Map appContext, Scriptable scope) throws DataException {
        if (querySpec == null) {
            return;
        }
        String queryResultID = querySpec.getQueryResultsID();
        if (queryResultID != null) {
            return;
        }
        if (this.dataSetDesign == null) {
            return;
        }
        Collection parameterHints = null;
        IBaseDataSourceDesign dataSourceDesign = null;
        DataSourceRuntime dsRuntime = this.dataEngine.getDataSourceRuntime(this.dataSetDesign.getDataSourceName());
        if (dsRuntime != null) {
            dataSourceDesign = dsRuntime.getDesign();
            DataSetRuntime dataSet = DataSetRuntime.newInstance(this.dataSetDesign, null, this.dataEngine.getSession());
            parameterHints = new ParameterUtil(outerScope, dataSet, this.queryDefn, scope, this.dataEngine.getSession().getEngineContext().getScriptContext()).resolveDataSetParameters(true);
        }
        this.getDataSetCacheManager().setDataSourceAndDataSet(dataSourceDesign, this.dataSetDesign, parameterHints, this.appContext);
    }

    protected DataSetCacheManager getDataSetCacheManager() {
        return this.dataEngine.getSession().getDataSetCacheManager();
    }

    protected abstract QueryExecutor newExecutor() throws DataException;

    public IQueryResults execSubquery(IResultIterator iterator, IQueryExecutor parentExecutor, String subQueryName, Scriptable subScope) throws DataException {
        return this.preparedQuery.execSubquery(iterator, parentExecutor, subQueryName, subScope);
    }

    public abstract class DSQueryExecutor
    extends QueryExecutor {
        public DSQueryExecutor() {
            super(PreparedDataSourceQuery.this.preparedQuery.getSharedScope(), PreparedDataSourceQuery.this.preparedQuery.getBaseQueryDefn(), PreparedDataSourceQuery.this.preparedQuery.getAggrTable(), PreparedDataSourceQuery.this.dataEngine.getSession(), PreparedDataSourceQuery.this.contextVisitor);
        }

        protected DataSourceRuntime findDataSource() throws DataException {
            assert (PreparedDataSourceQuery.this.dataSetDesign != null);
            DataSourceRuntime dsRT = PreparedDataSourceQuery.this.dataEngine.getDataSourceRuntime(PreparedDataSourceQuery.this.dataSetDesign.getDataSourceName());
            return dsRT;
        }

        protected DataSetRuntime newDataSetRuntime() throws DataException {
            return DataSetRuntime.newInstance(PreparedDataSourceQuery.this.dataSetDesign, this, this.getSession());
        }

        protected boolean fromCache() throws DataException {
            return PreparedDataSourceQuery.this.dataEngine.getSession().getDataSetCacheManager().doesLoadFromCache(this.dataSource.getDesign(), this.dataSet.getDesign(), new ParameterUtil(this.tabularOuterResults == null ? null : this.tabularOuterResults.getQueryScope(), this.dataSet, PreparedDataSourceQuery.this.queryDefn, this.getQueryScope(), PreparedDataSourceQuery.this.dataEngine.getSession().getEngineContext().getScriptContext()).resolveDataSetParameters(true), PreparedDataSourceQuery.this.appContext);
        }
    }
}

