/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import com.ibm.icu.util.ULocale;
import java.util.Hashtable;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.PropertySecurity;
import org.eclipse.birt.data.engine.odaconsumer.DataSetCapabilities;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connection {
    private String m_dataSourceId;
    private IConnection m_connection;
    private Hashtable<String, DataSetCapabilities> m_cachedDsMetaData;
    private static String sm_className = Connection.class.getName();
    private static String sm_loggerName = "org.eclipse.birt.data.engine.odaconsumer";
    private static LogHelper sm_logger = LogHelper.getInstance(sm_loggerName);

    Connection(IConnection connection, String dataSourceId) throws OdaException {
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, "Connection", new Object[]{connection, dataSourceId});
        }
        assert (connection != null && connection.isOpen());
        this.m_dataSourceId = dataSourceId;
        this.m_connection = connection;
        sm_logger.exiting(sm_className, "Connection", this);
    }

    public boolean isOpen() throws DataException {
        sm_logger.entering(sm_className, "isOpen");
        try {
            boolean ret = this.m_connection.isOpen();
            sm_logger.exiting(sm_className, "isOpen", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwDataException(ex, "odaconsumer.CannotCheckOpenConnection", "isOpen", "Unable to check isOpen.");
        }
        catch (UnsupportedOperationException ex) {
            this.throwDataException(ex, "odaconsumer.CannotCheckOpenConnection", "isOpen", "Unable to check isOpen.");
        }
        return false;
    }

    public int getMaxQueries() throws DataException {
        sm_logger.entering(sm_className, "getMaxQueries");
        try {
            int ret = this.m_connection.getMaxQueries();
            sm_logger.exiting(sm_className, "getMaxQueries", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwDataException(ex, "odaconsumer.CannotGetMaxStatements", "getMaxQueries", "Cannot get max queries.");
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.INFO, sm_className, "getMaxQueries", "Cannot get max queries.", ex);
        }
        return 0;
    }

    public DataSetCapabilities getMetaData(String dataSetType) throws DataException {
        sm_logger.entering(sm_className, "getMetaData", dataSetType);
        String cachedKey = dataSetType == null ? this.getDataSourceId() : dataSetType;
        DataSetCapabilities capabilities = this.getCachedDsMetaData().get(cachedKey);
        if (capabilities == null) {
            IDataSetMetaData dsMetaData = null;
            try {
                dsMetaData = this.m_connection.getMetaData(dataSetType);
            }
            catch (OdaException ex) {
                this.throwDataException((Throwable)ex, dataSetType, "odaconsumer.CannotGetDataSetMetaData", "getMetaData", "Cannot get data set metadata.");
            }
            catch (UnsupportedOperationException ex) {
                this.throwDataException((Throwable)ex, dataSetType, "odaconsumer.CannotGetDataSetMetaData", "getMetaData", "Cannot get data set metadata.");
            }
            capabilities = new DataSetCapabilities(dsMetaData);
            this.getCachedDsMetaData().put(cachedKey, capabilities);
        }
        sm_logger.exiting(sm_className, "getMetaData", capabilities);
        return capabilities;
    }

    public PreparedStatement prepareStatement(String query, String dataSetType) throws DataException {
        return this.prepareStatement(query, dataSetType, null);
    }

    public PreparedStatement prepareStatement(String query, String dataSetType, QuerySpecification querySpec) throws DataException {
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, "prepareStatement(String,String,QuerySpecification)", new Object[]{query, dataSetType});
        }
        IQuery statement = this.prepareOdaQuery(query, dataSetType, querySpec);
        PreparedStatement ret = new PreparedStatement(statement, dataSetType, this, query);
        sm_logger.exiting(sm_className, "prepareStatement(String,String,QuerySpecification)", ret);
        return ret;
    }

    public void setLocale(ULocale locale) throws DataException {
        sm_logger.entering(sm_className, "setLocale(ULocale)");
        try {
            this.m_connection.setLocale(locale);
        }
        catch (OdaException ex) {
            this.throwDataException((Throwable)ex, locale, "odaconsumer.CannotSetConnectionLocale", "setLocale(ULocale)", "Unable to set locale: " + locale);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.WARNING, sm_className, "setLocale(ULocale)", "Unable to set locale: " + locale + ". Using default locale instead.", ex);
        }
        sm_logger.exiting(sm_className, "setLocale(ULocale)");
    }

    public void close() throws DataException {
        sm_logger.entering(sm_className, "close");
        try {
            this.m_connection.close();
        }
        catch (OdaException ex) {
            this.throwDataException(ex, "odaconsumer.CannotCloseConnection", "close", "Cannot close connection.");
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.WARNING, sm_className, "close", "Cannot close connection.", ex);
        }
        sm_logger.exiting(sm_className, "close");
    }

    private Hashtable<String, DataSetCapabilities> getCachedDsMetaData() {
        if (this.m_cachedDsMetaData == null) {
            this.m_cachedDsMetaData = PropertySecurity.createHashtable();
        }
        return this.m_cachedDsMetaData;
    }

    String getDataSourceId() {
        return this.m_dataSourceId;
    }

    IQuery prepareOdaQuery(String query, String dataSetType, QuerySpecification querySpec) throws DataException {
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, "prepareOdaQuery", new Object[]{query, dataSetType, querySpec});
        }
        try {
            assert (this.m_connection.isOpen());
            IQuery statement = this.m_connection.newQuery(dataSetType);
            this.setOdaQuerySpec(statement, querySpec);
            statement.prepare(query);
            sm_logger.exiting(sm_className, "prepareOdaQuery", statement);
            return statement;
        }
        catch (OdaException ex) {
            this.throwDataException((Throwable)ex, new Object[]{query, dataSetType}, "odaconsumer.CannotPrepareStatement", "prepareOdaQuery", "Cannot prepare statement.");
        }
        catch (UnsupportedOperationException ex) {
            this.throwDataException((Throwable)ex, new Object[]{query, dataSetType}, "odaconsumer.CannotPrepareStatement", "prepareOdaQuery", "Cannot prepare statement.");
        }
        return null;
    }

    private void setOdaQuerySpec(IQuery statement, QuerySpecification querySpec) throws OdaException {
        sm_logger.entering(sm_className, "setOdaQuerySpec", querySpec);
        try {
            if (querySpec != null) {
                statement.setSpecification(querySpec);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            sm_logger.logp(Level.FINE, sm_className, "setOdaQuerySpec", "Ignoring the UnsupportedOperationException thrown by ODA driver (" + this.getDataSourceId() + ") on IQuery#setSpecification.  This call is optional and does not affect query processing.");
        }
        sm_logger.exiting(sm_className, "setOdaQuerySpec");
    }

    private void throwDataException(Throwable ex, String errorCode, String methodName, String logMsg) throws DataException {
        sm_logger.logp(Level.SEVERE, sm_className, methodName, logMsg, ex);
        throw new DataException(errorCode, ex);
    }

    private void throwDataException(Throwable ex, Object argv, String errorCode, String methodName, String logMsg) throws DataException {
        sm_logger.logp(Level.SEVERE, sm_className, methodName, logMsg, ex);
        throw new DataException(errorCode, ex, argv);
    }

    private void throwDataException(Throwable ex, Object[] argv, String errorCode, String methodName, String logMsg) throws DataException {
        sm_logger.logp(Level.SEVERE, sm_className, methodName, logMsg, ex);
        throw new DataException(errorCode, ex, argv);
    }
}

