/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDrillFilter;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.DataType;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrilledAggregateResultSet
implements IAggregationResultSet {
    private static Logger logger = Logger.getLogger(DrilledAggregateResultSet.class.getName());
    private int levelCount = 0;
    private int currentPosition;
    private IDiskArray bufferedStructureArray;
    private IAggregationResultRow resultObject;
    private IAggregationResultSet metaResultSet;
    private int[][] attributeDataTypes;
    private int[][] keyDataTypes;
    private boolean[] statusForRs;

    public DrilledAggregateResultSet(IAggregationResultSet baseResultSet, List<IAggregationResultSet> drillsRs, List<IEdgeDrillFilter> drillsDefn) throws IOException {
        Object[] params = new Object[]{baseResultSet, drillsRs, drillsDefn};
        logger.entering(AggregationResultSet.class.getName(), "MergedAggregateResultSet", params);
        this.levelCount = baseResultSet.getLevelCount();
        this.metaResultSet = baseResultSet;
        this.statusForRs = new boolean[drillsRs.size()];
        int i = 0;
        while (i < drillsRs.size()) {
            if (this.levelCount < drillsRs.get(i).getLevelCount()) {
                this.metaResultSet = drillsRs.get(i);
                this.levelCount = this.metaResultSet.getLevelCount();
            }
            drillsRs.get(i).seek(0);
            this.statusForRs[i] = true;
            ++i;
        }
        this.bufferedStructureArray = this.passBaseCubeResultSet(baseResultSet, drillsRs, drillsDefn);
        this.updateStatus(drillsRs);
        while (!this.isComplete()) {
            this.bufferedStructureArray = this.passInterimCubeResultSet(this.bufferedStructureArray, drillsRs, drillsDefn);
            this.updateStatus(drillsRs);
        }
        this.resultObject = (IAggregationResultRow)this.bufferedStructureArray.get(0);
        if (this.resultObject.getLevelMembers() != null) {
            this.keyDataTypes = new int[this.resultObject.getLevelMembers().length][];
            this.attributeDataTypes = new int[this.resultObject.getLevelMembers().length][];
            i = 0;
            while (i < this.resultObject.getLevelMembers().length) {
                this.keyDataTypes[i] = new int[this.resultObject.getLevelMembers()[i].getKeyValues().length];
                int j = 0;
                while (j < this.resultObject.getLevelMembers()[i].getKeyValues().length) {
                    this.keyDataTypes[i][j] = DataType.getDataType(this.resultObject.getLevelMembers()[i].getKeyValues()[j].getClass());
                    ++j;
                }
                if (this.resultObject.getLevelMembers()[i].getAttributes() != null) {
                    this.attributeDataTypes[i] = new int[this.resultObject.getLevelMembers()[i].getAttributes().length];
                    j = 0;
                    while (j < this.attributeDataTypes[i].length) {
                        if (this.resultObject.getLevelMembers()[i].getAttributes()[j] != null) {
                            this.attributeDataTypes[i][j] = DataType.getDataType(this.resultObject.getLevelMembers()[i].getAttributes()[j].getClass());
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private void updateStatus(List<IAggregationResultSet> drillsRs) {
        int i = 0;
        while (i < drillsRs.size()) {
            IAggregationResultSet rs = drillsRs.get(i);
            if (rs.getPosition() == rs.length() - 1) {
                this.statusForRs[i] = false;
            }
            ++i;
        }
    }

    private BufferedStructureArray passBaseCubeResultSet(IAggregationResultSet baseResultSet, List<IAggregationResultSet> drillResultSets, List<IEdgeDrillFilter> drillFilters) throws IOException {
        BufferedStructureArray tempBufferArray = new BufferedStructureArray(AggregationResultRow.getCreator(), 2000);
        ArrayList<Member[]> previewMemberList = new ArrayList<Member[]>();
        int i = 0;
        while (i < baseResultSet.length()) {
            baseResultSet.seek(i);
            IAggregationResultRow row = baseResultSet.getCurrentRow();
            List<Member[]> currentMemberList = this.getDrilledMemberList(row.getLevelMembers(), drillResultSets, drillFilters);
            this.addMemberIntoBufferedArray(tempBufferArray, currentMemberList, previewMemberList);
            ++i;
        }
        return tempBufferArray;
    }

    private void addMemberIntoBufferedArray(BufferedStructureArray tempBufferArray, List<Member[]> currentMemberList, List<Member[]> previewMemberList) throws IOException {
        boolean addToBuffer = false;
        if (previewMemberList.size() == currentMemberList.size()) {
            int t1 = 0;
            while (t1 < currentMemberList.size()) {
                Member[] currentMember;
                Member[] previousMember = previewMemberList.get(t1);
                if (previousMember.length == (currentMember = currentMemberList.get(t1)).length) {
                    int t2 = 0;
                    while (t2 < previousMember.length) {
                        if (!previousMember[t2].equals(currentMember[t2])) {
                            addToBuffer = true;
                            break;
                        }
                        ++t2;
                    }
                } else {
                    addToBuffer = true;
                }
                if (!addToBuffer) {
                    ++t1;
                    continue;
                }
                break;
            }
        } else {
            addToBuffer = true;
        }
        if (addToBuffer) {
            int j = 0;
            while (j < currentMemberList.size()) {
                tempBufferArray.add(new AggregationResultRow(currentMemberList.get(j), null));
                ++j;
            }
            previewMemberList.clear();
            previewMemberList.addAll(currentMemberList);
        }
    }

    private BufferedStructureArray passInterimCubeResultSet(IDiskArray bufferedStructureArray, List<IAggregationResultSet> drillResultSets, List<IEdgeDrillFilter> drillFilters) throws IOException {
        BufferedStructureArray tempBufferArray = new BufferedStructureArray(Member.getCreator(), 2000);
        ArrayList<Member[]> previewMemberList = new ArrayList<Member[]>();
        int i = 0;
        while (i < bufferedStructureArray.size()) {
            IAggregationResultRow row = (IAggregationResultRow)bufferedStructureArray.get(i);
            List<Member[]> currentMemberList = this.getDrilledMemberList(row.getLevelMembers(), drillResultSets, drillFilters);
            this.addMemberIntoBufferedArray(tempBufferArray, currentMemberList, previewMemberList);
            ++i;
        }
        bufferedStructureArray.close();
        return tempBufferArray;
    }

    private List<Member[]> getDrilledMemberList(Member[] member, List<IAggregationResultSet> drillResultsets, List<IEdgeDrillFilter> drillFilters) throws IOException {
        ArrayList<Member[]> result = new ArrayList<Member[]>();
        boolean matched = false;
        IEdgeDrillFilter appliedDrill = null;
        int i = 0;
        while (i < drillFilters.size()) {
            IEdgeDrillFilter drill = drillFilters.get(i);
            if (this.statusForRs[i]) {
                Object[] tuple = drill.getTuple().toArray();
                int j = 0;
                while (j < tuple.length) {
                    if (!(tuple[j] == null || ((Object[])tuple[j])[0] == null || member.length > j && this.containMember(member[j], (Object[])tuple[j]))) {
                        matched = false;
                        break;
                    }
                    matched = true;
                    ++j;
                }
                if (matched) {
                    appliedDrill = drill;
                    break;
                }
            }
            ++i;
        }
        if (appliedDrill != null) {
            if (!this.statusForRs[drillFilters.indexOf(appliedDrill)]) {
                return Collections.EMPTY_LIST;
            }
            IAggregationResultSet rs = drillResultsets.get(drillFilters.indexOf(appliedDrill));
            int k = rs.getPosition();
            while (k < rs.length()) {
                rs.seek(k);
                IAggregationResultRow row = rs.getCurrentRow();
                if (this.isDrilledElement(member, row.getLevelMembers(), appliedDrill)) {
                    Member[] drillMember = new Member[rs.getLevelCount()];
                    System.arraycopy(row.getLevelMembers(), 0, drillMember, 0, row.getLevelMembers().length);
                    result.add(drillMember);
                    ++k;
                    continue;
                }
                break;
            }
        } else {
            result.add(member);
        }
        return result;
    }

    private boolean isComplete() {
        int i = 0;
        while (i < this.statusForRs.length) {
            if (this.statusForRs[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean containMember(Member member, Object[] key) {
        Object[] memberKeys = member.getKeyValues();
        Object[] objectArray = key;
        int n = key.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj.equals(memberKeys[0])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isDrilledElement(Member[] currentMember, Member[] drillMember, IEdgeDrillFilter filter) {
        if (drillMember.length < currentMember.length) {
            int i = 0;
            while (i < drillMember.length) {
                if (!drillMember[i].equals(currentMember[i])) {
                    return false;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < currentMember.length) {
                if (!currentMember[i].equals(drillMember[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public void clear() throws IOException {
        this.bufferedStructureArray.clear();
    }

    @Override
    public void close() throws IOException {
        this.bufferedStructureArray.close();
    }

    @Override
    public int getAggregationCount() {
        return 0;
    }

    @Override
    public int getAggregationDataType(int aggregationIndex) throws IOException {
        return 0;
    }

    @Override
    public int[] getAggregationDataType() {
        return null;
    }

    @Override
    public AggregationDefinition getAggregationDefinition() {
        return null;
    }

    @Override
    public int getAggregationIndex(String name) throws IOException {
        return 0;
    }

    @Override
    public String getAggregationName(int index) {
        return null;
    }

    @Override
    public Object getAggregationValue(int aggregationIndex) throws IOException {
        return null;
    }

    @Override
    public DimLevel[] getAllLevels() {
        return this.metaResultSet.getAllLevels();
    }

    @Override
    public String[][] getAttributeNames() {
        return this.metaResultSet.getAttributeNames();
    }

    @Override
    public IAggregationResultRow getCurrentRow() throws IOException {
        return this.resultObject;
    }

    @Override
    public String[][] getKeyNames() {
        return this.metaResultSet.getKeyNames();
    }

    @Override
    public DimLevel getLevel(int levelIndex) {
        return this.metaResultSet.getLevel(levelIndex);
    }

    @Override
    public Object getLevelAttribute(int levelIndex, int attributeIndex) {
        if (this.resultObject.getLevelMembers() == null || levelIndex < 0 || levelIndex > this.resultObject.getLevelMembers().length - 1) {
            return null;
        }
        return this.resultObject.getLevelMembers()[levelIndex].getAttributes()[attributeIndex];
    }

    @Override
    public int getLevelAttributeColCount(int levelIndex) {
        return this.metaResultSet.getLevelAttributeColCount(levelIndex);
    }

    @Override
    public int getLevelAttributeDataType(DimLevel level, String attributeName) {
        int levelIndex = this.getLevelIndex(level);
        if (this.attributeDataTypes == null || this.attributeDataTypes[levelIndex] == null) {
            return -1;
        }
        return this.attributeDataTypes[levelIndex][this.getLevelAttributeIndex(level, attributeName)];
    }

    @Override
    public int getLevelAttributeDataType(int levelIndex, String attributeName) {
        return this.metaResultSet.getLevelAttributeDataType(levelIndex, attributeName);
    }

    @Override
    public int[][] getLevelAttributeDataType() {
        return this.attributeDataTypes;
    }

    @Override
    public int getLevelAttributeIndex(int levelIndex, String attributeName) {
        return this.metaResultSet.getLevelAttributeIndex(levelIndex, attributeName);
    }

    @Override
    public int getLevelAttributeIndex(DimLevel level, String attributeName) {
        return this.metaResultSet.getLevelAttributeIndex(level, attributeName);
    }

    @Override
    public String[] getLevelAttributes(int levelIndex) {
        return this.metaResultSet.getLevelAttributes(levelIndex);
    }

    @Override
    public String[][] getLevelAttributes() {
        return this.metaResultSet.getAttributeNames();
    }

    @Override
    public int getLevelCount() {
        return this.levelCount;
    }

    @Override
    public int getLevelIndex(DimLevel level) {
        return this.metaResultSet.getLevelIndex(level);
    }

    @Override
    public int getLevelKeyColCount(int levelIndex) {
        return this.metaResultSet.getLevelKeyColCount(levelIndex);
    }

    @Override
    public int getLevelKeyDataType(DimLevel level, String keyName) {
        return this.metaResultSet.getLevelKeyDataType(level, keyName);
    }

    @Override
    public int getLevelKeyDataType(int levelIndex, String keyName) {
        return this.metaResultSet.getLevelKeyDataType(levelIndex, keyName);
    }

    @Override
    public int[][] getLevelKeyDataType() {
        return this.metaResultSet.getLevelKeyDataType();
    }

    @Override
    public int getLevelKeyIndex(int levelIndex, String keyName) {
        return this.metaResultSet.getLevelKeyIndex(levelIndex, keyName);
    }

    @Override
    public int getLevelKeyIndex(DimLevel level, String keyName) {
        return this.metaResultSet.getLevelKeyIndex(level, keyName);
    }

    @Override
    public String getLevelKeyName(int levelIndex, int keyIndex) {
        return this.metaResultSet.getLevelKeyName(levelIndex, keyIndex);
    }

    @Override
    public Object[] getLevelKeyValue(int levelIndex) {
        if (this.resultObject.getLevelMembers() == null || levelIndex < 0 || levelIndex > this.resultObject.getLevelMembers().length - 1) {
            return null;
        }
        return this.resultObject.getLevelMembers()[levelIndex].getKeyValues();
    }

    @Override
    public String[][] getLevelKeys() {
        return this.metaResultSet.getLevelKeys();
    }

    @Override
    public int getPosition() {
        return this.currentPosition;
    }

    @Override
    public int getSortType(int levelIndex) {
        return this.metaResultSet.getSortType(levelIndex);
    }

    @Override
    public int[] getSortType() {
        return this.metaResultSet.getSortType();
    }

    @Override
    public int length() {
        return this.bufferedStructureArray.size();
    }

    @Override
    public void seek(int index) throws IOException {
        if (index >= this.bufferedStructureArray.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.bufferedStructureArray.size());
        }
        this.currentPosition = index;
        this.resultObject = (IAggregationResultRow)this.bufferedStructureArray.get(index);
    }

    @Override
    public Object[] getLevelAttributesValue(int levelIndex) {
        return this.metaResultSet.getLevelAttributesValue(levelIndex);
    }
}

