/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.api.cube;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;

public class DocManagerMap {
    private static DocManagerMap instance = new DocManagerMap();
    private Map map = new Hashtable();
    protected static Logger logger = Logger.getLogger(DocManagerMap.class.getName());

    public static DocManagerMap getDocManagerMap() {
        return instance;
    }

    public void set(String dataEngineKey, String key, IDocumentManager manager) {
        Map<String, IDocumentManager> docManagerMap = null;
        if (this.map.containsKey(dataEngineKey)) {
            docManagerMap = (Map)this.map.get(dataEngineKey);
        } else {
            docManagerMap = new HashMap();
            this.map.put(dataEngineKey, docManagerMap);
        }
        docManagerMap.put(key, manager);
    }

    public IDocumentManager get(String dataEngineKey, String key) {
        Map docManagerMap = null;
        if (!this.map.containsKey(dataEngineKey)) {
            return null;
        }
        docManagerMap = (Map)this.map.get(dataEngineKey);
        if (!docManagerMap.containsKey(key)) {
            return null;
        }
        return (IDocumentManager)docManagerMap.get(key);
    }

    public void close(String dataEngineKey) {
        Map docManagerMap = null;
        if (!this.map.containsKey(dataEngineKey)) {
            return;
        }
        docManagerMap = (Map)this.map.get(dataEngineKey);
        Collection docManagers = docManagerMap.values();
        if (docManagers == null || docManagers.size() == 0) {
            return;
        }
        Iterator docManagerIterator = docManagers.iterator();
        while (docManagerIterator.hasNext()) {
            try {
                ((IDocumentManager)docManagerIterator.next()).close();
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.log(Level.WARNING, "IOException is thrown when document manage is closed!");
            }
        }
        docManagerMap.clear();
        this.map.remove(dataEngineKey);
    }
}

