/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.IOException;
import org.eclipse.birt.data.engine.olap.data.util.BaseDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.IStructure;
import org.eclipse.birt.data.engine.olap.data.util.IStructureCreator;
import org.eclipse.birt.data.engine.olap.data.util.ObjectReader;
import org.eclipse.birt.data.engine.olap.data.util.ObjectWriter;

public class StructureDiskArray
extends BaseDiskArray {
    private IStructureCreator creator;
    private ObjectWriter[] fieldWriters;
    private ObjectReader[] fieldReaders;

    public StructureDiskArray(IStructureCreator creator) throws IOException {
        this.creator = creator;
    }

    protected void writeObject(Object object) throws IOException {
        if (object == null) {
            this.randomAccessFile.writeShort(-1);
            return;
        }
        IStructure cachedObject = (IStructure)object;
        Object[] objects = cachedObject.getFieldValues();
        this.randomAccessFile.writeShort((short)objects.length);
        if (this.fieldWriters == null) {
            this.createReadersAndWriters(objects.length);
        }
        int i = 0;
        while (i < objects.length) {
            this.fieldWriters[i].write(this.randomAccessFile, objects[i]);
            ++i;
        }
    }

    private void createReadersAndWriters(int size) {
        this.fieldWriters = new ObjectWriter[size];
        this.fieldReaders = new ObjectReader[size];
        int i = 0;
        while (i < size) {
            this.fieldWriters[i] = new ObjectWriter();
            this.fieldReaders[i] = new ObjectReader();
            ++i;
        }
    }

    protected Object readObject() throws IOException {
        short fieldCount = this.randomAccessFile.readShort();
        if (fieldCount == -1) {
            return null;
        }
        Object[] objects = new Object[fieldCount];
        int i = 0;
        while (i < objects.length) {
            if (this.fieldReaders[i].getDataType() != this.fieldWriters[i].getDataType()) {
                this.fieldReaders[i].setDataType(this.fieldWriters[i].getDataType());
            }
            objects[i] = this.fieldReaders[i].read(this.randomAccessFile);
            ++i;
        }
        return this.creator.createInstance(objects);
    }

    public void clear() throws IOException {
        this.fieldWriters = null;
        this.fieldReaders = null;
        super.clear();
    }
}

