/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import java.util.Map;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryExecutor;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;
import org.mozilla.javascript.Scriptable;

public class DrillQueryHelper {
    private ICubeQueryDefinition query;
    private ICube cube;
    private Scriptable scope;
    private DataEngineContext context;
    private DataEngineSession session;
    private IBaseQueryResults outResults;
    private Map appContext;
    private StopSign stopSign;
    private BirtCubeView[] viewsOnColumnEdge = null;
    private BirtCubeView[] viewsOnRowEdge = null;
    private BirtCubeView[] viewsOnCross = null;
    private BirtCubeView[] allViews = null;

    public DrillQueryHelper(IBaseQueryResults outResults, ICubeQueryDefinition query, ICube cube, DataEngineSession session, Scriptable scope, DataEngineContext context, Map appContext, StopSign stopSign) {
        this.query = query;
        this.cube = cube;
        this.scope = scope;
        this.context = context;
        this.session = session;
        this.outResults = outResults;
        this.appContext = appContext;
        this.stopSign = stopSign;
    }

    public BirtCubeView[] getCubeViewOnColumnEdge() throws DataException {
        if (this.viewsOnColumnEdge != null) {
            return this.viewsOnColumnEdge;
        }
        ICubeQueryDefinition[] drillEdgeQuerys = CubeQueryDefinitionUtil.getCubeQueryFromDrills(this.query, this.cube, 2);
        this.viewsOnColumnEdge = new BirtCubeView[drillEdgeQuerys.length];
        if (drillEdgeQuerys.length > 0) {
            int i = 0;
            while (i < drillEdgeQuerys.length) {
                CubeQueryExecutor executor = new CubeQueryExecutor(this.outResults, drillEdgeQuerys[i], this.session, this.scope, this.context);
                this.viewsOnColumnEdge[i] = new BirtCubeView(executor, this.appContext);
                this.viewsOnColumnEdge[i].getCubeCursor(this.stopSign, this.cube, false);
                ++i;
            }
        }
        return this.viewsOnColumnEdge;
    }

    public BirtCubeView[] getCubeViewOnRowEdge() throws DataException {
        if (this.viewsOnRowEdge != null) {
            return this.viewsOnRowEdge;
        }
        ICubeQueryDefinition[] drillEdgeQuerys = CubeQueryDefinitionUtil.getCubeQueryFromDrills(this.query, this.cube, 1);
        this.viewsOnRowEdge = new BirtCubeView[drillEdgeQuerys.length];
        if (drillEdgeQuerys.length > 0) {
            int i = 0;
            while (i < drillEdgeQuerys.length) {
                CubeQueryExecutor executor = new CubeQueryExecutor(this.outResults, drillEdgeQuerys[i], this.session, this.scope, this.context);
                this.viewsOnRowEdge[i] = new BirtCubeView(executor, this.appContext);
                this.viewsOnRowEdge[i].getCubeCursor(this.stopSign, this.cube, false);
                ++i;
            }
        }
        return this.viewsOnRowEdge;
    }

    public BirtCubeView[] getCubeViewOnCrossEdge() throws DataException {
        if (this.viewsOnCross != null) {
            return this.viewsOnCross;
        }
        ICubeQueryDefinition[] drillEdgeQuerys = CubeQueryDefinitionUtil.getCrossCubeQueryFromDrills(this.query, this.cube);
        this.viewsOnCross = new BirtCubeView[drillEdgeQuerys.length];
        if (drillEdgeQuerys.length > 0) {
            int i = 0;
            while (i < drillEdgeQuerys.length) {
                CubeQueryExecutor executor = new CubeQueryExecutor(this.outResults, drillEdgeQuerys[i], this.session, this.scope, this.context);
                this.viewsOnCross[i] = new BirtCubeView(executor, this.appContext);
                this.viewsOnCross[i].getCubeCursor(this.stopSign, this.cube, false);
                ++i;
            }
        }
        return this.viewsOnCross;
    }

    public BirtCubeView[] getAllCubeViews() throws DataException {
        BirtCubeView view;
        if (this.allViews != null) {
            return this.allViews;
        }
        BirtCubeView[] views1 = this.getCubeViewOnColumnEdge();
        BirtCubeView[] views2 = this.getCubeViewOnRowEdge();
        BirtCubeView[] views3 = this.getCubeViewOnCrossEdge();
        this.allViews = new BirtCubeView[views1.length + views2.length + views3.length];
        int count = 0;
        BirtCubeView[] birtCubeViewArray = views1;
        int n = views1.length;
        int n2 = 0;
        while (n2 < n) {
            this.allViews[count] = view = birtCubeViewArray[n2];
            ++count;
            ++n2;
        }
        birtCubeViewArray = views2;
        n = views2.length;
        n2 = 0;
        while (n2 < n) {
            this.allViews[count] = view = birtCubeViewArray[n2];
            ++count;
            ++n2;
        }
        birtCubeViewArray = views3;
        n = views3.length;
        n2 = 0;
        while (n2 < n) {
            this.allViews[count] = view = birtCubeViewArray[n2];
            ++count;
            ++n2;
        }
        return this.allViews;
    }
}

