/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.SummaryAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;

public class TotalMax
extends AggrFunction {
    public String getName() {
        return "MAX";
    }

    public int getType() {
        return 0;
    }

    public int getDataType() {
        return 0;
    }

    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, "")};
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    public String getDescription() {
        return Messages.getString("TotalMax.description");
    }

    public String getDisplayName() {
        return Messages.getString("TotalMax.displayName");
    }

    private class MyAccumulator
    extends SummaryAccumulator {
        private Object max = null;
        private boolean isRowAvailable = false;

        private MyAccumulator() {
        }

        public void start() {
            super.start();
            this.max = null;
            this.isRowAvailable = false;
        }

        public void onRow(Object[] args) {
            assert (args.length > 0);
            if (args[0] != null) {
                if (!this.isRowAvailable) {
                    this.isRowAvailable = true;
                    this.max = args[0];
                    return;
                }
                if (this.isGreaterThan(args[0], this.max)) {
                    this.max = args[0];
                }
            }
        }

        public Object getSummaryValue() {
            return this.max;
        }

        private boolean isGreaterThan(Object origin, Object target) {
            if (origin instanceof Comparable && target instanceof Comparable) {
                return ((Comparable)origin).compareTo(target) > 0;
            }
            throw new RuntimeException(Messages.getString("TotalMax.exception.cannot_get_max_value"));
        }
    }
}

