/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.visualisation.notes;

import fr.inra.adonis.modeleMetier.conceptsDeBase.Note;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.Bloc;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.Individu;
import fr.inra.adonis.modeleMetier.plateforme.ParcelleUnitaire;
import fr.inra.adonis.modeleMetier.plateforme.Plateforme;
import fr.inra.adonis.modeleMetier.plateforme.SousBloc;
import fr.inra.adonis.modeleMetier.plateforme.TypeUniteParcours;
import fr.inra.adonis.visualisation.notes.WrapperNotes;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class NotesUtil {
    public static List<WrapperNotes> getInputForTabulaireMode(Set<ObjetMetier> set, List<ObjetMetier> lobjs, TypeUniteParcours filtre) {
        ArrayList<WrapperNotes> result = new ArrayList<WrapperNotes>();
        for (ObjetMetier objetCourant : set) {
            if (!NotesUtil.isToDisplay(objetCourant, lobjs, filtre)) continue;
            WrapperNotes wrapper = new WrapperNotes();
            result.add(wrapper);
            wrapper.setObjetMetier(objetCourant);
            for (Note note : objetCourant.getNotes()) {
                if (note.isSupprime()) continue;
                wrapper.getNotes().add(note);
            }
        }
        return result;
    }

    private static boolean isToDisplay(ObjetMetier obj, List<ObjetMetier> lobjs, TypeUniteParcours filtre) {
        if (lobjs != null && !lobjs.contains(obj)) {
            return false;
        }
        return filtre == null || !(filtre != TypeUniteParcours.INDIVIDU && obj instanceof Individu || filtre != TypeUniteParcours.PARCELLE && obj instanceof ParcelleUnitaire || filtre != TypeUniteParcours.SOUS_BLOC && obj instanceof SousBloc || filtre != TypeUniteParcours.BLOC && obj instanceof Bloc || filtre != TypeUniteParcours.DISPOSITIF && obj instanceof Dispositif) && (filtre == TypeUniteParcours.PLATEFORME || !(obj instanceof Plateforme));
    }

    private NotesUtil() {
    }
}

