/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.algorithmeplugin.splitplot;

import fr.inra.adonis.algorithmeplugin.splitplot.AlgoDialog2F;
import fr.inra.adonis.algorithmeplugin.splitplot.AlgoDialog3F;
import fr.inra.adonis.algorithmeplugin.splitplot.SplitPlotActivator;
import fr.inra.adonis.core.util.SystemUtils;
import fr.inra.adonis.gestionalgorithme.AlgorithmePluginManager;
import fr.inra.adonis.modeleMetier.plateforme.AbstractBloc;
import fr.inra.adonis.modeleMetier.plateforme.Bloc;
import fr.inra.adonis.modeleMetier.plateforme.ParcelleUnitaire;
import fr.inra.adonis.modeleMetier.plateforme.PlateformeFactory;
import fr.inra.adonis.modeleMetier.plateforme.PuIndividuel;
import fr.inra.adonis.modeleMetier.plateforme.SousBloc;
import fr.inra.adonis.modeleMetier.plateforme.TypeSpatialisation;
import fr.inra.adonis.modeleMetier.protocole.Algorithme;
import fr.inra.adonis.modeleMetier.protocole.Facteur;
import fr.inra.adonis.modeleMetier.protocole.Modalite;
import fr.inra.adonis.modeleMetier.protocole.Protocole;
import fr.inra.adonis.modeleMetier.protocole.Traitement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AlgorithmePlugin
extends Algorithme {
    public static final String NOM = "Split Plot";
    protected int B = -1;
    protected List<Facteur> facteurs = new ArrayList<Facteur>();
    protected List<Integer> nbsModalites = new ArrayList<Integer>();
    private int nbIndsParPu;
    private int nbIndsParLigne;
    private int nbBlocsParLigne;
    private int nbSousBlocsParLigne;
    private int nbPusParLigne;

    public AlgorithmePlugin() {
        this.nom = NOM;
        this.description = "Algorithme de tirage al\u00e9atoire utilisant la methode Split Plot.\nCe tirage n'est valable que : \n - si le nombre de r\u00e9p\u00e9titions des traitements est constant.\n - si le protocole n'a que deux ou trois facteurs.\n - si le nombre de traitement est egal a la multiplication des nombres de modalites de tous les facteurs.";
        this.spatialisable = false;
    }

    public boolean estCoherent(Protocole protocole) {
        if (protocole == null) {
            return false;
        }
        int m = 1;
        for (Facteur f : protocole.getFacteurs()) {
            m *= f.getModalites().size();
        }
        int r = 0;
        for (Traitement t : protocole.getTraitements()) {
            if (r == 0) {
                r = t.getNbRepetitions();
            }
            if (r == t.getNbRepetitions()) continue;
            return false;
        }
        return r > 0 && (protocole.getFacteurs().size() == 2 || protocole.getFacteurs().size() == 3) && protocole.getTraitements().size() == m;
    }

    public File creationMatriceMFT(Protocole protocole, File dir) {
        try {
            String info = "\"m1\";\"m2\";\"m3\";\"Trt\";\"ind\"\n";
            ArrayList<Modalite> combi = new ArrayList<Modalite>();
            int nm1 = 1;
            for (Modalite m1 : this.facteurs.get(0).getModalites()) {
                int nm2 = 1;
                for (Modalite m2 : this.facteurs.get(1).getModalites()) {
                    if (this.facteurs.size() == 3) {
                        int nm3 = 1;
                        for (Modalite m3 : this.facteurs.get(2).getModalites()) {
                            combi.add(m1);
                            combi.add(m2);
                            combi.add(m3);
                            int nTraitement = 1;
                            for (Traitement t : protocole.getTraitements()) {
                                if (t.getCombinaisons().containsAll(combi)) {
                                    info = String.valueOf(info) + nm1 + ";" + nm2 + ";" + nm3 + ";" + t.getNomCourt() + ";" + nTraitement + "\n";
                                }
                                ++nTraitement;
                            }
                            ++nm3;
                            nTraitement = 0;
                            combi.clear();
                        }
                    } else {
                        combi.add(m1);
                        combi.add(m2);
                        int nTraitement = 1;
                        for (Traitement t : protocole.getTraitements()) {
                            if (t.getCombinaisons().containsAll(combi)) {
                                info = String.valueOf(info) + nm1 + ";" + nm2 + ";0;" + t.getNomCourt() + ";" + nTraitement + "\n";
                            }
                            ++nTraitement;
                        }
                        nTraitement = 0;
                        combi.clear();
                    }
                    ++nm2;
                }
                ++nm1;
            }
            File dat = new File(dir, "matMFT.dat");
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(dat));
            PrintWriter pw = new PrintWriter(out);
            pw.write(info);
            pw.flush();
            pw.close();
            return dat;
        }
        catch (FileNotFoundException e) {
            System.out.println("error " + e);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EList<Bloc> tirageAleatoire(Protocole protocole, boolean surfacique, TypeSpatialisation spatialisation) {
        block31: {
            block30: {
                shell = Display.getCurrent().getActiveShell();
                result = new BasicEList();
                try {
                    block29: {
                        if (protocole == null || !this.estCoherent(protocole)) {
                            MessageDialog.openError((Shell)shell, (String)"Erreur d'execution", (String)"Protocole non coh\u00e9rent");
                            return null;
                        }
                        this.B = 0;
                        nbTraitement = protocole.getTraitements().size();
                        var8_8 = protocole.getTraitements().iterator();
                        while (true) {
                            if (!var8_8.hasNext()) {
                                if (protocole.getFacteurs().size() != 2) break;
                                dialog = new AlgoDialog2F(shell, (List<Facteur>)protocole.getFacteurs(), this.B, surfacique, spatialisation, nbTraitement);
                                if (dialog.open() != 0) {
                                    return null;
                                }
                                this.facteurs = dialog.getFacteursOrdonnes();
                                this.nbsModalites = dialog.getListNbModalites();
                                this.nbIndsParPu = dialog.getNbIndsParPu();
                                this.nbIndsParLigne = dialog.getNbIndsParLigne();
                                this.nbBlocsParLigne = dialog.getNbBlocsParLigne();
                                this.nbSousBlocsParLigne = dialog.getNbSousBlocsParLigne();
                                this.nbPusParLigne = dialog.getNbPusParLigne();
                                break block29;
                            }
                            t = (Traitement)var8_8.next();
                            if (this.B != 0) continue;
                            this.B = t.getNbRepetitions();
                        }
                        if (protocole.getFacteurs().size() != 3) {
                            return null;
                        }
                        dialog = new AlgoDialog3F(shell, (List<Facteur>)protocole.getFacteurs(), this.B, surfacique, spatialisation, nbTraitement);
                        if (dialog.open() != 0) {
                            return null;
                        }
                        this.facteurs = dialog.getFacteursOrdonnes();
                        this.nbsModalites = dialog.getListNbModalites();
                        this.nbIndsParPu = dialog.getNbIndsParPu();
                        this.nbIndsParLigne = dialog.getNbIndsParLigne();
                        this.nbBlocsParLigne = dialog.getNbBlocsParLigne();
                        this.nbSousBlocsParLigne = dialog.getNbSousBlocsParLigne();
                        this.nbPusParLigne = dialog.getNbPusParLigne();
                    }
                    exe = new File(AlgorithmePluginManager.getInstance().getPluginDirectory().getAbsolutePath(), "execution");
                    if (!exe.exists()) {
                        exe.mkdir();
                    } else if (!exe.isDirectory()) {
                        exe.delete();
                        exe.mkdir();
                    }
                    dat = this.creationMatriceMFT(protocole, exe);
                    dst = new File(exe, "algoSplitPlot.R");
                    if (dst.exists()) {
                        dst.delete();
                    }
                    dst.createNewFile();
                    inr = this.getClass().getResourceAsStream("algoSplitPlot.R");
                    outr = new FileOutputStream(dst);
                    bufr = new byte[1024];
                    while (true) {
                        block32: {
                            if ((lenr = inr.read(bufr)) > 0) break block32;
                            inr.close();
                            outr.close();
                            srt = new File(exe, "algoSplitPlot.out_" + Calendar.getInstance().getTimeInMillis());
                            srt.createNewFile();
                            aff = new File(".", "affichage_dispositif.R");
                            if (aff.exists()) break block30;
                            aff.createNewFile();
                            in = this.getClass().getResourceAsStream("affichage_dispositif.R");
                            out = new FileOutputStream(aff);
                            buf = new byte[1024];
                            if (true) ** GOTO lbl86
                        }
                        outr.write(bufr, 0, lenr);
                    }
                }
                catch (Exception e) {
                    SplitPlotActivator.getLogger().logError((Throwable)e);
                    AlgorithmePluginManager.getInstance().log("Exception Split Plot = " + e.getMessage());
                    MessageDialog.openError((Shell)shell, (String)"Erreur d'execution", (String)e.getMessage());
                    break block31;
                }
                do {
                    out.write((byte[])buf, 0, len);
lbl86:
                    // 2 sources

                } while ((len = in.read((byte[])buf)) > 0);
                in.close();
                out.close();
            }
            params = "";
            for (Integer nbM : this.nbsModalites) {
                params = String.valueOf(params) + nbM;
                params = String.valueOf(params) + ",";
            }
            params = params.substring(0, params.length() - 1);
            params = String.valueOf(params) + " ";
            params = String.valueOf(params) + this.B;
            dstpath = dst.getAbsolutePath();
            srtpath = srt.getAbsolutePath();
            datpath = dat.getAbsolutePath();
            exepath = exe.getAbsolutePath();
            if (!exepath.endsWith(File.separator) || !exepath.endsWith(String.valueOf(File.separator) + "'")) {
                exepath = String.valueOf(exepath) + File.separator;
            }
            if (SystemUtils.is_OS_WINDOWS) {
                dstpath = "\"" + dstpath + "\"";
                srtpath = "\"" + srtpath + "\"";
                datpath = "\"" + datpath + "\"";
            }
            commande = "Rscript " + dstpath + " " + params + " " + datpath + " " + srtpath + " " + exepath;
            output = SystemUtils.execute((String)commande, (Shell)shell);
            aff.delete();
            if (output == null) {
                AlgorithmePluginManager.getInstance().log("Exception Split Plot = commande appel\u00e9e = " + commande);
                MessageDialog.openError((Shell)shell, (String)"Erreur d'execution", (String)("Commande R incorrecte : " + commande));
                return null;
            }
            isres = new FileInputStream(srt);
            brres = new BufferedReader(new InputStreamReader(isres));
            ligne = brres.readLine();
            if (ligne != null) ** GOTO lbl181
            AlgorithmePluginManager.getInstance().log("Exception Split Plot = fichier de sortie vide \n commande appel\u00e9e = " + commande + " \n sortie : " + output);
            MessageDialog.openError((Shell)shell, (String)"Erreur d'execution", (String)("Commande R : " + commande + " \n sortie : " + output));
            return null;
lbl-1000:
            // 1 sources

            {
                items = ligne.split(";");
                if (items.length <= 7) continue;
                nbloc = Integer.parseInt(items[0]);
                nsousbloc = Integer.parseInt(items[1]);
                npu = Integer.parseInt(items[2]);
                ntraitement = Integer.parseInt(items[3]);
                m1 = Integer.parseInt(items[4]);
                m2 = Integer.parseInt(items[5]);
                m3 = Integer.parseInt(items[6]);
                bloc = null;
                sousbloc = null;
                pu = null;
                for (Bloc currentBloc : result) {
                    if (currentBloc.getNumero() != nbloc) continue;
                    bloc = currentBloc;
                }
                if (bloc == null) {
                    bloc = PlateformeFactory.eINSTANCE.createBloc();
                    bloc.setNumero(nbloc);
                    bloc.setCreationManuelle(false);
                    result.add((Object)bloc);
                }
                abloc = bloc;
                for (SousBloc currentSousbloc : bloc.getSousBlocs()) {
                    if (currentSousbloc.getNumero() != nsousbloc) continue;
                    sousbloc = currentSousbloc;
                    abloc = sousbloc;
                }
                if (sousbloc == null && nsousbloc != 0) {
                    sousbloc = PlateformeFactory.eINSTANCE.createSousBloc();
                    sousbloc.setNumero(nsousbloc);
                    sousbloc.setCreationManuelle(false);
                    sousbloc.setBloc(bloc);
                    abloc = sousbloc;
                }
                for (ParcelleUnitaire currentPu : abloc.getParcellesUnitaire()) {
                    if (currentPu.getNumero() != npu || !(currentPu instanceof PuIndividuel)) continue;
                    pu = (PuIndividuel)currentPu;
                }
                if (pu != null) continue;
                pu = PlateformeFactory.eINSTANCE.createPuIndividuel();
                pu.setNumero(npu);
                pu.setCreationManuelle(false);
                t = (Traitement)protocole.getTraitements().get(ntraitement - 1);
                pu.setTraitement(t);
                pu.getTraitement().getCombinaisons().clear();
                if (m1 != 0 || m2 != 0 || m3 != 0) {
                    if (protocole.getFacteurs().size() > 0 && m1 != 0 && this.facteurs.get(0).getModalites().size() >= m1) {
                        pu.getTraitement().getCombinaisons().add((Object)((Modalite)this.facteurs.get(0).getModalites().get(m1 - 1)));
                    }
                    if (protocole.getFacteurs().size() > 1 && m2 != 0 && this.facteurs.get(1).getModalites().size() >= m2) {
                        pu.getTraitement().getCombinaisons().add((Object)((Modalite)this.facteurs.get(1).getModalites().get(m2 - 1)));
                    }
                    if (protocole.getFacteurs().size() > 2 && m3 != 0 && this.facteurs.get(2).getModalites().size() >= m3) {
                        pu.getTraitement().getCombinaisons().add((Object)((Modalite)this.facteurs.get(2).getModalites().get(m3 - 1)));
                    }
                }
                pu.setNbIndividus(this.nbIndsParPu);
                pu.setNbIndividusParLigne(this.nbIndsParLigne);
                pu.setAbstractBloc((AbstractBloc)abloc);
lbl181:
                // 4 sources

                ** while ((ligne = brres.readLine()) != null)
            }
lbl182:
            // 1 sources

            if (spatialisation == TypeSpatialisation.BUREAU) {
                AlgorithmePluginManager.getInstance().positionnement((List)result, this.nbBlocsParLigne, this.nbSousBlocsParLigne, this.nbPusParLigne, this.nbIndsParLigne);
            }
            brres.close();
            isres.close();
        }
        this.B = -1;
        this.facteurs.clear();
        return result;
    }
}

