/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetViewData;
import org.eclipse.birt.report.designer.data.ui.util.SelectValueFetcher;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ResourceEditDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionEditor;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionConverter;
import org.eclipse.birt.report.designer.internal.ui.extension.IUseCubeQueryList;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseTitleAreaDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.SelectValueDialog;
import org.eclipse.birt.report.designer.ui.expressions.ExpressionFilter;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.MapHandleProvider;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.MapRuleHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class MapRuleBuilder
extends BaseTitleAreaDialog {
    public static final String DLG_TITLE_NEW = Messages.getString((String)"MapRuleBuilder.DialogTitle.New");
    public static final String DLG_TITLE_EDIT = Messages.getString((String)"MapRuleBuilder.DialogTitle.Edit");
    protected static final Logger logger = Logger.getLogger(MapRuleBuilder.class.getName());
    protected static final String[] EMPTY_ARRAY = new String[0];
    private static final String NULL_STRING = null;
    protected ExpressionProvider expressionProvider;
    protected String bindingName = null;
    protected ReportElementHandle currentItem = null;
    protected List<Control> compositeList = new ArrayList<Control>();
    protected List<Expression> valueList = new ArrayList<Expression>();
    private MapRuleHandle handle;
    private MapHandleProvider provider;
    private int handleCount;
    protected Combo expression;
    protected Combo operator;
    private Text display;
    protected Composite valueListComposite;
    protected Combo addExpressionValue;
    protected Button addBtn;
    protected Button editBtn;
    protected Button delBtn;
    protected Button delAllBtn;
    protected Table table;
    protected TableViewer tableViewer;
    protected int valueVisible;
    private Combo expressionValue1;
    private Combo expressionValue2;
    private Label andLable;
    protected Composite dummy1;
    protected Composite dummy2;
    private Text resourceKeytext;
    private Button btnBrowse;
    private Button btnReset;
    protected DesignElementHandle designHandle;
    protected static final String VALUE_OF_THIS_DATA_ITEM = Messages.getString((String)"HighlightRuleBuilderDialog.choice.ValueOfThisDataItem");
    private static final String CHOICE_SELECT_VALUE = Messages.getString((String)"ExpressionValueCellEditor.selectValueAction");
    private ParamBindingHandle[] bindingParams = null;
    protected List<ComputedColumnHandle> columnList;
    private static final String[][] OPERATOR;
    protected SelectionListener expSelListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            IExpressionConverter converter = ExpressionButtonUtil.getCurrentExpressionConverter((Control)MapRuleBuilder.this.expression);
            if (converter != null) {
                String newValue = MapRuleBuilder.this.expression.getText();
                String value = null;
                value = MapRuleBuilder.this.expression.getText().equals(VALUE_OF_THIS_DATA_ITEM) && MapRuleBuilder.this.designHandle instanceof DataItemHandle ? (MapRuleBuilder.this.designHandle.getContainer() instanceof ExtendedItemHandle ? ExpressionUtility.getDataExpression(((DataItemHandle)MapRuleBuilder.this.designHandle).getResultSetColumn(), converter) : ExpressionUtility.getColumnExpression(((DataItemHandle)MapRuleBuilder.this.designHandle).getResultSetColumn(), converter)) : ExpressionUtility.getExpression(MapRuleBuilder.this.getResultSetColumn(newValue), converter);
                if (value != null) {
                    newValue = value;
                }
                MapRuleBuilder.this.expression.setText(newValue);
            }
            MapRuleBuilder.this.updateButtons();
        }
    };
    protected ITableLabelProvider tableLableProvier = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof Expression) {
                    return ((Expression)element).getStringExpression();
                }
                return element.toString();
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    protected IStructuredContentProvider tableContentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }
    };
    private Composite condition;

    static {
        IChoiceSet chset = ChoiceSetFactory.getStructChoiceSet("MapRule", "operator");
        IChoice[] chs = chset.getChoices((Comparator)new AlphabeticallyComparator());
        OPERATOR = new String[chs.length][2];
        int i = 0;
        while (i < chs.length) {
            MapRuleBuilder.OPERATOR[i][0] = chs[i].getDisplayName();
            MapRuleBuilder.OPERATOR[i][1] = chs[i].getName();
            ++i;
        }
    }

    public static String getValueForOperator(String name) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][0].equals(name)) {
                return OPERATOR[i][1];
            }
            ++i;
        }
        return null;
    }

    public static int determineValueVisible(String operatorValue) {
        if ("any".equals(operatorValue) || "is-false".equals(operatorValue) || "is-true".equals(operatorValue) || "is-null".equals(operatorValue) || "is-not-null".equals(operatorValue)) {
            return 0;
        }
        if ("lt".equals(operatorValue) || "le".equals(operatorValue) || "eq".equals(operatorValue) || "ne".equals(operatorValue) || "ge".equals(operatorValue) || "gt".equals(operatorValue) || "like".equals(operatorValue)) {
            return 1;
        }
        if ("between".equals(operatorValue) || "not-between".equals(operatorValue)) {
            return 2;
        }
        if ("in".equals(operatorValue) || "not-in".equals(operatorValue)) {
            return 3;
        }
        return 1;
    }

    public static String getNameForOperator(String value) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][1].equals(value)) {
                return OPERATOR[i][0];
            }
            ++i;
        }
        return "";
    }

    static int getIndexForOperatorValue(String value) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][1].equals(value)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public MapRuleBuilder(Shell parentShell, String title, MapHandleProvider provider) {
        super(parentShell);
        this.title = title;
        this.provider = provider;
    }

    private String[] getDataSetColumns() {
        if (this.columnList.isEmpty()) {
            return EMPTY_ARRAY;
        }
        String[] values = new String[this.columnList.size()];
        int i = 0;
        while (i < this.columnList.size()) {
            values[i] = this.columnList.get(i).getName();
            ++i;
        }
        return values;
    }

    protected Object getResultSetColumn(String name) {
        if (this.columnList.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < this.columnList.size()) {
            ComputedColumnHandle column = this.columnList.get(i);
            if (column.getName().equals(name)) {
                return column;
            }
            ++i;
        }
        return null;
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        this.setTitle(Messages.getString((String)"MapRuleBuilderDialog.text.Title"));
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.AddEditMapRule_ID");
        if (this.handle != null) {
            this.syncViewProperties();
        }
        this.updateButtons();
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(composite, 0);
        contents.setLayout((Layout)new GridLayout());
        contents.setLayoutData((Object)new GridData(1808));
        Label lb = new Label(contents, 0);
        lb.setText(Messages.getString((String)"MapRuleBuilderDialog.text.Condition"));
        this.condition = new Composite(contents, 0);
        GridData gdata = new GridData(768);
        this.condition.setLayoutData((Object)gdata);
        GridLayout glayout = GridLayoutFactory.createFrom((GridLayout)new GridLayout()).numColumns(5).equalWidth(false).create();
        this.condition.setLayout((Layout)glayout);
        this.expression = new Combo(this.condition, 0);
        gdata = new GridData();
        gdata.widthHint = 120;
        this.expression.setLayoutData((Object)gdata);
        this.expression.setVisibleItemCount(30);
        this.expression.setItems(this.getDataSetColumns());
        this.fillExpression(this.expression);
        this.expression.addSelectionListener(this.expSelListener);
        this.expression.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MapRuleBuilder.this.updateButtons();
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                MapRuleBuilder.this.updateButtons();
            }
        };
        ExpressionButtonUtil.createExpressionButton(this.condition, (Control)this.expression, (IExpressionProvider)this.getExpressionProvider(), (Object)this.designHandle, listener);
        this.operator = new Combo(this.condition, 8);
        this.operator.setVisibleItemCount(30);
        int i = 0;
        while (i < OPERATOR.length) {
            this.operator.add(OPERATOR[i][0]);
            ++i;
        }
        this.create2ValueComposite(this.condition);
        this.operator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapRuleBuilder.this.operatorChange();
            }
        });
        lb = new Label(contents, 0);
        lb.setText(Messages.getString((String)"MapRuleBuilderDialog.text.Display"));
        Composite format = new Composite(contents, 0);
        format.setLayoutData((Object)new GridData(768));
        glayout = new GridLayout();
        format.setLayout((Layout)glayout);
        this.display = new Text(format, 2048);
        gdata = new GridData();
        gdata.widthHint = 300;
        this.display.setLayoutData((Object)gdata);
        this.createResourceKeyArea(contents);
        lb = new Label(contents, 258);
        lb.setLayoutData((Object)new GridData(768));
        return composite;
    }

    protected ExpressionProvider getExpressionProvider() {
        if (this.expressionProvider == null) {
            this.expressionProvider = new ExpressionProvider(this.designHandle);
            this.expressionProvider.addFilter(new ExpressionFilter(){

                public boolean select(Object parentElement, Object element) {
                    return !"Category".equals(parentElement) || !ExpressionProvider.CURRENT_CUBE.equals(element);
                }
            });
        }
        return this.expressionProvider;
    }

    private int create2ValueComposite(Composite condition) {
        if (this.expressionValue1 != null && !this.expressionValue1.isDisposed()) {
            return 0;
        }
        if (this.valueListComposite != null && !this.valueListComposite.isDisposed()) {
            this.valueListComposite.dispose();
            this.valueListComposite = null;
        }
        GridData expgd = new GridData(768);
        expgd.widthHint = 120;
        this.expressionValue1 = this.createExpressionValue(condition);
        this.expressionValue1.add(CHOICE_SELECT_VALUE);
        this.expressionValue1.setLayoutData((Object)expgd);
        this.dummy1 = this.createDummy(condition, 3);
        this.andLable = new Label(condition, 0);
        this.andLable.setText(Messages.getString((String)"MapRuleBuilder.text.AND"));
        this.andLable.setEnabled(false);
        this.dummy2 = this.createDummy(condition, 3);
        this.expressionValue2 = this.createExpressionValue(condition);
        this.expressionValue2.add(CHOICE_SELECT_VALUE);
        this.expressionValue2.setLayoutData((Object)expgd);
        if (this.operator.getItemCount() > 0 && this.operator.getSelectionIndex() == -1) {
            this.operator.setText(MapRuleBuilder.getNameForOperator("eq"));
            this.operatorChange();
        }
        condition.getParent().layout(true, true);
        if (this.getButtonBar() != null) {
            this.layout();
        }
        return 1;
    }

    private void layout() {
        GridData gd = (GridData)this.condition.getLayoutData();
        Point size = this.condition.computeSize(-1, -1);
        if (gd.widthHint < size.x) {
            gd.widthHint = size.x;
        }
        if (gd.heightHint < size.y) {
            gd.heightHint = size.y;
        }
        this.condition.setLayoutData((Object)gd);
        this.condition.getShell().layout();
        if (this.getButtonBar() != null) {
            this.condition.getShell().pack();
        }
    }

    private Combo createExpressionValue(Composite parent) {
        final Combo expressionValue = new Combo(parent, 2048);
        expressionValue.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String selection = e.text;
                if (expressionValue.indexOf(selection) == -1) {
                    e.doit = true;
                    return;
                }
                e.doit = !selection.equals(CHOICE_SELECT_VALUE);
            }
        });
        expressionValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String value;
                if (expressionValue.getSelectionIndex() == -1) {
                    return;
                }
                String selection = expressionValue.getItem(expressionValue.getSelectionIndex());
                if (selection.equals(CHOICE_SELECT_VALUE) && (value = MapRuleBuilder.this.getSelectionValue(expressionValue)) != null) {
                    expressionValue.setText(value);
                }
            }
        });
        expressionValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MapRuleBuilder.this.updateButtons();
            }
        });
        this.createComplexExpressionButton(parent, expressionValue);
        return expressionValue;
    }

    private Combo createMultiExpressionValue(Composite parent) {
        final Combo expressionValue = new Combo(parent, 2048);
        expressionValue.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String selection = e.text;
                if (expressionValue.indexOf(selection) == -1) {
                    e.doit = true;
                    return;
                }
                e.doit = !selection.equals(CHOICE_SELECT_VALUE);
            }
        });
        expressionValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (expressionValue.getSelectionIndex() == -1) {
                    return;
                }
                String selection = expressionValue.getItem(expressionValue.getSelectionIndex());
                if (selection.equals(CHOICE_SELECT_VALUE)) {
                    MapRuleBuilder.this.selectMultiValues(expressionValue);
                }
            }
        });
        expressionValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MapRuleBuilder.this.updateButtons();
            }
        });
        this.createComplexExpressionButton(parent, expressionValue);
        return expressionValue;
    }

    private void createComplexExpressionButton(Composite parent, Combo combo) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                MapRuleBuilder.this.updateButtons();
            }
        };
        ExpressionButtonUtil.createExpressionButton(parent, (Control)combo, (IExpressionProvider)this.getExpressionProvider(), (Object)this.handle, listener);
    }

    protected String getColumnName(Object obj) {
        if (obj instanceof DataSetViewData) {
            return ((DataSetViewData)obj).getName();
        }
        if (obj instanceof ComputedColumnHandle) {
            return ((ComputedColumnHandle)obj).getName();
        }
        if (obj instanceof ResultSetColumnHandle) {
            return ((ResultSetColumnHandle)obj).getColumnName();
        }
        return "";
    }

    protected String getSelectionValue(Combo combo) {
        String retValue = null;
        this.bindingName = this.getExpressionBindingName();
        if (this.bindingName == null && this.expression.getText().trim().length() > 0) {
            this.bindingName = this.expression.getText().trim();
        }
        if (this.bindingName != null) {
            try {
                List selectValueList = this.getSelectValueList();
                SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ExpressionValueCellEditor.title"));
                dialog.setSelectedValueList(selectValueList);
                if (this.bindingParams != null) {
                    dialog.setBindingParams(this.bindingParams);
                }
                if (dialog.open() == 0) {
                    IExpressionConverter converter = ExpressionButtonUtil.getCurrentExpressionConverter((Control)combo);
                    retValue = dialog.getSelectedExprValue(converter);
                }
            }
            catch (Exception ex) {
                MessageDialog.openError(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)(String.valueOf(Messages.getString((String)"SelectValueDialog.messages.error.selectVauleUnavailable")) + "\n" + ex.getMessage()));
            }
        } else {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)Messages.getString((String)"SelectValueDialog.messages.info.selectVauleUnavailable"));
        }
        return retValue;
    }

    private String getExpressionBindingName() {
        Iterator<ComputedColumnHandle> iter = this.columnList.iterator();
        while (iter.hasNext()) {
            String columnName = this.getColumnName(iter.next());
            if (this.designHandle instanceof DataItemHandle) {
                if (!(this.designHandle.getContainer() instanceof ExtendedItemHandle ? ExpressionUtility.getDataExpression(columnName, ExpressionUtility.getExpressionConverter(ExpressionButtonUtil.getExpression((Control)this.expression).getType())).equals(this.expression.getText()) : ExpressionUtility.getColumnExpression(columnName, ExpressionUtility.getExpressionConverter(ExpressionButtonUtil.getExpression((Control)this.expression).getType())).equals(this.expression.getText()))) continue;
                return columnName;
            }
            Expression expr = ExpressionButtonUtil.getExpression((Control)this.expression);
            if (expr == null) continue;
            String exprType = expr.getType();
            IExpressionConverter converter = ExpressionUtility.getExpressionConverter(exprType);
            if (!this.expression.getText().equals(ExpressionUtility.getColumnExpression(columnName, converter))) continue;
            return columnName;
        }
        return null;
    }

    protected void delTableValue() {
        int index = this.table.getSelectionIndex();
        if (index > -1) {
            this.valueList.remove(index);
            this.tableViewer.refresh();
            if (this.valueList.size() > 0) {
                if (this.valueList.size() <= index) {
                    --index;
                }
                this.table.select(index);
            }
            this.updateButtons();
        } else {
            this.delBtn.setEnabled(false);
        }
    }

    protected void editTableValue() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection.getFirstElement() != null && selection.getFirstElement() instanceof Expression) {
            Expression initValue = (Expression)selection.getFirstElement();
            ExpressionEditor editor = new ExpressionEditor(Messages.getString((String)"ExpressionEditor.Title"));
            editor.setExpression(initValue);
            editor.setInput(this.handle, this.getExpressionProvider(), false);
            if (editor.open() == 0) {
                Expression result = editor.getExpression();
                if (result == null || result.getStringExpression() == null || result.getStringExpression().length() == 0) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString((String)"MapRuleBuilder.MsgDlg.Title"), (String)Messages.getString((String)"MapRuleBuilder.MsgDlg.Msg"));
                    return;
                }
                int index = this.table.getSelectionIndex();
                this.valueList.remove(index);
                this.valueList.add(index, result);
                this.tableViewer.refresh();
                this.table.select(index);
            }
            this.updateButtons();
        } else {
            this.editBtn.setEnabled(false);
        }
    }

    private int createValueListComposite(Composite parent) {
        if (this.valueListComposite != null && !this.valueListComposite.isDisposed()) {
            return 0;
        }
        if (this.expressionValue1 != null && !this.expressionValue1.isDisposed()) {
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl().dispose();
            this.expressionValue1.dispose();
            this.expressionValue1 = null;
            this.dummy1.dispose();
            this.dummy1 = null;
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().dispose();
            this.expressionValue2.dispose();
            this.expressionValue2 = null;
            this.dummy2.dispose();
            this.dummy2 = null;
            this.andLable.dispose();
            this.andLable = null;
        }
        this.valueListComposite = new Composite(parent, 0);
        GridData gdata = new GridData(1808);
        gdata.horizontalSpan = 4;
        this.valueListComposite.setLayoutData((Object)gdata);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        this.valueListComposite.setLayout((Layout)layout);
        Group group = new Group(this.valueListComposite, 0);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        data.horizontalIndent = 0;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 5;
        group.setLayout((Layout)layout);
        new Label((Composite)group, 0).setText(Messages.getString((String)"MapRuleBuilder.label.value"));
        GridData expgd = new GridData();
        expgd.widthHint = 100;
        this.addExpressionValue = this.createMultiExpressionValue((Composite)group);
        this.addExpressionValue.setLayoutData((Object)expgd);
        this.addExpressionValue.add(CHOICE_SELECT_VALUE);
        this.addBtn = new Button((Composite)group, 8);
        this.addBtn.setText(Messages.getString((String)"MapRuleBuilder.button.add"));
        this.addBtn.setToolTipText(Messages.getString((String)"MapRuleBuilder.button.add.tooltip"));
        this.setButtonLayoutData(this.addBtn);
        this.addBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Expression value = ExpressionButtonUtil.getExpression((Control)MapRuleBuilder.this.addExpressionValue);
                if (MapRuleBuilder.this.valueList.indexOf(value) < 0) {
                    MapRuleBuilder.this.valueList.add(value);
                    MapRuleBuilder.this.tableViewer.refresh();
                    MapRuleBuilder.this.updateButtons();
                    MapRuleBuilder.this.addExpressionValue.setFocus();
                    MapRuleBuilder.this.addExpressionValue.setText("");
                } else {
                    MapRuleBuilder.this.addBtn.setEnabled(false);
                }
            }
        });
        new Label((Composite)group, 0);
        int tableStyle = 68356;
        this.table = new Table((Composite)group, tableStyle);
        data = new GridData(1808);
        data.horizontalSpan = 5;
        data.heightHint = 75;
        this.table.setLayoutData((Object)data);
        this.table.setHeaderVisible(false);
        this.table.setLinesVisible(true);
        String[] columNames = new String[]{Messages.getString((String)"MapRuleBuilder.list.item1")};
        int[] columLength = new int[]{288};
        int i = 0;
        while (i < columNames.length) {
            TableColumn column = new TableColumn(this.table, 0, i);
            column.setText(columNames[i]);
            column.setWidth(columLength[i]);
            ++i;
        }
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapRuleBuilder.this.checkEditDelButtonStatus();
            }
        });
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    MapRuleBuilder.this.delTableValue();
                }
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                MapRuleBuilder.this.editTableValue();
            }
        });
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(columNames);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.tableLableProvier);
        this.tableViewer.setContentProvider((IContentProvider)this.tableContentProvider);
        Composite rightPart = new Composite(this.valueListComposite, 0);
        data = new GridData(128);
        rightPart.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        rightPart.setLayout((Layout)layout);
        this.editBtn = new Button(rightPart, 8);
        this.editBtn.setText(Messages.getString((String)"MapRuleBuilder.button.edit"));
        this.editBtn.setToolTipText(Messages.getString((String)"MapRuleBuilder.button.edit.tooltip"));
        this.setButtonLayoutData(this.editBtn);
        GridData gd = (GridData)this.editBtn.getLayoutData();
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 0x1000008;
        this.editBtn.setLayoutData((Object)gd);
        this.editBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapRuleBuilder.this.editTableValue();
            }
        });
        this.delBtn = new Button(rightPart, 8);
        this.delBtn.setText(Messages.getString((String)"MapRuleBuilder.button.delete"));
        this.delBtn.setToolTipText(Messages.getString((String)"MapRuleBuilder.button.delete.tooltip"));
        this.setButtonLayoutData(this.delBtn);
        this.delBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapRuleBuilder.this.delTableValue();
            }
        });
        this.delAllBtn = new Button(rightPart, 8);
        this.delAllBtn.setText(Messages.getString((String)"MapRuleBuilder.button.deleteall"));
        this.delAllBtn.setToolTipText(Messages.getString((String)"MapRuleBuilder.button.deleteall.tooltip"));
        this.setButtonLayoutData(this.delAllBtn);
        gd = (GridData)this.delAllBtn.getLayoutData();
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 1;
        this.delAllBtn.setLayoutData((Object)gd);
        this.delAllBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int count = MapRuleBuilder.this.valueList.size();
                if (count > 0) {
                    MapRuleBuilder.this.valueList.clear();
                    MapRuleBuilder.this.tableViewer.refresh();
                    MapRuleBuilder.this.updateButtons();
                } else {
                    MapRuleBuilder.this.delAllBtn.setEnabled(false);
                }
            }
        });
        this.addExpressionValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MapRuleBuilder.this.checkAddButtonStatus();
                MapRuleBuilder.this.updateButtons();
            }
        });
        parent.getParent().layout(true, true);
        if (this.getButtonBar() != null) {
            this.layout();
        }
        return 1;
    }

    protected void checkAddButtonStatus() {
        if (this.addExpressionValue != null) {
            String value = this.addExpressionValue.getText();
            if (value == null || value.length() == 0 || value.trim().length() == 0) {
                this.addBtn.setEnabled(false);
                return;
            }
            if (value != null) {
                value = value.trim();
            }
            if (this.valueList.indexOf(ExpressionButtonUtil.getExpression((Control)this.addExpressionValue)) < 0) {
                this.addBtn.setEnabled(true);
            } else {
                this.addBtn.setEnabled(false);
            }
        }
    }

    protected void checkEditDelButtonStatus() {
        StructuredSelection selection;
        boolean enabled;
        if (this.tableViewer == null) {
            return;
        }
        boolean bl = enabled = this.tableViewer.getSelection() != null;
        if (enabled && this.tableViewer.getSelection() instanceof StructuredSelection && (selection = (StructuredSelection)this.tableViewer.getSelection()).toList().size() <= 0) {
            enabled = false;
        }
        this.editBtn.setEnabled(enabled);
        this.delBtn.setEnabled(enabled);
        enabled = this.table.getItemCount() > 0;
        this.delAllBtn.setEnabled(enabled);
    }

    protected List getSelectValueList() throws BirtException {
        List selectValueList = new ArrayList();
        ReportItemHandle reportItem = DEUtil.getBindingHolder((DesignElementHandle)this.currentItem);
        if (this.bindingName != null && reportItem != null) {
            Object[] arrays;
            Object[] obj;
            if (reportItem instanceof ExtendedItemHandle && (obj = ElementAdapterManager.getAdapters(reportItem, IUseCubeQueryList.class)) instanceof Object[] && (arrays = obj).length == 1 && arrays[0] != null) {
                List valueList = ((IUseCubeQueryList)arrays[0]).getQueryList(ExpressionUtility.getDataExpression(this.bindingName, ExpressionUtility.getExpressionConverter("javascript")), (ExtendedItemHandle)reportItem);
                selectValueList.addAll(valueList);
            }
            if (selectValueList.size() == 0) {
                selectValueList = SelectValueFetcher.getSelectValueFromBinding(ExpressionButtonUtil.getExpression((Control)this.expression), reportItem.getDataSet(), DEUtil.getVisiableColumnBindingsList((DesignElementHandle)this.designHandle).iterator(), false);
            }
        } else {
            ExceptionHandler.openErrorMessageBox(Messages.getString((String)"SelectValueDialog.errorRetrievinglist"), Messages.getString((String)"SelectValueDialog.noExpressionSet"));
        }
        return selectValueList;
    }

    private Composite createResourceKeyArea(Composite parent) {
        Composite resourceKeyArea = new Composite(parent, 0);
        resourceKeyArea.setLayoutData((Object)new GridData(768));
        GridLayout glayout = new GridLayout(4, false);
        resourceKeyArea.setLayout((Layout)glayout);
        GridData gd = new GridData(768);
        resourceKeyArea.setLayoutData((Object)gd);
        Label lb = new Label(resourceKeyArea, 0);
        lb.setText(Messages.getString((String)"MapRuleBuilder.Button.ResourceKey"));
        this.resourceKeytext = new Text(resourceKeyArea, 2056);
        this.resourceKeytext.setLayoutData((Object)new GridData(768));
        this.btnBrowse = new Button(resourceKeyArea, 8);
        this.btnBrowse.setLayoutData((Object)new GridData());
        this.btnBrowse.setText(Messages.getString((String)"MapRuleBuilder.Button.Browse"));
        this.btnBrowse.setToolTipText(Messages.getString((String)"MapRuleBuilder.Button.Browse.Tooltip"));
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapRuleBuilder.this.handleBrowserSelectedEvent();
            }
        });
        this.btnReset = new Button(resourceKeyArea, 8);
        this.btnReset.setLayoutData((Object)new GridData());
        this.btnReset.setText(Messages.getString((String)"MapRuleBuilder.Button.Reset"));
        this.btnReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapRuleBuilder.this.handleSelectedEvent(null);
            }
        });
        this.checkResourceKey();
        Label noteLabel = new Label(parent, 64);
        gd = new GridData(768);
        gd.horizontalSpan = 4;
        gd.widthHint = 350;
        noteLabel.setLayoutData((Object)gd);
        noteLabel.setText(Messages.getString((String)"I18nPage.text.Note"));
        return resourceKeyArea;
    }

    protected void handleBrowserSelectedEvent() {
        ResourceEditDialog dlg = new ResourceEditDialog(this.btnBrowse.getShell(), Messages.getString((String)"ResourceKeyDescriptor.title.SelectKey"));
        dlg.setResourceURL(this.getResourceURL());
        if (dlg.open() == 0) {
            this.handleSelectedEvent((String)dlg.getResult());
        }
    }

    private void handleSelectedEvent(String newValue) {
        if ("".equals(newValue)) {
            newValue = null;
        }
        this.resourceKeytext.setText(DEUtil.resolveNull((String)newValue));
    }

    private Composite createDummy(Composite parent, int colSpan) {
        Composite dummy = new Composite(parent, 0);
        GridData gdata = new GridData();
        gdata.widthHint = 22;
        gdata.horizontalSpan = colSpan;
        gdata.heightHint = 10;
        dummy.setLayoutData((Object)gdata);
        return dummy;
    }

    public void updateHandle(MapRuleHandle handle, int handleCount) {
        this.handle = handle;
        this.handleCount = handleCount;
    }

    public void setDesignHandle(DesignElementHandle handle) {
        this.designHandle = handle;
        this.initializeProviderType();
        this.inilializeColumnList(handle);
        this.initializeParamterBinding(handle);
    }

    public void setReportElement(ReportElementHandle reportItem) {
        this.currentItem = reportItem;
    }

    protected void inilializeColumnList(DesignElementHandle handle) {
        this.columnList = DEUtil.getVisiableColumnBindingsList((DesignElementHandle)handle);
    }

    private void initializeParamterBinding(DesignElementHandle handle) {
        if (handle instanceof ReportItemHandle) {
            ReportItemHandle inputHandle = (ReportItemHandle)handle;
            ArrayList<ParamBindingHandle> list = new ArrayList<ParamBindingHandle>();
            Iterator iterator = inputHandle.paramBindingsIterator();
            while (iterator.hasNext()) {
                ParamBindingHandle paramBindingHandle = (ParamBindingHandle)iterator.next();
                list.add(paramBindingHandle);
            }
            this.bindingParams = new ParamBindingHandle[list.size()];
            list.toArray(this.bindingParams);
        }
    }

    public MapRuleHandle getHandle() {
        return this.handle;
    }

    private void fillExpression(Combo control) {
        if (this.designHandle instanceof DataItemHandle && ((DataItemHandle)this.designHandle).getResultSetColumn() != null) {
            control.add(VALUE_OF_THIS_DATA_ITEM);
        }
        if (control.getItemCount() == 0) {
            control.add(DEUtil.resolveNull(null));
            control.select(control.getItemCount() - 1);
        }
    }

    protected void updateButtons() {
        this.enableInput(this.isExpressionOK());
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(this.isConditionOK());
        }
    }

    private void enableInput(boolean val) {
        this.operator.setEnabled(val);
        if (this.valueVisible != 3) {
            if (this.expressionValue1 != null && !this.expressionValue1.isDisposed()) {
                this.expressionValue1.setEnabled(val);
                ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).setEnabled(this.expressionValue1.isEnabled());
            }
            if (this.expressionValue2 != null && !this.expressionValue2.isDisposed()) {
                this.expressionValue2.setEnabled(val);
                ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).setEnabled(this.expressionValue2.isEnabled());
            }
            if (this.andLable != null && !this.andLable.isDisposed()) {
                this.andLable.setEnabled(val);
            }
        } else {
            this.setControlEnable((Control)this.valueListComposite, val);
            if (val) {
                this.checkAddButtonStatus();
                this.checkEditDelButtonStatus();
            }
        }
        if (this.display != null && !this.display.isDisposed()) {
            this.display.setEnabled(val);
        }
    }

    protected void setControlEnable(Control control, boolean bool) {
        if (control == null || control.isDisposed()) {
            return;
        }
        control.setEnabled(bool);
        Composite tmp = null;
        if (control instanceof Composite) {
            tmp = (Composite)control;
        }
        if (tmp != null && tmp.getChildren() != null) {
            int i = 0;
            while (i < tmp.getChildren().length) {
                this.setControlEnable(tmp.getChildren()[i], bool);
                ++i;
            }
        }
    }

    private boolean isExpressionOK() {
        if (this.expression == null) {
            return false;
        }
        return this.expression.getText() != null && this.expression.getText().length() != 0;
    }

    private boolean isConditionOK() {
        if (this.expression == null) {
            return false;
        }
        if (!this.isExpressionOK()) {
            return false;
        }
        return this.checkValues();
    }

    private boolean checkValues() {
        if (this.valueVisible == 3) {
            return this.valueList.size() > 0;
        }
        if (this.expressionValue1.getVisible() && (this.expressionValue1.getText() == null || this.expressionValue1.getText().length() == 0)) {
            return false;
        }
        return !this.expressionValue2.getVisible() || this.expressionValue2.getText() != null && this.expressionValue2.getText().length() != 0;
    }

    private void syncViewProperties() {
        ExpressionButtonUtil.initExpressionButtonControl((Control)this.expression, this.handle, "testExpr");
        this.operator.select(MapRuleBuilder.getIndexForOperatorValue(this.handle.getOperator()));
        String value = MapRuleBuilder.getValueForOperator(this.operator.getText());
        this.valueVisible = MapRuleBuilder.determineValueVisible(value);
        if (this.valueVisible == 3) {
            this.createValueListComposite(this.operator.getParent());
            if (this.handle != null) {
                this.valueList = new ArrayList<Expression>();
                if (this.handle.getValue1ExpressionList().getListValue() != null && this.handle.getValue1ExpressionList().getListValue().size() > 0) {
                    this.valueList.addAll(this.handle.getValue1ExpressionList().getListValue());
                }
            }
            this.tableViewer.setInput(this.valueList);
        } else {
            this.create2ValueComposite(this.operator.getParent());
            if (this.handle != null) {
                if (this.handle.getValue1ExpressionList() != null && this.handle.getValue1ExpressionList().getListValue().size() > 0) {
                    ExpressionButtonUtil.initExpressionButtonControl((Control)this.expressionValue1, (Expression)this.handle.getValue1ExpressionList().getListValue().get(0));
                }
                ExpressionButtonUtil.initExpressionButtonControl((Control)this.expressionValue2, this.handle, "value2");
            }
        }
        this.valueVisible = MapRuleBuilder.determineValueVisible(this.handle.getOperator());
        if (this.valueVisible == 0) {
            this.expressionValue1.setVisible(false);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl().setVisible(false);
            this.expressionValue2.setVisible(false);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().setVisible(false);
            this.andLable.setVisible(false);
        } else if (this.valueVisible == 1) {
            this.expressionValue1.setVisible(true);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl().setVisible(true);
            this.expressionValue2.setVisible(false);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().setVisible(false);
            this.andLable.setVisible(false);
        } else if (this.valueVisible == 2) {
            this.expressionValue1.setVisible(true);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl().setVisible(true);
            this.expressionValue2.setVisible(true);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().setVisible(true);
            this.andLable.setVisible(true);
            this.andLable.setEnabled(true);
        } else if (this.valueVisible == 3) {
            if (this.expression.getText().length() == 0) {
                this.valueListComposite.setEnabled(false);
            } else {
                this.valueListComposite.setEnabled(true);
            }
        }
        this.display.setText(DEUtil.resolveNull((String)this.handle.getDisplay()));
        this.resourceKeytext.setText(DEUtil.resolveNull((String)this.handle.getDisplayKey()));
    }

    protected void okPressed() {
        try {
            this.valueVisible = MapRuleBuilder.determineValueVisible(DEUtil.resolveNull((String)MapRuleBuilder.getValueForOperator(this.operator.getText())));
            if (this.handle == null) {
                MapRule rule = StructureFactory.createMapRule();
                rule.setProperty("operator", (Object)DEUtil.resolveNull((String)MapRuleBuilder.getValueForOperator(this.operator.getText())));
                if (this.valueVisible == 3) {
                    rule.setValue1(this.valueList);
                    rule.setValue2("");
                } else {
                    assert (!this.expressionValue1.isDisposed());
                    assert (!this.expressionValue2.isDisposed());
                    if (this.expressionValue1.getVisible()) {
                        ArrayList<Expression> valueList = new ArrayList<Expression>();
                        valueList.add(ExpressionButtonUtil.getExpression((Control)this.expressionValue1));
                        rule.setValue1(valueList);
                    } else {
                        rule.setValue1(NULL_STRING);
                    }
                    if (this.expressionValue2.getVisible()) {
                        ExpressionButtonUtil.saveExpressionButtonControl((Control)this.expressionValue2, rule, "value2");
                    } else {
                        rule.setValue2(NULL_STRING);
                    }
                }
                rule.setProperty("display", (Object)DEUtil.resolveNull((String)this.display.getText()));
                ExpressionButtonUtil.saveExpressionButtonControl((Control)this.expression, rule, "testExpr");
                this.handle = this.provider.doAddItem(rule, this.handleCount);
            } else {
                this.handle.setOperator(DEUtil.resolveNull((String)MapRuleBuilder.getValueForOperator(this.operator.getText())));
                if (this.valueVisible != 3) {
                    assert (!this.expressionValue1.isDisposed());
                    assert (!this.expressionValue2.isDisposed());
                    if (this.expressionValue1.getVisible()) {
                        ArrayList<Expression> valueList = new ArrayList<Expression>();
                        valueList.add(ExpressionButtonUtil.getExpression((Control)this.expressionValue1));
                        this.handle.setValue1(valueList);
                    } else {
                        this.handle.setValue1(NULL_STRING);
                    }
                    if (this.expressionValue2.getVisible()) {
                        ExpressionButtonUtil.saveExpressionButtonControl((Control)this.expressionValue2, this.handle, "value2");
                    } else {
                        this.handle.setValue2(NULL_STRING);
                    }
                } else {
                    this.handle.setValue1(this.valueList);
                    this.handle.setValue2("");
                }
                this.handle.setDisplay(DEUtil.resolveNull((String)this.display.getText()));
                this.handle.setDisplayKey(DEUtil.resolveNull((String)this.resourceKeytext.getText()));
                ExpressionButtonUtil.saveExpressionButtonControl((Control)this.expression, this.handle, "testExpr");
            }
        }
        catch (Exception e) {
            ExceptionUtil.handle(e);
        }
        super.okPressed();
    }

    private URL getResourceURL() {
        return SessionHandleAdapter.getInstance().getReportDesignHandle().findResource(this.getBaseName(), 5);
    }

    private String getBaseName() {
        return SessionHandleAdapter.getInstance().getReportDesignHandle().getIncludeResource();
    }

    private void checkResourceKey() {
        this.checkResourceKey(null);
    }

    private void checkResourceKey(MapRuleHandle handle) {
        this.resourceKeytext.setEnabled(true);
        this.btnBrowse.setEnabled(true);
        this.btnReset.setEnabled(true);
        String baseName = this.getBaseName();
        if (baseName == null) {
            this.btnBrowse.setEnabled(false);
        } else {
            URL resource = this.getResourceURL();
            String path = null;
            try {
                if (resource != null) {
                    path = DEUtil.getFilePathFormURL((URL)resource);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (resource == null || path == null || !new File(path).exists()) {
                this.btnBrowse.setEnabled(false);
            } else {
                this.btnBrowse.setEnabled(true);
            }
        }
        if (handle != null) {
            this.resourceKeytext.setText(DEUtil.resolveNull((String)handle.getDisplayKey()));
        }
    }

    private void initializeProviderType() {
        if (this.designHandle instanceof DataItemHandle) {
            DataItemHandle dataItem = (DataItemHandle)this.designHandle;
            if (dataItem.getContainer() instanceof ExtendedItemHandle) {
                this.provider.setExpressionType(1);
            } else {
                this.provider.setExpressionType(0);
            }
        }
    }

    protected void selectMultiValues(Combo combo) {
        String[] retValue = null;
        this.bindingName = this.getExpressionBindingName();
        if (this.bindingName == null && this.expression.getText().trim().length() > 0) {
            this.bindingName = this.expression.getText().trim();
        }
        if (this.bindingName != null) {
            try {
                List selectValueList = this.getSelectValueList();
                SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ExpressionValueCellEditor.title"));
                dialog.setMultipleSelection(true);
                dialog.setSelectedValueList(selectValueList);
                if (this.bindingParams != null) {
                    dialog.setBindingParams(this.bindingParams);
                }
                if (dialog.open() == 0) {
                    retValue = dialog.getSelectedExprValues(ExpressionButtonUtil.getCurrentExpressionConverter((Control)combo));
                }
            }
            catch (Exception ex) {
                MessageDialog.openError(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)(String.valueOf(Messages.getString((String)"SelectValueDialog.messages.error.selectVauleUnavailable")) + "\n" + ex.getMessage()));
            }
        } else {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)Messages.getString((String)"SelectValueDialog.messages.info.selectVauleUnavailable"));
        }
        if (retValue != null) {
            this.addBtn.setEnabled(false);
            if (retValue.length == 1) {
                combo.setText(DEUtil.resolveNull((String)retValue[0]));
            } else if (retValue.length > 1) {
                combo.setText("");
            }
            boolean change = false;
            int i = 0;
            while (i < retValue.length) {
                Expression expression = new Expression((Object)retValue[i], ExpressionButtonUtil.getExpression((Control)combo).getType());
                if (this.valueList.indexOf(expression) < 0) {
                    this.valueList.add(expression);
                    change = true;
                }
                ++i;
            }
            if (change) {
                this.tableViewer.refresh();
                this.updateButtons();
                combo.setFocus();
            }
        }
    }

    protected void operatorChange() {
        if (this.operator.getSelectionIndex() == -1) {
            return;
        }
        this.valueVisible = MapRuleBuilder.determineValueVisible(DEUtil.resolveNull((String)MapRuleBuilder.getValueForOperator(this.operator.getText())));
        if (this.valueVisible == 3) {
            int ret = this.createValueListComposite(this.operator.getParent());
            if (ret != 0) {
                this.valueList = new ArrayList<Expression>();
                if (this.handle != null && this.handle.getValue1ExpressionList().getListValue() != null && this.handle.getValue1ExpressionList().getListValue().size() > 0) {
                    this.valueList.addAll(this.handle.getValue1ExpressionList().getListValue());
                }
                this.tableViewer.setInput(this.valueList);
            }
        } else {
            int ret = this.create2ValueComposite(this.operator.getParent());
            if (ret != 0 && this.handle != null) {
                if (this.handle.getValue1ExpressionList() != null && this.handle.getValue1ExpressionList().getListValue().size() > 0) {
                    ExpressionButtonUtil.initExpressionButtonControl((Control)this.expressionValue1, (Expression)this.handle.getValue1ExpressionList().getListValue().get(0));
                }
                ExpressionButtonUtil.initExpressionButtonControl((Control)this.expressionValue2, this.handle, "value2");
            }
        }
        if (this.valueVisible == 0) {
            this.expressionValue1.setVisible(false);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl().setVisible(false);
            this.expressionValue2.setVisible(false);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().setVisible(false);
            this.andLable.setVisible(false);
        } else if (this.valueVisible == 1) {
            this.expressionValue1.setVisible(true);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl().setVisible(true);
            this.expressionValue2.setVisible(false);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().setVisible(false);
            this.andLable.setVisible(false);
        } else if (this.valueVisible == 2) {
            this.expressionValue1.setVisible(true);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl().setVisible(true);
            this.expressionValue2.setVisible(true);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().setVisible(true);
            this.andLable.setVisible(true);
            this.andLable.setEnabled(true);
        }
        this.updateButtons();
    }

    public int open() {
        if (this.getShell() == null) {
            this.create();
        }
        this.updateButtons();
        return super.open();
    }

    public void setExpressionProvider(ExpressionProvider expressionProvider) {
        this.expressionProvider = expressionProvider;
    }
}

